/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.eIpccType;
import cerent.cms.idl.Ucp.sIpcc;
import cerent.cms.idl.Ucp.sIpccRw;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.Ucp.xIpccInUse;
import cerent.cms.idl.Ucp.xNoSuchIpcc;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.IpccInUse;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchIpcc;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.ucp.Ipccs;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class IpccModel
extends Model {
    private NodeModelDelegate node;
    private Ipccs parent;
    private eIpccType type;
    private short neighborIndex;
    private int ifIndex;
    private int localCCId;
    private int remoteCCId;
    private sIpccRw rwAttributes;
    private Attributes attributes;
    private DeleteIpcc deleteIpcc;
    private IpccInfo ipccInfo;
    private EventDispatcher dispatcher;

    public IpccModel(NodeModelDelegate nodeModelDelegate, Ipccs ipccs, sIpcc sIpcc2, SDebug sDebug) {
        super(nodeModelDelegate.getChildDebug(IpccModel.class));
        this.node = nodeModelDelegate;
        this.parent = ipccs;
        this.type = sIpcc2.type;
        this.neighborIndex = sIpcc2.neighborIndex;
        this.ifIndex = sIpcc2.ifIndex;
        this.localCCId = sIpcc2.localCCId;
        this.remoteCCId = sIpcc2.remoteCCId;
        this.rwAttributes = sIpcc2.rwAttributes;
        this.attributes = new Attributes(nodeModelDelegate, "IpccModel::attributes");
        this.deleteIpcc = new DeleteIpcc(nodeModelDelegate, "IpccModel::deleteIpcc");
        this.ipccInfo = new IpccInfo(nodeModelDelegate, "IpccModel::ipccInfo");
        this.dispatcher = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    public void setAttributes(sIpccRw sIpccRw2) throws NoSuchIpcc, InvalidParams {
        try {
            Object[] objectArray = new Object[]{new Integer(this.localCCId), sIpccRw2};
            this.attributes.set(objectArray);
            this.rwAttributes = sIpccRw2;
        }
        catch (xNoSuchIpcc xNoSuchIpcc2) {
            throw new NoSuchIpcc(AnnotatedException.getString((Exception)((Object)xNoSuchIpcc2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            this.setChanged();
            this.updateLocal();
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public eIpccType getType() {
        return this.type;
    }

    public short getNeighborIndex() {
        return this.neighborIndex;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getLocalCCId() {
        return this.localCCId;
    }

    public int getRemoteCCId() {
        return this.remoteCCId;
    }

    public sIpccRw getRwAttributes() {
        return this.rwAttributes;
    }

    @Override
    protected void updateLocal() {
        sIpcc sIpcc2 = null;
        try {
            sIpcc2 = (sIpcc)this.ipccInfo.get();
            this.type = sIpcc2.type;
            this.neighborIndex = sIpcc2.neighborIndex;
            this.ifIndex = sIpcc2.ifIndex;
            this.remoteCCId = sIpcc2.remoteCCId;
            this.rwAttributes = sIpcc2.rwAttributes;
        }
        catch (xNoSuchIpcc xNoSuchIpcc2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchIpcc2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        super.updateLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update(): DELETED");
                    }
                    if (this.parent != null && this.node != null) {
                        this.parent.remove(this);
                    }
                    this.dispose();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + " update(): CHANGED");
                    }
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println(this.getClass().getName() + " update(): STRUCTURE CHGD");
                    break;
                }
            }
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectIpcc, this.localCCId, (Observer)this);
        }
    }

    public void delete() throws IpccInUse, NoSuchIpcc {
        try {
            Object[] objectArray = new Object[]{new Integer(this.localCCId)};
            this.deleteIpcc.set(objectArray);
            if (this.parent != null && this.node != null) {
                this.parent.remove(this);
            }
            this.dispose();
        }
        catch (xIpccInUse xIpccInUse2) {
            throw new IpccInUse(AnnotatedException.getString((Exception)((Object)xIpccInUse2)));
        }
        catch (xNoSuchIpcc xNoSuchIpcc2) {
            throw new NoSuchIpcc(AnnotatedException.getString((Exception)((Object)xNoSuchIpcc2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        this.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectIpcc, this.localCCId, (Observer)this);
        }
        super.dispose();
    }

    protected void printString(SDebug sDebug) {
        if (this.type.value() == 0) {
            sDebug.print("Type: SDCC ");
        } else if (this.type.value() == 1) {
            sDebug.print("Type: ROUTED ");
        } else {
            sDebug.print("Type: UNKNOWN ");
        }
        sDebug.println("NbrIdx: " + this.neighborIndex + " IfIdx: " + this.ifIndex + " LocalCCId: " + this.localCCId + " RemoteCCId: " + this.remoteCCId);
        sDebug.println("RwAttributes: localIpcc: " + this.rwAttributes.localIpcc.addr + " remoteIpcc: " + this.rwAttributes.remoteIpcc.addr);
        sDebug.println("RwAttributes: LmpHelloParams: HelloInterval: " + this.rwAttributes.lmpHelloParams.helloInterval + " OperationalHelloInterval: " + this.rwAttributes.lmpHelloParams.operationalHelloInterval + " HelloDeadInterval: " + this.rwAttributes.lmpHelloParams.helloDeadInterval + " operationalHelloDeadInterval: " + this.rwAttributes.lmpHelloParams.operationalHelloDeadInterval);
        sDebug.print("RwAttributes: Mtu: " + this.rwAttributes.mtu + " crcMode: ");
        if (this.rwAttributes.crcMode.value() == 0) {
            sDebug.print("16BIT");
        } else if (this.rwAttributes.crcMode.value() == 1) {
            sDebug.print("32BIT");
        } else {
            sDebug.print("UNKNOWN");
        }
        sDebug.print(" TunnelMode: ");
        if (this.rwAttributes.tunnelMode.value() == 0) {
            sDebug.println("DISABLED");
        } else if (this.rwAttributes.tunnelMode.value() == 1) {
            sDebug.println("GRE");
        } else if (this.rwAttributes.tunnelMode.value() == 2) {
            sDebug.println("IP IN IP");
        }
        this.printObservers();
    }

    private class Attributes
    extends NonCachedValue {
        public Attributes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getIpccsRef().setAttributes((Integer)objectArray[0], (sIpccRw)objectArray[1]);
        }

        public Object outer() {
            return IpccModel.this;
        }
    }

    private class DeleteIpcc
    extends NonCachedValue {
        public DeleteIpcc(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getIpccsRef().delete((Integer)objectArray[0]);
        }

        public Object outer() {
            return IpccModel.this;
        }
    }

    private class IpccInfo
    extends NonCachedValue {
        public IpccInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getIpccsRef().get(IpccModel.this.localCCId);
        }

        public Object outer() {
            return IpccModel.this;
        }
    }
}

