/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.AbstractEntitySelectorAttr;
import cerent.cms.ui.DwdmSide;
import java.awt.GridBagConstraints;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;

public abstract class AbstractPortSelectorAttr
extends AbstractEntitySelectorAttr {
    private Map<String, Set<Integer>> sideMap = new TreeMap<String, Set<Integer>>();
    private Map<Integer, TreeMap<IModuleModel, LinkedList<IEntityModel>>> portsMap = new TreeMap<Integer, TreeMap<IModuleModel, LinkedList<IEntityModel>>>();
    private Map<IModuleModel, LinkedList<IEntityModel>> passivePortsMap = new TreeMap<IModuleModel, LinkedList<IEntityModel>>();

    public AbstractPortSelectorAttr(INodeModel iNodeModel, String string, DefaultListCellRenderer defaultListCellRenderer) {
        super(iNodeModel, string, defaultListCellRenderer);
    }

    protected AbstractPortSelectorAttr(INodeModel iNodeModel, String string, boolean bl, DefaultListCellRenderer defaultListCellRenderer) {
        super(iNodeModel, string, bl, defaultListCellRenderer);
    }

    protected AbstractPortSelectorAttr(INodeModel iNodeModel, String string, boolean bl, DefaultListCellRenderer defaultListCellRenderer, GridBagConstraints gridBagConstraints) {
        super(iNodeModel, string, bl, defaultListCellRenderer, gridBagConstraints);
    }

    public IEntityModel getPort() {
        if (this.isMPOSelectorNeeded()) {
            return this.mpoCB.getSelectedEntity();
        }
        return this.portCB.getSelectedEntity();
    }

    public boolean isPassivePort() {
        return AbstractPortSelectorAttr.isPassivePort(this.getPort());
    }

    @Override
    public void clearAllModels() {
        super.clearAllModels();
        this.sideMap.clear();
        this.portsMap.clear();
        this.passivePortsMap.clear();
    }

    private String getSideLabel(IEntityModel iEntityModel) {
        return DwdmSide.getSideLabelFromOffset(iEntityModel.getSide());
    }

    protected boolean skipThisEntity(IEntityModel iEntityModel) {
        return false;
    }

    protected void loadAllPorts(IEntityModel[] iEntityModelArray) {
        if (iEntityModelArray.length > 0) {
            this.loading = true;
            this.clearAllModels();
            for (IEntityModel iEntityModel : iEntityModelArray) {
                LinkedList<IEntityModel> linkedList;
                Cloneable cloneable;
                Object object;
                Object object2;
                if (iEntityModel == null || this.skipThisEntity(iEntityModel)) continue;
                if (AbstractPortSelectorAttr.isPassivePort(iEntityModel)) {
                    object2 = iEntityModel.getModuleModel();
                    object = this.passivePortsMap.get(object2);
                    if (object == null) {
                        object = new LinkedList();
                        this.passivePortsMap.put((IModuleModel)object2, (LinkedList<IEntityModel>)object);
                    }
                    object.add((IEntityModel)iEntityModel);
                    continue;
                }
                object2 = new Integer(iEntityModel.getShelfId());
                if (this.isSideSelectorNeeded()) {
                    object = this.getSideLabel(iEntityModel);
                    this.sideCB.addItem(object);
                    cloneable = this.sideMap.get(object);
                    if (cloneable == null) {
                        cloneable = new TreeSet();
                        this.sideMap.put((String)object, (Set<Integer>)((Object)cloneable));
                    }
                    cloneable.add(object2);
                } else {
                    this.shelfCB.addItem(object2);
                }
                object = iEntityModel.getModuleModel();
                cloneable = this.portsMap.get(object2);
                if (cloneable == null) {
                    cloneable = new TreeMap();
                    this.portsMap.put((Integer)object2, (TreeMap<IModuleModel, LinkedList<IEntityModel>>)cloneable);
                }
                if ((linkedList = (LinkedList<IEntityModel>)((TreeMap)cloneable).get(object)) == null) {
                    linkedList = new LinkedList<IEntityModel>();
                    ((TreeMap)cloneable).put(object, linkedList);
                }
                linkedList.add(iEntityModel);
            }
            boolean bl = this.isPassiveCardSelected();
            this.selectorCB.restoreSelection(bl);
            if (this.passivePortsMap.isEmpty()) {
                this.selectorCB.removeSelection(true);
            } else if (this.portsMap.isEmpty()) {
                this.selectorCB.removeSelection(false);
            }
            this.updateSelectorsAndLabels();
            this.updateCardModels(bl);
            this.loading = false;
        } else {
            this.selectorCB.setEnabled(false);
            this.clearAllModels();
        }
    }

    @Override
    protected void updateCardModels(boolean bl) {
        if (this.isPassiveCardSelected()) {
            this.slotCB.clearModel();
            this.portCB.clearModel();
            this.mpoCB.clearModel();
            Object[] objectArray = this.passivePortsMap.keySet().toArray(new IModuleModel[0]);
            this.slotCB.loadModel(objectArray);
            if (objectArray.length > 0) {
                this.loadPassiveUnit((IModuleModel)objectArray[0]);
            }
        } else if (this.isSideSelectorNeeded()) {
            this.loadSelectedSide((String)this.sideCB.getItemAt(0));
        } else {
            this.loadSelectedShelf((Integer)this.shelfCB.getItemAt(0));
        }
    }

    @Override
    protected void loadSelectedSide(String string) {
        this.shelfCB.clearModel();
        Set<Integer> set = this.sideMap.get(string);
        this.shelfCB.loadModel(set.toArray(new Integer[0]));
        this.loadSelectedShelf((Integer)this.shelfCB.getItemAt(0));
    }

    @Override
    protected void loadSelectedShelf(Integer n) {
        this.slotCB.clearModel();
        this.portCB.clearModel();
        this.mpoCB.clearModel();
        if (n != null) {
            Object[] objectArray = this.filterCardsBySide(n);
            this.slotCB.loadModel(objectArray);
            if (objectArray.length > 0) {
                this.loadSelectedCard((IModuleModel)objectArray[0]);
            }
        }
    }

    private IModuleModel[] filterCardsBySide(Integer n) {
        TreeMap<IModuleModel, LinkedList<IEntityModel>> treeMap = this.portsMap.get(n);
        if (treeMap == null) {
            return new IModuleModel[0];
        }
        if (this.isSideSelectorNeeded()) {
            String string = (String)this.sideCB.getSelectedItem();
            TreeSet<IModuleModel> treeSet = new TreeSet<IModuleModel>();
            for (IModuleModel iModuleModel : treeMap.keySet()) {
                LinkedList<IEntityModel> linkedList = treeMap.get(iModuleModel);
                for (IEntityModel iEntityModel : linkedList) {
                    if (!string.equals(this.getSideLabel(iEntityModel))) continue;
                    treeSet.add(iModuleModel);
                }
            }
            return treeSet.toArray(new IModuleModel[0]);
        }
        return treeMap.keySet().toArray(new IModuleModel[0]);
    }

    @Override
    protected void loadSelectedCard(IModuleModel iModuleModel) {
        if (this.isPassiveCardSelected()) {
            this.loadPassiveUnit(iModuleModel);
        } else {
            this.loadCard(iModuleModel);
        }
    }

    private void loadCard(IModuleModel iModuleModel) {
        if (iModuleModel != null) {
            Integer n = new Integer(iModuleModel.getShelfId());
            TreeMap<IModuleModel, LinkedList<IEntityModel>> treeMap = this.portsMap.get(n);
            LinkedList<IEntityModel> linkedList = treeMap.get(iModuleModel);
            if (this.isMPOSelectorNeeded()) {
                this.mpoCB.loadModel(linkedList);
            } else {
                this.portCB.loadModel(linkedList);
            }
        } else {
            this.portCB.clearModel();
            this.mpoCB.clearModel();
        }
    }

    protected void loadPassiveUnit(IModuleModel iModuleModel) {
        if (iModuleModel != null) {
            LinkedList<IEntityModel> linkedList = this.passivePortsMap.get(iModuleModel);
            if (this.isMPOSelectorNeeded()) {
                this.mpoCB.loadModel(linkedList);
            } else {
                this.portCB.loadModel(linkedList);
            }
        } else {
            this.portCB.clearModel();
            this.mpoCB.clearModel();
        }
    }
}

