/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Ds123Media.eErrorRate;
import cerent.cms.model.BERTModel;
import cerent.cms.model.CmsNoPermissionException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.BertModeTableModel;
import cerent.cms.ui.BertStatsDialog;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class BertModePane
extends NodeProvPane {
    protected INodeModel node;
    protected Ds123LineModel[] ds3Models = null;
    protected Ds123LineModel[] ds1Models = null;
    int numLines = 0;
    protected BertModeTableModel dataModel = null;
    protected static final int PORT_NUM_WIDTH = 90;
    protected static final DefaultTableCellRenderer PORT_CELL_RENDERER = new DefaultTableCellRenderer();
    private JButton refresh;
    private JButton insertSingle;
    private JButton insertMulti;
    IUiToolkit kit;
    public static int prevSelection = 0;
    public static boolean stopFlag = false;
    private BertStatsDialog bt = null;
    private BERTModel bm = null;
    private Ds123LineModel mdl = null;
    private JPanel buttonPanel = null;
    private JButton resetButton = null;
    private CSHelpButton helpButton = null;
    private String RESET_ERROR_COUNT = "Reset Error Count";
    BertModePane pane;
    private static final SDebug db = new SDebug("BertModePane");

    public BertModePane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, BERTModel bERTModel) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        Object var6_6 = null;
        this.ds3Models = ds123LineModelArray;
        this.ds1Models = ds123LineModelArray2;
        this.getUiToolkit();
        this.bm = bERTModel;
        if (bERTModel.getBERTPortModel() == null) {
            int n;
            boolean bl = false;
            if (this.ds3Models != null) {
                for (n = 0; n < this.ds3Models.length; ++n) {
                    try {
                        if (this.ds3Models[n].getBERTConfig().mode.value() == 0) continue;
                        bERTModel.setBERTPortModel(this.ds3Models[n]);
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (!bl && this.ds1Models != null) {
                for (n = 0; n < this.ds1Models.length; ++n) {
                    try {
                        if (this.ds1Models[n].getBERTConfig().mode.value() == 0) continue;
                        bERTModel.setBERTPortModel(this.ds1Models[n]);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        this.dataModel = this.getDataModel();
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane, "Center");
        JPanel jPanel = this.addButtonPanelOnSouth();
        this.add(jPanel, "South");
        TablePropertyMgr.getColumnPrefs(this.table, ((Object)((Object)this)).getClass().getName());
    }

    protected JPanel addButtonPanelOnSouth() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(75, 25);
        this.refresh = new JButton("Refresh");
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BertModePane.this.dataModel.refreshFromModel();
            }
        });
        this.refresh.setMinimumSize(dimension);
        this.refresh.setMaximumSize(dimension);
        this.insertMulti = new JButton("Inject Bit Errors");
        this.insertMulti.setMinimumSize(dimension);
        this.pane = this;
        this.insertMulti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BertModePane.this.mdl = BertModePane.this.bm.getBERTPortModel();
                if (BertModePane.this.mdl == null) {
                    CerentDialog.errorDialog((Component)((Object)BertModePane.this.pane), (String)ErrorMsg.getString((EID)EMC.EID_BERT_NOT_CONF), (String)"BERT Error Dialog");
                    return;
                }
                BertModePane.this.bt = new BertStatsDialog(BertModePane.this.uiToolkit.getApplicationFrame(), BertModePane.this.pane, BertModePane.this.bm);
                BertModePane.this.bt.setVisible(true);
                if (BertModePane.this.bt.getChoice() != -1 && BertModePane.this.bt.getChoice() != 100) {
                    try {
                        eErrorRate eErrorRate2 = eErrorRate.from_int(BertModePane.this.bt.getChoice());
                        BertModePane.this.mdl.injectError(eErrorRate2);
                    }
                    catch (ProvisionError provisionError) {
                        EID eID = provisionError.getEID();
                        if (eID != null) {
                            BertModePane.this.displayErrorDialog(BertModePane.this.pane, (Exception)((Object)provisionError), eID);
                        } else {
                            BertModePane.this.displayErrorDialog(BertModePane.this.pane, (Exception)((Object)provisionError), CEMC.EID_PROVISION_ERROR);
                        }
                    }
                    catch (CmsNoPermissionException cmsNoPermissionException) {
                        BertModePane.this.displayErrorDialog(BertModePane.this.pane, (Exception)((Object)cmsNoPermissionException), EMC.EID_USER_NO_PREVILEGES);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                BertModePane.this.insertMulti.setEnabled(true);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.refresh);
        jPanel2.add(Box.createHorizontalStrut(this.refresh.getPreferredSize().width / 3));
        jPanel2.add(this.insertMulti);
        jPanel2.add(Box.createHorizontalStrut(this.refresh.getPreferredSize().width / 3));
        this.resetButton = new JButton(this.RESET_ERROR_COUNT);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Ds123LineModel ds123LineModel = BertModePane.this.bm.getBERTPortModel();
                    if (ds123LineModel == null) {
                        CerentDialog.errorDialog((Component)((Object)BertModePane.this.pane), (String)ErrorMsg.getString((EID)EMC.EID_BERT_NOT_CONF), (String)"BERT Error Dialog");
                        return;
                    }
                    BertModePane.this.dataModel.clearMethod();
                    BertModePane.this.dataModel.refreshFromModel();
                }
                catch (ProvisionError provisionError) {
                    EID eID = provisionError.getEID();
                    if (eID != null) {
                        BertModePane.this.displayErrorDialog(BertModePane.this.pane, (Exception)((Object)provisionError), eID);
                    } else {
                        BertModePane.this.displayErrorDialog(BertModePane.this.pane, (Exception)((Object)provisionError), CEMC.EID_PROVISION_ERROR);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jPanel2.add(this.resetButton);
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            this.resetButton.setEnabled(false);
        }
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        this.helpButton = new CSHelpButton();
        if (this.getHelpID() != null) {
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BertModePane.this.helpButton.launchHelp(BertModePane.this.getHelpID());
                }
            });
        }
        jPanel3.add(this.helpButton);
        this.helpButton.setMinimumSize(dimension);
        this.helpButton.setMaximumSize(dimension);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    @Override
    protected void addButtonPanel() {
    }

    @Override
    public void refreshFromModel() {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected BertModeTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new BertModeTableModel(iNodeModel, this.bm);
    }

    @Override
    protected AbstractLeavePageException createLeavePageException(String string) {
        if (db.on()) {
            db.println("createLeavePageException");
        }
        return new LeavePageException(string);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.BertModePane;
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }
}

