/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class DefaultViewControllerLayout {
    private static final Preferences prefs = Preferences.instance();
    private static final SDebug db = new SDebug("DefaultViewControllerLayout");
    private JPanel parent;
    private JSplitPane mainSplitPane;
    private JSplitPane upperSplitPane;
    private JTabbedPane vitalTabbedPane;
    private final String PROP_GEN_PATH = "ctc";
    private final String PROP_EXP = "explorer";
    private String splitter1Key;
    private String splitter2Key;
    private String selectedSummaryTab;
    private static final String PROP_PREFIX = "ctc";
    private static final String PROP_SPLIT1 = "layout.split1";
    private static final String PROP_SPLIT2 = "layout.split2";
    private static final String SUMMARY_TAB_SELECTION = "summary_tab_selection_index";
    private static final int MIN_UPPER_SPLIT = 220;
    private boolean splitterBug;
    private boolean disposed;

    public DefaultViewControllerLayout(JPanel jPanel) {
        this(jPanel, null);
    }

    public DefaultViewControllerLayout(JPanel jPanel, String string) {
        this.parent = jPanel;
        jPanel.setLayout(new BorderLayout());
        this.mainSplitPane = new JSplitPane(0);
        this.upperSplitPane = new JSplitPane(1);
        this.vitalTabbedPane = new JTabbedPane(1);
        this.mainSplitPane.setDividerSize(2);
        this.upperSplitPane.setDividerSize(2);
        jPanel.add((Component)this.mainSplitPane, "Center");
        this.mainSplitPane.setTopComponent(this.upperSplitPane);
        this.upperSplitPane.setLeftComponent(this.vitalTabbedPane);
        String string2 = System.getProperty("java.version");
        if (string2.startsWith("1.2")) {
            this.splitterBug = true;
        }
        this.splitter1Key = PROP_SPLIT1;
        this.splitter2Key = PROP_SPLIT2;
        this.selectedSummaryTab = SUMMARY_TAB_SELECTION;
        if (string != null) {
            this.splitter1Key = this.splitter1Key + "." + string;
            this.splitter2Key = this.splitter2Key + "." + string;
            this.selectedSummaryTab = this.selectedSummaryTab + "." + string;
        }
    }

    public void setStatusBarArea(JComponent jComponent) {
        this.parent.add((Component)jComponent, "South");
    }

    public void setComponents(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4) {
        this.mainSplitPane.setBottomComponent(jComponent2);
        this.upperSplitPane.setRightComponent(jComponent);
        this.vitalTabbedPane.removeAll();
        this.vitalTabbedPane.addTab("Summary", jComponent3);
        this.vitalTabbedPane.addTab("Network Explorer", jComponent4);
        this.upperSplitPane.setLeftComponent(this.vitalTabbedPane);
        this.updateSplitPanes();
        if (jComponent2 instanceof JComponent) {
            jComponent2.requestFocus();
        }
    }

    public void setComponents(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        this.mainSplitPane.setBottomComponent(jComponent2);
        this.upperSplitPane.setRightComponent(jComponent);
        this.upperSplitPane.setLeftComponent(jComponent3);
        this.updateSplitPanes();
        if (jComponent2 instanceof JComponent) {
            jComponent2.requestFocus();
        }
    }

    private int parseInt(String string, int n) {
        int n2;
        block2: {
            n2 = n;
            String string2 = "";
            String string3 = "";
            try {
                string2 = string;
                string3 = prefs.getProperty(PROP_PREFIX, string2, "");
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                if (!db.on()) break block2;
                db.println("error parsing pref setting: ctc." + string2 + "='" + string3 + "'");
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        return n2;
    }

    public void updateSplitPanes() {
        boolean bl;
        int n;
        this.disposed = false;
        this.upperSplitPane.resetToPreferredSizes();
        this.mainSplitPane.resetToPreferredSizes();
        int n2 = this.parseInt(this.splitter1Key, 300);
        if (n2 > 0 && !this.splitterBug) {
            this.mainSplitPane.setDividerLocation(n2);
        }
        if ((n = this.parseInt(this.splitter2Key, 220)) < 220) {
            n = 220;
        }
        if (n > 0) {
            this.upperSplitPane.setDividerLocation(n);
        }
        if (bl = prefs.getBoolean(PROP_PREFIX, "explorer", true)) {
            this.vitalTabbedPane.setEnabledAt(1, true);
            int n3 = this.parseInt(this.selectedSummaryTab, 0);
            this.vitalTabbedPane.setSelectedIndex(n3);
        } else {
            this.vitalTabbedPane.setEnabledAt(1, false);
            this.vitalTabbedPane.setSelectedIndex(0);
        }
        this.mainSplitPane.invalidate();
        this.upperSplitPane.invalidate();
        this.vitalTabbedPane.invalidate();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        prefs.setProperty(PROP_PREFIX, this.splitter1Key, Integer.toString(this.mainSplitPane.getDividerLocation()));
        prefs.setProperty(PROP_PREFIX, this.splitter2Key, Integer.toString(this.upperSplitPane.getDividerLocation()));
        prefs.setProperty(PROP_PREFIX, this.selectedSummaryTab, Integer.toString(this.vitalTabbedPane.getSelectedIndex()));
    }

    public void destroy() {
        this.parent.removeAll();
        this.parent = null;
        this.mainSplitPane.removeAll();
        this.mainSplitPane = null;
        this.upperSplitPane.removeAll();
        this.upperSplitPane = null;
        this.vitalTabbedPane.removeAll();
        this.vitalTabbedPane = null;
    }
}

