/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MaintBandwidthPane
extends AbstractPane
implements ActionListener {
    private ModuleModel moduleModel;
    private JLabel bwLabel;
    private JLabel refreshLabel;
    private JButton refreshButton;
    private final int MAX_SUPPORTED_BW;
    private static final String SONET_BW_LABEL = "STS";
    private static final String SDH_BW_LABEL = "VC4";
    private CSHelpButton helpButton;

    public MaintBandwidthPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        this(string, tabbedView, moduleModel, 48);
    }

    public MaintBandwidthPane(String string, TabbedView tabbedView, ModuleModel moduleModel, int n) {
        super(string, tabbedView);
        this.moduleModel = moduleModel;
        this.MAX_SUPPORTED_BW = n;
        this.setLayout(new BorderLayout());
        this.bwLabel = new JLabel("");
        JPanel jPanel = new JPanel();
        jPanel.add(this.bwLabel);
        this.add(jPanel, "North");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout(25, 25));
        this.refreshButton = new JButton("Retrieve Bandwidth Usage");
        this.refreshButton.addActionListener(this);
        this.refreshLabel = new JLabel("");
        this.helpButton = new CSHelpButton(this);
        jPanel3.add((Component)this.refreshButton, "West");
        jPanel3.add((Component)this.refreshLabel, "Center");
        jPanel3.add((Component)this.helpButton, "East");
        jPanel2.add(jPanel3);
        this.add(jPanel2, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshButton) {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (actionEvent.getSource() == this.helpButton) {
            this.helpButton.launchHelp(this.getHelpID());
        }
    }

    protected void displayErrorDialog(Pane pane, Exception exception, String string) {
        CerentDialog.errorDialog((Component)pane, (Exception)exception, (String)string);
    }

    @Override
    public void leavingPage() throws Exception {
        this.moduleModel.deleteObserver((Observer)((Object)this));
    }

    @Override
    public void enteringPage() throws Exception {
        this.moduleModel.addObserver((Observer)((Object)this));
        this.refresh();
    }

    @Override
    public void refresh() throws Exception {
        int n = this.moduleModel.getBandwidthUsage();
        String string = "Current bandwidth usage is ";
        string = this.moduleModel.getNodeModel().getTdmProtocolTypeObj().isSonet() ? string + n + " of " + this.MAX_SUPPORTED_BW + " " + SONET_BW_LABEL + "." : string + n / 3 + " of " + this.MAX_SUPPORTED_BW / 3 + " " + SDH_BW_LABEL + ".";
        this.bwLabel.setText(string);
        this.refreshLabel.setText("Bandwidth Usage last retrieved at " + new Date());
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.MaintBandwidthPane;
    }
}

