/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.DataSourceControl;
import cerent.cms.ui.IProvisioning;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class ObserverProvPane
extends ObserverPane
implements IProvisioning {
    public static final String APPLY = "Apply";
    public static final String RESET = "Reset";
    public static final String HELP = "Help";
    private JButton applyButton;
    private JButton resetButton;
    private CSHelpButton helpButton;
    private JPanel buttonPanel = null;
    private DataSourceControl dsControl;
    private static final SDebug db = new SDebug("ObserverProvPane");

    public ObserverProvPane(String string, TabbedView tabbedView, DataSourceControl dataSourceControl) {
        super(string, tabbedView, (RoDataSourceControl)dataSourceControl);
        this.dsControl = dataSourceControl;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        if (!this.hasSubTabs()) {
            this.addButtonPanel();
        }
    }

    public ObserverProvPane(String string, TabbedView tabbedView) {
        this(string, tabbedView, (DataSourceControl)null);
    }

    @Override
    public void setDataSourceControl(RoDataSourceControl roDataSourceControl) {
        this.setDataSourceControl((DataSourceControl)roDataSourceControl);
    }

    public void setDataSourceControl(DataSourceControl dataSourceControl) {
        super.setDataSourceControl((RoDataSourceControl)dataSourceControl);
        this.dsControl = dataSourceControl;
    }

    public boolean hasSubTabs() {
        return false;
    }

    protected void addButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = this.getButtonPanel();
            this.add(this.buttonPanel, "East");
        }
    }

    protected void addHelpPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = this.getHelpPanel();
            this.add(this.buttonPanel, "South");
        }
    }

    protected void removeButtonPanel() {
        if (this.buttonPanel != null) {
            this.remove(this.buttonPanel);
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.getDSC() == null) {
            return;
        }
        if (this.dsControl.isDirty()) {
            this.dsControl.refreshFromModel();
            if (db.on()) {
                db.println("enteringPage: " + this.getName() + " is dirty");
            }
            this.resetDirty();
        }
        super.enteringPage();
    }

    protected int getLeavingPageOption() {
        return CerentDialog.cancelableQuestionDialog((Component)((Object)this), (String)"Apply changes?", (String)"Changes Not Applied");
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.getDSC() == null) {
            return;
        }
        this.stopTableCellEditing();
        if (this.dsControl.isDirty()) {
            int n = this.getLeavingPageOption();
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("leavingPage: applying " + this.getName());
                    }
                    this.apply();
                    break;
                }
                case 1: {
                    if (!db.on()) break;
                    db.println("leavingPage: abandoning changes to " + this.getName());
                    break;
                }
                default: {
                    if (db.on()) {
                        db.println("leavingPage: canceling change from " + this.getName());
                    }
                    throw new LeavePageException("Page change canceled by user");
                }
            }
        }
        super.leavingPage();
    }

    public final void setDirty() {
        this.setDirty(true);
    }

    public final void resetDirty() {
        this.setDirty(false);
    }

    public final void setDirty(boolean bl) {
        if (this.getDSC() == null) {
            return;
        }
        if (db.on()) {
            db.println("setDirty: " + this.getName() + ": " + this.dsControl.isDirty() + " -> " + bl);
        }
        this.dsControl.setDirty(bl);
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.dsControl.isDirty());
        }
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        this.applyButton = new JButton(APPLY);
        this.applyButton.setMaximumSize(dimension);
        this.applyButton.setMinimumSize(dimension);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObserverProvPane.this.apply();
            }
        });
        this.applyButton.setEnabled(false);
        this.resetButton = new JButton(RESET);
        this.resetButton.setMaximumSize(dimension);
        this.resetButton.setMinimumSize(dimension);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObserverProvPane.this.reset();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 5));
        jPanel.add(this.applyButton);
        jPanel.add(this.resetButton);
        AbstractButton[] abstractButtonArray = this.getExtraButtons();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            jPanel.add(abstractButtonArray[i]);
        }
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ObserverProvPane.this.helpButton.launchHelp(ObserverProvPane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            jPanel.add(this.helpButton);
        } else if (db.on()) {
            db.warning("No HelpID returned for " + ((Object)((Object)this)).getClass().getName());
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private JPanel getHelpPanel() {
        Dimension dimension = new Dimension(75, 25);
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ObserverProvPane.this.helpButton.launchHelp(ObserverProvPane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            jPanel.add((Component)this.helpButton, "East");
        } else if (db.on()) {
            db.warning("No HelpID returned for " + ((Object)((Object)this)).getClass().getName());
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "East");
        return jPanel2;
    }

    protected AbstractButton[] getExtraButtons() {
        return new JButton[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply() {
        if (this.getDSC() == null) {
            return;
        }
        try {
            if (this.dsControl.isDirty()) {
                this.setCursor(3);
                this.stopTableCellEditing();
                if (!this.dsControl.validateData()) {
                    return;
                }
                this.dsControl.applyToModel();
                this.resetDirty();
                this.applyToModelOk();
            }
            EventBus.instance().notifyEvent((Object)this.getFullName(), (Object)APPLY);
        }
        catch (CmsNodeUpgradingException cmsNodeUpgradingException) {
            this.displayErrorDialog(this, (Exception)((Object)cmsNodeUpgradingException), CEMC.EID_NODE_UPGRADING_EXCEPTION);
        }
        catch (Exception exception) {
            this.displayErrorDialog(this, exception, CEMC.EID_FAIL_APPLY_CHANGES);
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void displayErrorDialog(Pane pane, Exception exception, EID eID) {
        ErrorMsg.displayDetailed((Component)pane, eID, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        if (this.getDSC() == null) {
            return;
        }
        try {
            this.setCursor(3);
            this.cancelTableCellEditing();
            this.dsControl.refreshFromModel();
            this.resetDirty();
        }
        catch (Exception exception) {
            db.println("Caught exception in reset");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void applyToModelOk() {
    }

    private DataSourceControl getDSC() {
        if (this.dsControl == null) {
            db.println("ERROR: Attempt to access ObserverProvPane without setting the MDSC!");
            SDebug.printStackTrace((Throwable)new Exception());
        }
        return this.dsControl;
    }
}

