/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Optics.eVOAControlMode;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotReady;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class OpticalTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int RING_DIRECTION_INDEX = 4;
    public static final int ACTUAL_POWER_INDEX = 5;
    public static final int POWER_REF_INDEX = 6;
    public static final int POWER_CAL_INDEX = 7;
    public static final int VOA_MODE_INDEX = 8;
    public static final int VOA_POWREF_INDEX = 9;
    public static final int VOA_POWCAL_INDEX = 10;
    public static final int VOA_ATTENREF_INDEX = 11;
    public static final int VOA_ATTENCAL_INDEX = 12;
    public static final int NUM_CHANNEL_INDEX = 13;
    public static final int OTM_MAX_COLUMNS = 14;
    public String[] otmColumnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "Line Direction", "Power", "Power Ref.", "Power Calib.", "VOA Mode", "VOA Power Ref.", "VOA Power Calib.", "VOA Attenuation Ref.", "VOA Attenuation Calib.", "Active Channels"};
    public static final int OUT_OF_SERVICE = 1;
    public static final int IN_SERVICE = 0;
    public static final int OOS_MT = 2;
    public static final int IS_AINS = 3;
    public static final int CONSTANT_ATTENUATION = 1;
    public static final int CONSTANT_POWER = 0;
    public static final int VALUE_OUT_OF_RANGE = 3;
    public static final int THR_ADJUST_FAILED = 6;
    public static final int POWER_CALIBRATION_NOT_ALLOWED = 7;
    public static final int GAIN_VALUE_OUT_OF_RANGE = 14;
    public static final String[] VOAModeStrings = new String[]{"Constant Power", "Constant Attenuation"};
    protected AbstractOpticsLineModel[] model;
    protected int numLines;
    protected EntityCellRenderer myPortRenderer;
    private String[] portNames;
    protected ModuleModel eqpmtModel;
    protected TDMTerminology _terms;
    protected String[] statusStrings;
    protected String[] VOAAttenCal;
    protected String[] VOAPowerCal;
    private String[] PowerCal;
    protected boolean[][] Flg_FeatureUnsupported;
    protected eDwdmRingType ringtype;
    private AdminState[] adminState;
    private IServiceState[] serviceState;
    protected int[] VOAMode;
    protected boolean[][] isDirty;
    protected boolean FlgOkDialog = false;
    protected boolean FlgAdminStateChanged = false;
    protected NodeModelDelegate node;
    private OpticsModuleModel om;
    protected boolean[] removedColumns;
    private final SDebug db;

    protected OpticalTableModel(SDebug sDebug, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        this(sDebug, abstractOpticsLineModelArray, null);
    }

    protected OpticalTableModel(SDebug sDebug, AbstractOpticsLineModel[] abstractOpticsLineModelArray, OpticsModuleModel opticsModuleModel) {
        this.db = sDebug;
        this.model = abstractOpticsLineModelArray;
        if (abstractOpticsLineModelArray != null) {
            this.numLines = abstractOpticsLineModelArray.length;
        }
        this.om = opticsModuleModel;
        this.init();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.db.on()) {
            this.db.println("Change in value row=" + n + " col=" + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 2: {
                    if (((AdminState)object).equals(this.adminState[n])) break;
                    this.adminState[n] = (AdminState)object;
                    break;
                }
                case 7: {
                    this.PowerCal[n] = (String)object;
                    break;
                }
                case 12: {
                    this.VOAAttenCal[n] = (String)object;
                    break;
                }
                case 10: {
                    this.VOAPowerCal[n] = (String)object;
                }
            }
        }
        catch (ClassCastException classCastException) {
            KDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    protected void init() {
        int n;
        this.myPortRenderer = new EntityCellRenderer(false);
        if (this.om == null) {
            this.node = this.model[0].getNodeModelDelegate();
            try {
                this.eqpmtModel = (OpticsModuleModel)this.model[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                abstractCmsNoSuchEntityException.printStackTrace();
            }
        } else {
            this.node = this.om.getNodeModelDelegate();
            this.eqpmtModel = this.om;
        }
        try {
            this.ringtype = this.node.getANSManager().getNeANSModel().getDwdmRingType();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.ringtype = eDwdmRingType.METRO_CORE;
        }
        this._terms = this.node.getTDMTerminology();
        this.statusStrings = new String[]{AdminState.getAdminTermIS(this._terms), AdminState.getAdminTermDSBLD(this._terms), AdminState.getAdminTermMT(this._terms), AdminState.getAdminTermAINS(this._terms)};
        this.portNames = new String[this.numLines];
        this.VOAAttenCal = new String[this.numLines];
        this.VOAPowerCal = new String[this.numLines];
        this.PowerCal = new String[this.numLines];
        this.Flg_FeatureUnsupported = new boolean[this.numLines][this.getColumnCount()];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.VOAMode = new int[this.numLines];
        this.setFeatureUnsupported();
        for (n = 0; n < this.numLines; ++n) {
            this.VOAAttenCal[n] = null;
            this.VOAPowerCal[n] = null;
            this.PowerCal[n] = null;
            this.VOAMode[n] = -1;
        }
        this.removedColumns = new boolean[this.getColumnCount()];
        for (n = 0; n < this.getColumnCount(); ++n) {
            this.removedColumns[n] = false;
        }
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    public void addToRemovedColumns(int n) {
        this.removedColumns[n] = true;
    }

    private void setFeatureUnsupported() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.Flg_FeatureUnsupported[i][j] = true;
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block17: {
            try {
                switch (n2) {
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 0: {
                        return this.getPortDescription(n);
                    }
                    case 8: {
                        return this.getVOAMode(n);
                    }
                    case 7: {
                        return this.getPowerCal(n);
                    }
                    case 10: {
                        return this.getVOAPowerCal(n);
                    }
                    case 11: {
                        return this.getVOAAttenuationRef(n);
                    }
                    case 12: {
                        return this.getVOAAttenuationCal(n);
                    }
                    case 6: {
                        return this.getPowerRef(n);
                    }
                    case 9: {
                        return this.getVOARefPower(n);
                    }
                    case 13: {
                        return this.getNumCHan(n);
                    }
                    case 2: {
                        return this.getAdminState(n).toString(this.getTerms());
                    }
                    case 3: {
                        return this.getServiceState(n).toString(this.getTerms());
                    }
                    case 5: {
                        return this.getActPower(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block17;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "";
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0 || this.numLines == 0) {
            if (this.db.on()) {
                this.db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("refresh from model line: " + n);
        }
        block11: for (int i = 0; i < 14; ++i) {
            switch (i) {
                case 1: {
                    if (this.removedColumns[1]) continue block11;
                    this.portNames[n] = this.getPortName(n);
                    continue block11;
                }
                case 12: {
                    if (this.removedColumns[12]) continue block11;
                    this.VOAAttenCal[n] = this.getVOAAttenuationCal(n);
                    continue block11;
                }
                case 10: {
                    if (this.removedColumns[10]) continue block11;
                    this.VOAPowerCal[n] = this.getVOAPowerCal(n);
                    continue block11;
                }
                case 7: {
                    if (this.removedColumns[7]) continue block11;
                    this.PowerCal[n] = this.getPowerCal(n);
                    continue block11;
                }
                case 9: {
                    if (this.removedColumns[9]) continue block11;
                    this.getVOARefPower(n);
                    continue block11;
                }
                case 11: {
                    if (this.removedColumns[11]) continue block11;
                    this.getVOAAttenuationRef(n);
                    continue block11;
                }
                case 8: {
                    if (this.removedColumns[8]) continue block11;
                    this.getVOAMode(n);
                }
            }
        }
        try {
            this.adminState[n] = AdminState.enumToAdminState(this.getAdminStateFromModel(n));
        }
        catch (NoSuchInterface noSuchInterface) {
            this.adminState[n] = AdminState.NULL_STATE;
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        if (n > this.numLines || n < 0 || this.numLines == 0) {
            if (this.db.on()) {
                this.db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.portNames[n] = null;
        this.VOAAttenCal[n] = null;
        this.VOAPowerCal[n] = null;
        this.PowerCal[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.VOAMode[n] = -1;
        this.resetDirtyBits(n);
    }

    private eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.model[n].getAdminStateEnum();
    }

    protected Frame getFrame() {
        return this.node.getUiToolkit().getApplicationFrame();
    }

    private String getPortName(int n) {
        block3: {
            if (this.portNames[n] == null) {
                try {
                    this.portNames[n] = this.model[n].getAlias();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!this.db.on()) break block3;
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
        }
        return this.portNames[n];
    }

    private String getType(int n) {
        try {
            return this.model[n].getOptPortTypeString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    protected boolean isUserAuthorized(SecurityLevel securityLevel) {
        return this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], securityLevel);
    }

    protected TDMTerminology getTerms() {
        return this._terms;
    }

    public String[] getStatusStrings() {
        return this.statusStrings;
    }

    private String getPowerRef(int n) {
        String string;
        block3: {
            string = "N/A";
            try {
                int n2 = this.model[n].getReferencePower();
                if (n2 != -1000000) {
                    string = ConvertPwrToDb.formatDecimalNumber(n2);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    protected String getVOARefPower(int n) {
        String string;
        block3: {
            string = "N/A";
            try {
                int n2 = this.model[n].getVoaReferencePower();
                if (n2 != -1000000) {
                    string = ConvertPwrToDb.formatDecimalNumber(n2);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getPowerCal(int n) {
        if (this.PowerCal[n] == null) {
            this.Flg_FeatureUnsupported[n][7] = true;
            try {
                int n2 = this.model[n].getCalibratedPower();
                if (n2 != -1000000) {
                    this.PowerCal[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][7] = false;
                } else {
                    this.PowerCal[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.PowerCal[n] = "N/A";
            }
        }
        return this.PowerCal[n];
    }

    protected String getVOAPowerCal(int n) {
        if (this.VOAPowerCal[n] == null) {
            this.Flg_FeatureUnsupported[n][10] = true;
            try {
                int n2 = this.model[n].getVoaCalibrationPower();
                if (n2 != -1000000) {
                    this.Flg_FeatureUnsupported[n][10] = false;
                    this.VOAPowerCal[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                } else {
                    this.VOAPowerCal[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.VOAPowerCal[n] = "N/A";
            }
        }
        return this.VOAPowerCal[n];
    }

    private void setPowerCal(int n) {
        if (OpticalTableModel.isValidNumber(this.PowerCal[n], "Power Cal.")) {
            float f = Float.parseFloat(this.PowerCal[n]) * 10.0f;
            try {
                this.model[n].setCalibratedPower((int)f);
            }
            catch (ProvisionError provisionError) {
                int n2 = provisionError.getDiscriminator();
                switch (n2) {
                    case 3: {
                        int n3 = provisionError.getLoValue();
                        String string = ConvertPwrToDb.formatDecimalNumber(n3);
                        int n4 = provisionError.getHiValue();
                        String string2 = ConvertPwrToDb.formatDecimalNumber(n4);
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "the sum of the power offset and the power reference", string, string2 + (this.ringtype != eDwdmRingType.NOT_DWDM ? ".\nThe power offset can be raised or lowered 1 unit at a time" : ""));
                        break;
                    }
                    case 6: {
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_THR_ADJ_FAILED_PARAM_2, "The new setpoint would either make the thresholds\n", "inconsistent or set the fail threshold outside the range.");
                        break;
                    }
                    case 7: {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWERCAL_NOT_ALLOWED);
                        break;
                    }
                    case 14: {
                        int n5 = provisionError.getLoValue();
                        String string = ConvertPwrToDb.formatDecimalNumber(n5);
                        int n6 = provisionError.getHiValue();
                        String string3 = ConvertPwrToDb.formatDecimalNumber(n6);
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "the sum of the gain offset and the gain reference", string, string3 + (this.ringtype != eDwdmRingType.NOT_DWDM ? ".\nThe gain offset can be raised or lowered 1 unit at a time" : ""));
                    }
                }
                this.PowerCal[n] = null;
                this.getPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
            catch (Exception exception) {
                this.PowerCal[n] = null;
                this.getPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.PowerCal[n] = null;
            this.getPowerCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    protected void setVOAPowerCal(int n) {
        if (OpticalTableModel.isValidNumber(this.VOAPowerCal[n], "VOA Power Cal.")) {
            float f = Float.parseFloat(this.VOAPowerCal[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                this.model[n].setVOACalibrationPower(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = ConvertPwrToDb.formatDecimalNumber(n4);
                    int n5 = provisionError.getHiValue();
                    String string2 = ConvertPwrToDb.formatDecimalNumber(n5);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "VOA Power", string, string2);
                    this.VOAPowerCal[n] = null;
                    this.getVOAPowerCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.VOAPowerCal[n] = null;
                this.getVOAPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.VOAPowerCal[n] = null;
            this.getVOAPowerCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    protected String getVOAAttenuationRef(int n) {
        String string;
        block3: {
            string = "N/A";
            try {
                int n2 = this.model[n].getVoaReferenceAttenuation();
                if (n2 != -1000000) {
                    string = ConvertPwrToDb.formatDecimalNumber(n2);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    protected String getVOAAttenuationCal(int n) {
        if (this.VOAAttenCal[n] == null) {
            this.Flg_FeatureUnsupported[n][12] = true;
            try {
                int n2 = this.model[n].getVoaCalibrationAttenuation();
                if (n2 != -1000000) {
                    this.Flg_FeatureUnsupported[n][12] = false;
                    this.VOAAttenCal[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                } else {
                    this.VOAAttenCal[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.VOAAttenCal[n] = "N/A";
            }
        }
        return this.VOAAttenCal[n];
    }

    protected void setVOAAttenCal(int n) {
        if (OpticalTableModel.isValidNumber(this.VOAAttenCal[n], "VOA Power Cal.")) {
            float f = Float.parseFloat(this.VOAAttenCal[n]) * 10.0f;
            try {
                this.model[n].setVoaCalibrationAttenuation((int)f);
            }
            catch (ProvisionError provisionError) {
                int n2 = provisionError.getDiscriminator();
                if (n2 == 3) {
                    int n3 = provisionError.getLoValue();
                    String string = ConvertPwrToDb.formatDecimalNumber(n3);
                    int n4 = provisionError.getHiValue();
                    String string2 = ConvertPwrToDb.formatDecimalNumber(n4);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "The sum of the VOA attenuation calibration and the VOA attenuation reference ", string, string2);
                    this.VOAAttenCal[n] = null;
                    this.getVOAAttenuationCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.VOAAttenCal[n] = null;
                this.getVOAAttenuationCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.VOAAttenCal[n] = null;
            this.getVOAAttenuationCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private Object getNumCHan(int n) {
        try {
            return new Integer(this.model[n].getWorkingChannel());
        }
        catch (NoSuchInterface noSuchInterface) {
            noSuchInterface.printStackTrace();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            wrongInterfaceType.printStackTrace();
        }
        catch (InternalCommError internalCommError) {
            internalCommError.printStackTrace();
        }
        catch (FeatureUnsupported featureUnsupported) {
            featureUnsupported.printStackTrace();
        }
        catch (NotReady notReady) {
            // empty catch block
        }
        return "N/A";
    }

    public static boolean isValidNumber(String string, String string2) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public int getColumnCount() {
        return this.otmColumnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.otmColumnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    protected boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    protected boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    protected void resetDirtyBits() {
        this.FlgOkDialog = false;
        this.FlgAdminStateChanged = false;
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    protected void resetDirtyBits(int n) {
        this.FlgOkDialog = false;
        this.FlgAdminStateChanged = false;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    private String getPortDescription(int n) {
        String string;
        Object object;
        try {
            object = this.model[n].getPortModel();
            string = PortHelper.getPortNumString((IPortModel)object);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            string = String.valueOf(n + 1);
        }
        object = string + " (" + this.getType(n) + ")";
        return object;
    }

    @Override
    public AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    @Override
    public boolean isAdminStateDirty(int n) {
        return this.isDirty(n, 2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 1 || n2 == 2) {
            return true;
        }
        if (n2 == 7 || n2 == 10 || n2 == 12) {
            return !this.Flg_FeatureUnsupported[n][n2];
        }
        return false;
    }

    protected String getVOAMode(int n) {
        if (this.VOAMode[n] == -1) {
            try {
                eVOAControlMode eVOAControlMode2 = this.model[n] != null ? this.model[n].getVoaMode() : eVOAControlMode.ATTENUATION_CONTROL;
                this.VOAMode[n] = eVOAControlMode2 == eVOAControlMode.ATTENUATION_CONTROL ? 1 : 0;
            }
            catch (Exception exception) {
                return "N/A";
            }
        }
        return VOAModeStrings[this.VOAMode[n]];
    }

    protected String getActPower(int n) {
        return this.model[n].getActualPowerString();
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if ((this.isDirty[n][12] || this.isDirty[n][10] || this.isDirty[n][7]) && !this.FlgOkDialog) {
                    if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"The selected operation could be service affecting. Is it OK to apply the changes anyway?", (String)"Confirmation Dialog")) {
                        this.FlgOkDialog = true;
                    } else {
                        this.refreshFromModel();
                        return;
                    }
                }
                if (this.isDirty[n][1]) {
                    this.model[n].setAlias(this.getPortName(n));
                }
                if (this.isDirty(n, 2)) {
                    this.FlgAdminStateChanged = true;
                    this.model[n].setAdminState(this.getAdminState(n).getAdminStateEnum());
                    this.serviceState[n] = null;
                }
                if (this.isDirty[n][12]) {
                    this.setVOAAttenCal(n);
                }
                if (this.isDirty[n][10]) {
                    this.setVOAPowerCal(n);
                }
                if (!this.isDirty[n][7]) continue;
                this.setPowerCal(n);
            }
            this.refreshFromModel();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (this.FlgAdminStateChanged) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED);
            } else {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            }
            this.refreshFromModel();
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
    }

    public String[] getringDirectionStrings() {
        return DwdmSide.getAllSides();
    }
}

