/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModuleModel;
import cerent.cms.model.ML2EnhModuleModel;

public class RprHelper {
    public static final String RPR_EAST = "RPR East";
    public static final String RPR_WEST = "RPR West";
    public static final int RPR_PORT_EAST = 0;
    public static final int RPR_PORT_WEST = 1;
    public static final String WEST = "West";
    public static final String EAST = "East";
    public static final String RPR = "RPR";
    public static final String POS = "POS";

    private RprHelper() {
    }

    public static String getRprPosTabName(IModuleModel iModuleModel) {
        String string = iModuleModel.isRPRMode() ? "RPR Span" : "POS Ports";
        return string;
    }

    private static boolean isRprLabel(String string) {
        boolean bl = false;
        if (EAST.equals(string) || WEST.equals(string) || RPR.equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static boolean needsLabelChange(IModuleModel iModuleModel, String string) {
        boolean bl = false;
        if (iModuleModel.inRPRMode()) {
            if (!RprHelper.isRprLabel(string)) {
                bl = true;
            }
        } else if (RprHelper.isRprLabel(string)) {
            bl = true;
        }
        return bl;
    }

    public static String getPosRPRLabel(IModuleModel iModuleModel) {
        if (iModuleModel.inRPRMode()) {
            return RPR;
        }
        return POS;
    }

    public static String getPOSNumOrEastWestLabel(IModuleModel iModuleModel, int n) {
        String string = null;
        if (iModuleModel instanceof ML2EnhModuleModel) {
            if (n == iModuleModel.getRPREastPort()) {
                return EAST;
            }
            if (n == iModuleModel.getRPRWestPort()) {
                return WEST;
            }
        }
        if (iModuleModel.inRPRMode()) {
            if (n == 0) {
                string = EAST;
            } else if (n == 1) {
                string = WEST;
            }
        } else {
            string = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        }
        return string;
    }

    public static String getSoakTabName(IModuleModel iModuleModel) {
        String string = null;
        string = iModuleModel.inRPRMode() ? "RPR Span Soak" : "POS Port Soak";
        return string;
    }
}

