/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.ui.WizardDialog;
import cerent.util.SDebug;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.lang.reflect.InvocationTargetException;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class WizardDriver
implements ProgressDialogControl {
    private WizardDialog dialog;
    private int driveCount;
    private int driveOffset;
    private int pageCount;
    private int progress;
    private int progressRange;
    private Runnable resetDialog;
    private Runnable nextPage;
    private Runnable finishDialog;
    private Thread executeThread;
    private boolean interrupted = false;
    private Exception storedException = null;
    private static int napTime = 100;
    private static final SDebug db = new WDDebug("WizardDriver");

    public WizardDriver(WizardDialog wizardDialog, int n, int n2) {
        this.dialog = wizardDialog;
        this.driveCount = n;
        this.driveOffset = n2;
        this.pageCount = this.dialog.getPageCount();
        this.progress = 0;
        this.progressRange = this.driveCount * this.pageCount;
        this.resetDialog = new Runnable(){

            @Override
            public void run() {
                WizardDriver.this.dialog.reset();
            }
        };
        this.nextPage = new Runnable(){

            @Override
            public void run() {
                WizardDriver.this.dialog.next();
            }
        };
        this.finishDialog = new Runnable(){

            @Override
            public void run() {
                WizardDriver.this.dialog.finish();
            }
        };
    }

    public void executeTask(Observer observer) throws Exception {
        if (WizardDriver.db.on) {
            db.println("replay: about to start: driveCount = " + this.driveCount + ", pageCount = " + this.pageCount);
        }
        this.executeThread = Thread.currentThread();
        long l = -1L;
        try {
            if (WizardDriver.db.on) {
                l = System.currentTimeMillis();
                db.println("In start of Apply ");
            }
            for (int i = 1; i <= this.driveCount; ++i) {
                String string = " (" + (i + this.driveOffset) + " of " + (this.driveCount + this.driveOffset) + ")";
                if (WizardDriver.db.on) {
                    db.println("run: about to reset: driveNum = " + i);
                }
                SwingUtilities.invokeAndWait(this.resetDialog);
                if (this.shouldStop()) {
                    return;
                }
                for (int j = 1; j < this.pageCount; ++j) {
                    observer.update(null, this.dialog.getPageName() + string);
                    if (WizardDriver.db.on) {
                        db.println("run: invoking next on page " + this.dialog.getPageName());
                    }
                    SwingUtilities.invokeAndWait(this.nextPage);
                    if (this.shouldStop()) {
                        return;
                    }
                    observer.update(null, this.incrementProgress());
                    this.nap();
                    if (!this.shouldStop()) continue;
                    return;
                }
                observer.update(null, this.dialog.getPageName() + string);
                if (WizardDriver.db.on) {
                    db.println("run: invoking finish on page " + this.dialog.getPageName());
                }
                SwingUtilities.invokeAndWait(this.finishDialog);
                observer.update(null, this.incrementProgress());
                this.nap();
            }
            if (WizardDriver.db.on) {
                db.println("Total Time " + (System.currentTimeMillis() - l));
            }
        }
        catch (InterruptedException interruptedException) {
            if (WizardDriver.db.on) {
                db.println("run: caught InterruptedException");
            }
            throw interruptedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (WizardDriver.db.on) {
                db.println("run: caught InvocationTargetException");
            }
            throw (Exception)invocationTargetException.getTargetException();
        }
        finally {
            if (WizardDriver.db.on) {
                db.println("run: cleaning up");
            }
            this.dialog.setDriver(null);
        }
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public synchronized ProgressDialogResult getResult(Exception exception) {
        return this.interrupted ? null : new ProgressDialogResult(this.dialog.getResultString(exception));
    }

    public synchronized void stop(Exception exception) {
        this.storedException = exception;
        this.interrupted = true;
    }

    public synchronized void stop() {
        this.interrupted = true;
    }

    public boolean stopRequired() {
        return this.interrupted;
    }

    public void suspend() {
    }

    public void resume() {
    }

    private synchronized boolean shouldStop() throws Exception {
        boolean bl = false;
        if (this.interrupted) {
            if (WizardDriver.db.on) {
                db.println("shouldStop: driver was interrupted");
            }
            bl = true;
            if (this.storedException != null) {
                throw this.storedException;
            }
        }
        return bl;
    }

    private Integer incrementProgress() {
        return new Integer(++this.progress * 100 / this.progressRange);
    }

    private void nap() {
        try {
            if (napTime > 0) {
                Thread.sleep(napTime);
            }
        }
        catch (InterruptedException interruptedException) {
            db.finest("InterruptedException in nap() " + interruptedException);
        }
    }

    public static class WDDebug
    extends SDebug {
        public WDDebug(String string) {
            super(string);
        }

        public void setNapTime(int n) {
            napTime = n;
        }
    }
}

