/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.ModalFrameUtil;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDriver;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.WzStatusPanel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public abstract class WzDialog
extends JFrame
implements ActionListener {
    public static final int MARGIN = 5;
    protected static final int OP_BACK = 0;
    protected static final int OP_NEXT = 1;
    protected JPanel mainPanel = new JPanel();
    protected JPanel currentPanel = new JPanel();
    protected JPanel buttonPanel = new JPanel();
    protected JLabel statusLabel = new JLabel("");
    private static final String FINISH = "Finish";
    private static final String BACK = "<Back";
    private static final String NEXT = "Next>";
    private static final String CANCEL = "Cancel";
    private static final String APPLY = "Apply";
    protected JButton finishButton;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton cancelButton;
    protected JButton applyButton;
    protected CSHelpButton helpButton;
    protected boolean enableCSH;
    protected WzStatusPanel statusPanel;
    protected JScrollPane statusScrollPane;
    protected JSplitPane splitter;
    protected HashMap wzPaneMap = new HashMap();
    protected Stack wzPaneStack = new Stack();
    protected WzPane currentWzPane;
    protected WzDiagDebug db;
    protected WzDriver driver = null;
    protected int pageCount = 0;
    private boolean disposed = false;
    private Frame owner;
    private boolean modal;

    protected WzDiagDebug makeChildDebug(String string) {
        return new WzDiagDebug(this.db, string);
    }

    public WzDialog(Frame frame, String string, WzDiagDebug wzDiagDebug, boolean bl, boolean bl2) {
        super(string);
        this.owner = frame;
        this.setIconImage(frame.getIconImage());
        this.modal = bl;
        this.db = wzDiagDebug;
        wzDiagDebug.setDialog(this);
        this.enableCSH = bl2;
        this.buttonPanel = this.getButtonPanel();
        this.currentPanel.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.initStatusPanel();
        this.splitter = new JSplitPane(1, this.statusScrollPane, this.currentPanel);
        this.splitter.setDividerLocation(225);
        this.mainPanel.add((Component)this.splitter, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add(this.mainPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WzDialog.this.cancel(true);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }
        });
    }

    protected void initStatusPanel() {
        this.statusPanel = new WzStatusPanel();
        this.statusScrollPane = new JScrollPane(this.statusPanel, 20, 30);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public void show() {
        super.show();
    }

    public void showModal() {
        if (this.modal) {
            ModalFrameUtil.showAsModal(this, this.owner);
        } else {
            this.setVisible(true);
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.applyButton = new JButton(APPLY);
        this.backButton = new JButton(BACK);
        this.nextButton = new JButton(NEXT);
        this.finishButton = new JButton(FINISH);
        this.cancelButton = new JButton(CANCEL);
        this.applyButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.applyButton.setVisible(false);
        jPanel.add(this.statusLabel);
        jPanel.add(Box.createHorizontalStrut(50));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.applyButton);
        AbstractButton[] abstractButtonArray = this.getExtraButtons();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            jPanel.add(abstractButtonArray[i]);
        }
        jPanel.add(this.backButton);
        jPanel.add(this.nextButton);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.finishButton);
        this.finishButton.setEnabled(false);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.cancelButton);
        if (this.enableCSH) {
            jPanel.add(Box.createHorizontalStrut(5));
            this.helpButton = new CSHelpButton();
            this.helpButton.addActionListener(this);
            jPanel.add(this.helpButton);
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    protected AbstractButton[] getExtraButtons() {
        return new JButton[0];
    }

    protected abstract void createPanesAndSetCurrent();

    public void pushStatusInfo(JComponent jComponent) {
        String string = this.currentWzPane.getShortName();
        this.pushStatusInfo(jComponent, string);
    }

    public void pushStatusInfo(JComponent jComponent, String string) {
        this.statusPanel.push(jComponent, string);
    }

    public JComponent popStatusInfo() {
        return this.statusPanel.pop();
    }

    public void setStatusPanelBackground(Color color) {
        this.statusPanel.setEntireBackground(color);
    }

    public void setStatusLabelText(String string) {
        this.statusLabel.setText(string);
    }

    public void clearStatusLabelText() {
        this.setStatusLabelText("");
    }

    public WzPane getPaneByName(String string) {
        return (WzPane)this.wzPaneMap.get(string);
    }

    protected void setCurrentPane(String string) {
        this.setCurrentPane(this.getPaneByName(string));
    }

    protected void setCurrentPane(WzPane wzPane) {
        this.setCurrentPane(wzPane, true);
    }

    protected void setCurrentPane(WzPane wzPane, boolean bl) {
        if (this.db.on()) {
            this.db.fine("Making pane current: " + (wzPane != null ? wzPane.getName() : "NULL") + "; enterPane flag= " + bl);
        }
        this.currentWzPane = wzPane;
        this.currentPanel.removeAll();
        this.currentPanel.add((Component)this.currentWzPane, "Center");
        if (bl) {
            try {
                this.currentWzPane.enteringPane();
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlDkShadow);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(matteBorder, this.currentWzPane.getName(), 1, 1);
        this.currentPanel.setBorder(titledBorder);
        this.currentPanel.revalidate();
        this.currentPanel.repaint();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void revalidateCurrentPane() {
        if (this.currentWzPane != null) {
            this.currentWzPane.revalidateData();
        }
    }

    protected void pushCurrentPane() {
        this.wzPaneStack.push(this.currentWzPane);
    }

    protected void popCurrentWzPane() {
        this.popCurrentWzPane(true);
    }

    protected void popCurrentWzPane(boolean bl) {
        this.currentWzPane.goingForward = true;
        WzPane wzPane = (WzPane)this.wzPaneStack.pop();
        this.setCurrentPane(wzPane, bl);
    }

    protected void popStackUntil(String string) {
        String string2;
        if (this.db.on()) {
            this.db.fine("popStackUntil() paneName=" + string);
        }
        while (!(this.currentWzPane == null || this.wzPaneStack.empty() || string != null && (string2 = this.currentWzPane.getName()).equals(string))) {
            this.popStatusInfo();
            this.popCurrentWzPane(false);
        }
        if (this.currentWzPane != null) {
            this.setCurrentPane(this.currentWzPane);
        } else if (this.db.on()) {
            this.db.println("popStackUntil() problem: wzPane is null");
        }
    }

    public void popEntireStack() {
        this.popStackUntil(null);
    }

    public void forceNext() {
        if (this.nextButton.isEnabled()) {
            this.nextButton.doClick();
        } else {
            this.db.println("could not force next, button not enabled.");
        }
    }

    public void forceBack() throws Exception {
        if (this.db.on()) {
            this.db.fine("Received request from " + this.currentWzPane.getName() + " to forceBack()");
        }
        if (this.backButton.isEnabled()) {
            this.backButton.doClick();
        }
        throw new Exception("The wizard cannot go back. The 'Back' button is not enabled.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.db.on()) {
            this.db.println("User action/actionPerformed, o= " + object);
        }
        if (object == this.applyButton) {
            this.applyChanges();
            return;
        } else if (object == this.finishButton) {
            this.finish();
            return;
        } else if (object == this.cancelButton) {
            this.cancel(true);
            return;
        } else if (object == this.backButton) {
            this.localValidation(0);
            if (this.currentWzPane == null) return;
            boolean bl = this.currentWzPane.handleBack();
            if (bl) {
                this.backButton.setEnabled(false);
                if (!this.wzPaneStack.empty()) {
                    if (this.db.on()) {
                        this.db.fine("[back] leaving currentWzPane=" + this.currentWzPane.getName());
                    }
                    this.popCurrentWzPane();
                    return;
                } else {
                    if (this.db.on()) {
                        this.db.fine("WzDialog has an empty pane stack. Calling backFromEmptyStack() to see where to go now.");
                    }
                    try {
                        this.currentWzPane.goingForward = true;
                        this.backFromEmptyStack();
                        return;
                    }
                    catch (Exception exception) {
                        if (!this.db.on()) return;
                        KDebug.printStackTrace((Throwable)exception);
                    }
                }
                return;
            } else {
                if (!this.db.on()) return;
                this.db.println("User did not confirm the handleBack()");
            }
            return;
        } else if (object == this.nextButton) {
            this.localValidation(1);
            if (this.disposed) return;
            this.next();
            return;
        } else if (this.helpButton != null && object == this.helpButton) {
            this.helpButton.launchHelp(this.currentWzPane.getHelpID());
            return;
        } else {
            this.db.println("unknown action source= " + object);
        }
    }

    protected void localValidation(int n) {
    }

    public void next() {
        boolean bl = false;
        try {
            String string;
            if (this.db.on()) {
                this.db.fine("[next] leaving currentWzPane=" + this.currentWzPane.getName());
            }
            if ((string = this.currentWzPane.handleNext()) != null) {
                this.nextButton.setEnabled(false);
                this.currentWzPane.goingForward = false;
                this.pushCurrentPane();
                this.setCurrentPane(string);
            } else {
                bl = true;
                if (this.db.on()) {
                    this.db.println("Failure to go to next: nextPaneName was null");
                    this.db.println("If exception window popped up, this is probably ok, as pane validation caught this.");
                }
            }
        }
        catch (Exception exception) {
            this.displayValidationError(exception);
            KDebug.printStackTrace((Throwable)exception);
            bl = true;
        }
        if (bl && this.driver != null) {
            if (this.db.on()) {
                this.db.println("automation was signalled to stop the driver.");
            }
            this.driver.stop();
        }
    }

    public void applyChanges() {
        try {
            this.currentWzPane.handleApply();
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void backFromEmptyStack() throws Exception {
        throw new Exception("The wizard cannot go back because it considers this the first pane.");
    }

    public void setButtonsEnabled(boolean bl, boolean bl2) {
        this.backButton.setEnabled(!this.wzPaneStack.empty());
        this.nextButton.setEnabled(bl);
        this.finishButton.setEnabled(bl2);
    }

    protected void dumpMap() {
        System.out.println("-- map dump begin");
        for (Object k : this.wzPaneMap.keySet()) {
            WzPane wzPane = (WzPane)this.wzPaneMap.get(k);
            System.out.println("Pane: " + k + "\tgoingForward? " + wzPane.goingForward);
        }
        System.out.println("-- map dump end");
    }

    public boolean handleFinishException(Exception exception) {
        return false;
    }

    protected abstract void apply() throws Exception;

    public void finish() {
        block5: {
            try {
                if (this.db.on) {
                    this.db.println("finish: validating page " + this.currentWzPane.getName());
                }
                this.currentWzPane.resetOkToPostValidate();
                this.currentWzPane.validatePage();
                if (!this.currentWzPane.isOkToPostValidate()) {
                    return;
                }
                this.currentWzPane.handlePostValidate();
                this.apply();
                this.handleFinish();
            }
            catch (Exception exception) {
                if (this.driver != null) {
                    this.driver.stop(exception);
                }
                if (this.handleFinishException(exception)) break block5;
                KDebug.printStackTrace((Throwable)exception);
                this.displayValidationError(exception);
            }
        }
    }

    public static String closeSentence(String string) {
        char c;
        if (string != null && string.length() > 0 && Character.isLetterOrDigit(c = string.charAt(string.length() - 1))) {
            string = string + ".";
        }
        return string;
    }

    protected void displayValidationError(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        string = WzDialog.closeSentence(string);
        ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1, (Object)("\n" + string));
    }

    protected void handleFinish() {
        this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
        this.dispose();
    }

    protected String getCancelMessage() {
        return "Really cancel " + this.getTitle() + "?";
    }

    protected void handleCancel() {
    }

    public void cancel(boolean bl) {
        if (!bl || this.getCancelMessage() == null || CerentDialog.yesNoDialog((Component)this, (String)this.getCancelMessage(), (String)"Confirm Cancel")) {
            this.handleCancel();
            this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
            this.dispose();
        }
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public String getPageName() {
        if (this.currentWzPane != null) {
            return this.currentWzPane.getName();
        }
        return null;
    }

    public String getResultString(Exception exception) {
        return exception != null ? "Failed" : "Completed";
    }

    protected void setDriver(WzDriver wzDriver) {
        this.driver = wzDriver;
    }

    protected WzDriver getDriver() {
        return this.driver;
    }

    @Override
    public void dispose() {
        for (Object k : this.wzPaneMap.keySet()) {
            WzPane wzPane = (WzPane)this.wzPaneMap.get(k);
            if (this.db.on()) {
                this.db.println("Will dispose of WzPane " + wzPane.getName());
            }
            wzPane.removeListeners();
            wzPane.dispose();
        }
        this.db.dispose();
        this.wzPaneMap.clear();
        this.wzPaneStack = null;
        this.statusPanel = null;
        this.statusScrollPane = null;
        this.disposed = true;
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.currentWzPane != null) {
            stringBuffer.append("Current Pane: " + this.currentWzPane.getName() + "\n");
        }
        stringBuffer.append("Pane Map (all Panes): ");
        if (this.wzPaneMap != null) {
            stringBuffer.append("WzPaneMap: ");
            stringBuffer.append("Size= " + this.wzPaneMap.size() + "\n");
            for (Object k : this.wzPaneMap.keySet()) {
                Object v = this.wzPaneMap.get(k);
                stringBuffer.append("Key= " + k + "\n");
            }
        } else {
            stringBuffer.append("WzPaneMap was null!\n");
        }
        stringBuffer.append("Pane Stack (visited Panes): " + this.wzPaneStack + "\n");
        if (this.wzPaneStack != null) {
            stringBuffer.append("Size= " + this.wzPaneStack.size() + "\n");
            for (int i = 0; i < this.wzPaneStack.size(); ++i) {
                stringBuffer.append("#" + i + ": " + this.wzPaneStack.elementAt(i) + "\n");
            }
        }
        stringBuffer.append("Driver: " + this.driver + "\n");
        stringBuffer.append("Page Count: " + this.pageCount + "\n");
        return stringBuffer.toString();
    }

    public JPanel gettheStatusPanel() {
        return this.statusPanel;
    }
}

