/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CommonHelper;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.AOTSParametersProvPane;
import cerent.cms.ui.ampli.AmpliOpticalThresholdPane;
import cerent.cms.ui.ampli.OTSParametersProvPane;
import cerent.cms.ui.dwdm.DwdmTypeAmpliProvPane;
import cerent.cms.ui.ochterm.OchTermProvPane;
import cerent.cms.ui.tdcu.TdcuCompensationProvPane;
import java.awt.Component;

public class AmpliProvPane
extends NodeProvPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    protected OpticsModuleModel model = (OpticsModuleModel)this.getUiModel();
    private OpticsMultiplexSectionModel[] omsModels;
    private OpticsLineModel[] otsModels = this.getOtsLinemodel();
    private OpticsAmplifiedLineModel[] otsAmplifiedModels = this.model.getOpticsAmplifiedLineModels();

    public AmpliProvPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.model.getNodeModel();
        this.eqpmtModel = moduleModel;
        this.subTabs = new SubTabbedView(this.model, tabbedView);
        this.subTabs.addTab("Optical Line", (Component)this.getOtsTabs(this.subTabs, this.otsModels));
        if (!CommonHelper.isTDCUCard(this.model)) {
            this.subTabs.addTab("Opt.Ampli.Line", (Component)this.getOTSAmpliTabs(this.subTabs, this.otsAmplifiedModels));
        }
        if (CommonHelper.isChannelPowerSupported(this.model) && (this.model.getEqType() == 294 || this.model.getEqType() == 295 || this.model.getEqType() == 296)) {
            this.subTabs.addTab("OCH", (Component)this.getOchTermTabs(this.subTabs));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        if (CommonHelper.isTDCUCard(this.model)) {
            this.addTdcuCompensationPanel();
        } else if (!CommonHelper.isChannelPowerSupported(this.model)) {
            this.addDwdmTypeAmpliCardInfoPanel();
        }
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    protected OpticsLineModel[] getOtsLinemodel() {
        return this.model.getOpticsLineModels();
    }

    protected Pane getOtsTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new AmpliOTSProvPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getOTSAmpliTabs(TabbedView tabbedView, OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray) {
        return new AmpliOTSAmpliProvPane(tabbedView, opticsAmplifiedLineModelArray);
    }

    private void addTdcuCompensationPanel() {
        this.subTabs.addTab("Card", (Component)((Object)new TdcuCompensationProvPane("Compensation Config", this.subTabs)));
    }

    private void addDwdmTypeAmpliCardInfoPanel() {
        if (!(this.eqpmtModel.isOPT_PRE() || this.eqpmtModel.isOPT_RAMP() || this.eqpmtModel.isOPT_BST_L())) {
            this.subTabs.addTab("Card", (Component)((Object)new DwdmTypeAmpliProvPane("Ampli Card", this.subTabs, this.otsAmplifiedModels)));
        }
    }

    protected Pane getOTSAmpliParametersProvTab(OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray) {
        return new AOTSParametersProvPane("Parameters", this.getParentView(), opticsAmplifiedLineModelArray);
    }

    protected Pane getOTSParametersProvTab(OpticsLineModel[] opticsLineModelArray) {
        return new OTSParametersProvPane("Parameters", this.getParentView(), opticsLineModelArray);
    }

    protected Pane getOchTermTabs(TabbedView tabbedView) {
        return new OchTermProvPane(tabbedView);
    }

    protected Pane getOptThresholdsTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new AmpliOpticalThresholdPane("Optics Thresholds", this.getParentView(), abstractOpticsLineModelArray);
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }

    private class AmpliOTSAmpliProvPane
    extends NodeProvPane {
        public AmpliOTSAmpliProvPane(TabbedView tabbedView, OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray) {
            super("AmpliOTSAmpliProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)AmpliProvPane.this.getOTSAmpliParametersProvTab(opticsAmplifiedLineModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)AmpliProvPane.this.getOptThresholdsTab(opticsAmplifiedLineModelArray));
            this.add((Component)this.subTabs);
        }

        @Override
        public boolean hasSubTabs() {
            return true;
        }
    }

    private class AmpliOTSProvPane
    extends NodeProvPane {
        public AmpliOTSProvPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("AmpliOTSProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)AmpliProvPane.this.getOTSParametersProvTab(opticsLineModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)AmpliProvPane.this.getOptThresholdsTab(opticsLineModelArray));
            this.add((Component)this.subTabs);
        }

        @Override
        public boolean hasSubTabs() {
            return true;
        }
    }
}

