/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.DataSourceControl;
import cerent.cms.ui.ans.ANSHelper;
import cerent.cms.ui.ans.ANSTableModel;
import cerent.cms.ui.ans.AbstractANSController;
import cerent.cms.ui.ans.IANSTreeViewPane;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class ANSController
extends AbstractANSController
implements DataSourceControl {
    private final ANSTableModel tableModel;
    private final ANSHelper dfh;
    private boolean dirty;
    private boolean keepDirty = false;

    public ANSController(IANSTreeViewPane iANSTreeViewPane, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        super(iANSTreeViewPane, nodeModelDelegate, sDebug);
        this.dfh = new ANSHelper((Component)((Object)iANSTreeViewPane.getParentComponent()), this.nmd);
        this.dfh.addObserver(this);
        this.tableModel = new ANSTableModel(this);
    }

    @Override
    public void disposeDataSource() {
        this.dfh.deleteObserver(this);
        super.disposeDataSource();
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    protected ANSNode getDefaultsRoot() throws Exception {
        return this.dfh.getDefaultsRoot(true);
    }

    @Override
    public void setTableContent(TreePath treePath) {
        if (treePath != null) {
            ANSNode aNSNode = this.getANSNode(treePath);
            this.tableModel.setScope(this.pane.getTable(), this.am.getSortedAnsElem(aNSNode));
        }
    }

    public boolean validateData() {
        return true;
    }

    public void applyToModel() throws Exception {
        if (this.dfh.applyToNode()) {
            this.droot.resetDirty();
            this.refreshPane("node");
        } else {
            this.keepDirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        if (!this.keepDirty) {
            this.dirty = bl;
        } else {
            this.keepDirty = false;
        }
    }
}

