/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.IProvisioning;
import cerent.cms.ui.ans.ANSTableCellEditor;
import cerent.cms.ui.ans.ANSTableCellRenderer;
import cerent.cms.ui.ans.IANSController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ANSTableModel
extends AbstractTableModel {
    private ANSElement[] rows = null;
    private final IANSController dfc;

    public ANSTableModel(IANSController iANSController) {
        this.dfc = iANSController;
    }

    public void initTable(JTable jTable, IProvisioning iProvisioning) {
        ANSTableCellEditor aNSTableCellEditor = new ANSTableCellEditor(iProvisioning);
        jTable.getColumnModel().getColumn(2).setCellEditor(aNSTableCellEditor);
        ANSTableCellRenderer aNSTableCellRenderer = new ANSTableCellRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            int n = ANSTableCellRenderer.getColumnWidth(i);
            boolean bl = ANSTableCellRenderer.isColumnResizable(i);
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(aNSTableCellRenderer);
            tableColumn.setResizable(bl);
            if (!bl) {
                tableColumn.setMaxWidth(n);
            }
            tableColumn.setMinWidth(n);
            tableColumn.setPreferredWidth(n);
        }
    }

    public List<ANSElement> getANSElementList() {
        return Arrays.asList(this.rows);
    }

    @Override
    public synchronized int getRowCount() {
        if (this.rows != null) {
            return this.rows.length;
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return ANSTableCellRenderer.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return ANSTableCellRenderer.getColumnName(n);
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        try {
            return this.rows[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            String string = (String)object;
            this.rows[n].setValue(string);
            if (this.rows[n].isDirty()) {
                this.dfc.setDirty(this.rows[n]);
                this.fireTableRowsUpdated(n, n);
            }
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
            ErrorMsg.displayError((Component)this.dfc.getParentComponent(), (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
            ErrorMsg.displayError((Component)this.dfc.getParentComponent(), (EID)EMC.EID_ERROR_SET_VALUEAT_PARAM_1, (Object)this.rows[n].getFullName());
        }
    }

    public synchronized void setScope(JTable jTable, List<ANSElement> list) {
        jTable.setRowHeight(jTable.getRowHeight());
        this.rows = list.toArray(new ANSElement[0]);
        for (int i = 0; i < this.rows.length; ++i) {
            int n = this.rows[i].getANSValue().getDefElemClass();
            if (n == 1) {
                jTable.setRowHeight(i, 128);
                continue;
            }
            if (n != 4) continue;
            jTable.setRowHeight(i, 320);
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return !ANSTableCellRenderer.isColumnReadOnly(n2) && this.dfc.isAuthorized() && !this.rows[n].isReadOnly();
    }
}

