/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSResult;
import cerent.cms.model.ANS.ANSValue;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class AnsPathColumnRenderer
extends AbstractColumnRenderer {
    private static final int SLT_ID_INDEX = 0;
    private static final int PARAM_INDEX = 1;
    private static final int STAT_INDEX = 2;
    private static final int VALUE_INDEX = 3;
    private static final int ACTOR_INDEX = 4;
    private static final int TIME_INDEX = 5;
    private static final int COLUMN_NO = 6;
    private static final String UNKNOWN = "Unknown";
    private JLabel label = new JLabel();
    private static final SDebug db = new SDebug("AnsPathColumnRenderer");

    private AnsPathColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        if (!(object instanceof ANSResult)) {
            if (db.on()) {
                db.println("Cast error");
            }
            this.label.setText("");
            return jLabel;
        }
        ANSResult aNSResult = (ANSResult)object;
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = aNSResult.getPortName();
                break;
            }
            case 1: {
                string = aNSResult.getParameter();
                break;
            }
            case 2: {
                string = aNSResult.getResult();
                break;
            }
            case 4: {
                string = aNSResult.getActor();
                break;
            }
            case 5: {
                string = aNSResult.getTimestampString();
                break;
            }
            case 3: {
                string = AnsPathColumnRenderer.getValue(aNSResult.getValue());
                break;
            }
            default: {
                string = UNKNOWN;
            }
        }
        if (db.on()) {
            db.println("Cell @ [" + n + ", " + n2 + "] = " + string);
        }
        this.label.setToolTipText("");
        this.label.setText(string);
        if (aNSResult.getSuccess()) {
            Color color2 = bl ? jTable.getSelectionForeground() : jTable.getForeground();
            ((Component)jLabel).setForeground(color2);
        } else {
            ((Component)jLabel).setForeground(Color.red);
        }
        ((Component)jLabel).setBackground(color);
        return jLabel;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        if (object instanceof ANSResult && object2 instanceof ANSResult) {
            ANSResult aNSResult = (ANSResult)object;
            ANSResult aNSResult2 = (ANSResult)object2;
            switch (n) {
                case 0: {
                    return aNSResult.getPortIndex() - aNSResult2.getPortIndex();
                }
                case 1: {
                    return aNSResult.getParameter().compareTo(aNSResult2.getParameter());
                }
                case 2: {
                    return aNSResult.getResult().compareTo(aNSResult2.getResult());
                }
                case 4: {
                    return aNSResult.getActor().compareTo(aNSResult2.getActor());
                }
                case 5: {
                    return (int)(aNSResult.getTimestamp() - aNSResult2.getTimestamp());
                }
                case 3: {
                    return aNSResult.getValue().compareTo(aNSResult2.getValue());
                }
            }
        } else if (db.on()) {
            db.println("Cast error");
        }
        return 0;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[6];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = AnsPathColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    private static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Port";
                n3 = 340;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Parameter";
                n3 = 170;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Result";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Set By";
                n3 = 60;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Last Change";
                n3 = 170;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Value";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new AnsPathColumnRenderer(string, n3, bl, n2);
    }

    private static final String getValue(ANSValue aNSValue) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(aNSValue.getValue());
        if (aNSValue.getUnits().length() > 0) {
            stringBuilder.append(" (");
            stringBuilder.append(aNSValue.getUnits());
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

