/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSResult;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Feature;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.ans.AnsPathColumnRenderer;
import cerent.cms.ui.ans.AnsPathDataSource;
import cerent.cms.ui.ans.AnsRegulatedPathDialog;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.ShelfEventPanelController;
import cerent.cms.ui.ms.MultishelfTabbedView;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class AnsPathTableModel
extends SortableRowTableModel {
    private static final int[] sortCols = new int[]{0};
    private static final boolean[] sortDir = new boolean[]{true};
    private static final String SHOW_CARD = "Show Card View";
    private static final String SHOW_RULES = "Show Regulation Path";
    private final JPopupMenu popup;
    private final ActionOrganizer actOrg;
    private final AbstractViewController avc;
    private final AbstractPane parent;
    private int row;

    public AnsPathTableModel(AnsPathDataSource ansPathDataSource, AbstractPane abstractPane) {
        super((RowDataSource)ansPathDataSource, AnsPathColumnRenderer.createTableRenderers(), ANSResult.class, sortCols, sortDir);
        this.parent = abstractPane;
        this.avc = AnsPathTableModel.getAVC((Container)((Object)abstractPane));
        this.popup = new JPopupMenu();
        this.actOrg = new ActionOrganizer(this);
        this.actOrg.addMenuItem((JComponent)this.popup, null, SHOW_CARD, 67);
        this.actOrg.addMenuItem((JComponent)this.popup, null, SHOW_RULES, 82);
    }

    @Override
    protected boolean doesHandleRowPopups() {
        return true;
    }

    @Override
    protected void handleRowPopup(MouseEvent mouseEvent, int n) {
        this.row = n;
        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SHOW_CARD)) {
            this.showCard((ANSResult)this.getValueAt(this.row, 0));
        } else if (string.equals(SHOW_RULES)) {
            this.showRegulatedPath((ANSResult)this.getValueAt(this.row, 0));
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void showCard(ANSResult aNSResult) {
        AbstractOpticsLineModel abstractOpticsLineModel = aNSResult.getPortModel();
        short s = 0;
        if (abstractOpticsLineModel.getNodeModel().provides(Feature.MULTISHELF) && abstractOpticsLineModel.getNodeModel().isMultishelf()) {
            s = abstractOpticsLineModel.getShelfNum();
        }
        short s2 = abstractOpticsLineModel.getSlotNum();
        ViewName viewName = new ViewName(new int[]{abstractOpticsLineModel.getNodeModel().getNodeId(), s, s2});
        try {
            if (viewName != null) {
                this.avc.tryJumpView(viewName);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void showRegulatedPath(ANSResult aNSResult) {
        AnsRegulatedPathDialog.instance(JOptionPane.getFrameForComponent((Component)((Object)this.parent)), aNSResult);
    }

    private static AbstractViewController getAVC(Container container) {
        IEventPanelController iEventPanelController = null;
        while (container != null) {
            if (container instanceof AbstractPane) {
                container = ((AbstractPane)((Object)container)).getParentView();
            }
            if (container instanceof ShelfTabbedView) {
                iEventPanelController = ((ShelfTabbedView)((Object)container)).getMyController();
            } else if (container instanceof MultishelfTabbedView) {
                iEventPanelController = ((MultishelfTabbedView)((Object)container)).getMyController();
            }
            if (iEventPanelController instanceof ShelfEventPanelController) {
                return ((ShelfEventPanelController)iEventPanelController).getAvc();
            }
            container = container.getParent();
        }
        return null;
    }
}

