/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.bbe;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BbeModuleModel;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.UnimplementedPane;
import cerent.cms.ui.bbe.BbeProvPane;
import cerent.cms.ui.event.IEventPanelController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;

public class BbeCardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private ArrayList _ds3LinesList;
    private ArrayList _ds3xmLinesList;
    private ArrayList _ec1LinesList;
    private BbeSlot _bbeSlot;

    public BbeCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    @Override
    protected void init() {
        int n;
        BbeModuleModel bbeModuleModel = (BbeModuleModel)this.getUiModel();
        Ds123LineModel[] ds123LineModelArray = bbeModuleModel.getDs3Lines();
        this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray));
        this.getOM().addObservable((Observable[])ds123LineModelArray);
        int n2 = ds123LineModelArray.length;
        Ds123LineModel[] ds123LineModelArray2 = bbeModuleModel.getDs3xmLines();
        this._ds3xmLinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray2));
        this.getOM().addObservable((Observable[])ds123LineModelArray2);
        int n3 = ds123LineModelArray2.length;
        TdmLineModel[] tdmLineModelArray = bbeModuleModel.getEc1Lines();
        this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        int n4 = tdmLineModelArray.length;
        this._interfaceContainers = Collections.synchronizedMap(new HashMap(n4 + n2 + n3));
        for (n = 0; n < n2; ++n) {
            this.addContainerMap(ds123LineModelArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.addContainerMap(ds123LineModelArray2[n]);
        }
        for (n = 0; n < n4; ++n) {
            this.addContainerMap(tdmLineModelArray[n]);
        }
        try {
            this._bbeSlot = bbeModuleModel.getBbeSlot();
            this.getOM().addObservable((Observable)((Object)this._bbeSlot));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this._bbeSlot = null;
        }
        this.getOM().setActive(true);
        this.getOM().setPassing(true);
    }

    private Ds123LineModel[] getDs3LinesArray() {
        return this._ds3LinesList.toArray(new Ds123LineModel[this._ds3LinesList.size()]);
    }

    private Ds123LineModel[] getDs3xmLinesArray() {
        return this._ds3xmLinesList.toArray(new Ds123LineModel[this._ds3xmLinesList.size()]);
    }

    private TdmLineModel[] getEc1LinesArray() {
        return this._ec1LinesList.toArray(new TdmLineModel[this._ec1LinesList.size()]);
    }

    @Override
    protected List addModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList;
        block3: {
            Model[] modelArray;
            IPortContainer iPortContainer;
            block5: {
                Model[] modelArray2;
                block4: {
                    BbeModuleModel bbeModuleModel = (BbeModuleModel)this.getUiModel();
                    arrayList = new ArrayList<ModuleModelUpdate>();
                    if (!(observable instanceof BbeSlot)) break block3;
                    iPortContainer = (IPortContainer)((Object)observable);
                    Model[] modelArray3 = bbeModuleModel.getDs3Lines();
                    modelArray2 = bbeModuleModel.getEc1Lines();
                    modelArray = bbeModuleModel.getDs3xmLines();
                    if (modelArray3.length <= this._ds3LinesList.size()) break block4;
                    this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(modelArray3));
                    this.getOM().addObservable((Observable[])modelArray3);
                    arrayList.add(new Ds3LineUpdate(modelArray3, iPortContainer));
                    Iterator iterator = iPortContainer.getContainedPorts().iterator();
                    while (iterator.hasNext()) {
                        this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                    }
                    break block3;
                }
                if (modelArray2.length <= this._ec1LinesList.size()) break block5;
                this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray2));
                this.getOM().addObservable((Observable[])modelArray2);
                arrayList.add(new Ec1LineUpdate(modelArray2, iPortContainer));
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                break block3;
            }
            if (modelArray.length <= this._ds3xmLinesList.size()) break block3;
            this._ds3xmLinesList = new ArrayList<Ds123LineModel>(Arrays.asList(modelArray));
            this.getOM().addObservable((Observable[])modelArray);
            arrayList.add(new Ec1LineUpdate(modelArray, iPortContainer));
            Iterator iterator = iPortContainer.getContainedPorts().iterator();
            while (iterator.hasNext()) {
                this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
            }
        }
        return arrayList;
    }

    @Override
    protected List removeModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        IPortContainer iPortContainer = (IPortContainer)this._interfaceContainers.get(observable);
        if (observable instanceof IInterfaceModel) {
            this.removeContainerMap((IInterfaceModel)observable);
        }
        this.getOM().removeObservable(observable);
        if (observable instanceof Ds123LineModel && this._ds3LinesList.remove(observable)) {
            arrayList.add(new Ds3LineUpdate(this.getDs3LinesArray(), iPortContainer));
        } else if (observable instanceof TdmLineModel && this._ec1LinesList.remove(observable)) {
            arrayList.add(new Ec1LineUpdate(this.getEc1LinesArray(), iPortContainer));
        }
        return arrayList;
    }

    @Override
    public Pane getMaintenanceTab() {
        return new UnimplementedPane("Maintenance", this);
    }

    @Override
    public Pane getProvTab() {
        return new BbeProvPane("Provisioning", this, this.getDs3LinesArray(), this.getDs3xmLinesArray(), this.getEc1LinesArray());
    }

    @Override
    public Pane getPerformanceTab() {
        return new UnimplementedPane("Performance", this);
    }

    @Override
    public void destroy() {
        this._ds3LinesList.clear();
        this._ds3xmLinesList.clear();
        this._ec1LinesList.clear();
        super.destroy();
    }
}

