/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ComboCardMaintPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.aic.AicEnvAlarmPane;
import cerent.cms.ui.aic.AicEnvControlPane;
import cerent.cms.ui.aic.AicOhTermPane;
import cerent.util.SDebug;
import java.awt.Component;

public class CtxMaintPane
extends ComboCardMaintPane
implements ITabName {
    protected EnvAlarmModel[] alarmInputs;
    protected EnvControlModel[] controlOutputs;
    private static final SDebug dbg = new SDebug("CtxMaintPane");

    public CtxMaintPane(String string, CardTabbedView cardTabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, cardTabbedView, tdmLineModelArray);
    }

    public CtxMaintPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray, TdmLineModel[] tdmLineModelArray2, EnvAlarmModel[] envAlarmModelArray, EnvControlModel[] envControlModelArray) {
        super(string, cardTabbedView, ds123LineModelArray, ds123LineModelArray2, tdmLineModelArray, tdmLineModelArray2);
        this.alarmInputs = envAlarmModelArray;
        this.controlOutputs = envControlModelArray;
        this.registerWithModel();
        this.myIfs = 30;
    }

    @Override
    protected void createSubTabs() {
        super.createSubTabs();
        if (dbg.on()) {
            dbg.info("Creating CTX SubTabs");
        }
        this.subTabs.addTab("External Alarms", (Component)this.getExtAlarmsTab("External Alarms"));
        this.subTabs.addTab("External Controls", (Component)this.getExtControlsTab("External Controls"));
        this.subTabs.addTab("Virtual Wires", (Component)this.getVirtualWireTab());
        this.subTabs.addTab("Overhead Termination", (Component)this.getOhTerminationTab("Overhead Termination"));
    }

    private Pane getExtAlarmsTab(String string) {
        return new AicEnvAlarmPane(string, this.subTabs, this.alarmInputs, this.alarmInputs, 1);
    }

    private Pane getExtControlsTab(String string) {
        return new AicEnvControlPane(string, this.subTabs, this.controlOutputs, 1);
    }

    private Pane getVirtualWireTab() {
        return (Pane)this.uiToolkit.getGuestPane(5, this.subTabs);
    }

    private Pane getOhTerminationTab(String string) {
        return new AicOhTermPane(string, this.subTabs);
    }
}

