/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.download;

import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConstCom;
import cerent.cms.ui.NodeVersionInfo;
import cerent.cms.ui.SoftMaintDataSource;
import cerent.cms.ui.download.AbstractSoftMaintPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;

public class SoftMaintActiveRevertDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final int MARGIN = 5;
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    public static final int ACTIVATE_OPERATION = 0;
    public static final int REVERT_OPERATION = 1;
    private CheckableList nodeLB;
    private JButton okButton;
    private JButton cancelButton;
    private String operationString;
    private AbstractSoftMaintPane parent;
    protected SoftMaintDataSource dataSource;
    private Object[] selectedItems = new Object[0];
    private final String swMessage = "The list below displays the nodes that support this operation.\n \nIn Network view this operation is not available for ONS 15600 nodes.\n \nPlease check the box next to the name of the node on which\n";
    private final String swActivateMessage = "you want to activate the new software version.\n \n";
    private final String swRevertMessage = "you want to revert to a previous software version.\n \n";
    private static final String OK_MESSAGE = "Click OK to continue.";
    private boolean isRevert = false;

    public SoftMaintActiveRevertDialog(AbstractSoftMaintPane abstractSoftMaintPane, SoftMaintDataSource softMaintDataSource, int n) {
        super(JOptionPane.getFrameForComponent((Component)((Object)abstractSoftMaintPane)), n == 0 ? "Activating" : "Reverting", true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SoftMaintActiveRevertDialog.this.dispose();
            }
        });
        if (n == 0) {
            this.operationString = "Activating";
            this.isRevert = false;
        } else {
            this.operationString = "Reverting";
            this.isRevert = true;
        }
        this.parent = abstractSoftMaintPane;
        this.dataSource = softMaintDataSource;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getListPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.populateLB();
        this.setOkButtonState();
        this.nodeLB.addListSelectionListener(this);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)abstractSoftMaintPane));
        if (this.nodeLB.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)abstractSoftMaintPane), "There isn't any node that can process this operation.", "Node not found", 2);
        } else {
            this.setVisible(true);
        }
    }

    private JPanel getListPanel() {
        String string = null;
        string = this.operationString.equals("Activating") ? "The list below displays the nodes that support this operation.\n \nIn Network view this operation is not available for ONS 15600 nodes.\n \nPlease check the box next to the name of the node on which\nyou want to activate the new software version.\n \nClick OK to continue." : "The list below displays the nodes that support this operation.\n \nIn Network view this operation is not available for ONS 15600 nodes.\n \nPlease check the box next to the name of the node on which\nyou want to revert to a previous software version.\n \nClick OK to continue.";
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nodeLB = new CheckableList();
        this.nodeLB.setVisibleRowCount(6);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)new UScrollPane((Component)this.nodeLB), "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConstCom.SoftMaintSelDialog));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    private boolean isAuthorized(INodeModel iNodeModel) {
        if (iNodeModel.provides(Feature.SUPPORTS_MAINTENANCE_DOWNLOAD)) {
            return AbstractSoftMaintPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.MAINTENANCE);
        }
        return AbstractSoftMaintPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.SUPERUSER);
    }

    protected void setOkButtonState() {
        this.okButton.setEnabled(false);
        ListModel listModel = this.nodeLB.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            this.okButton.setEnabled(true);
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setOkButtonState();
    }

    private boolean apply() {
        ArrayList<NodeVersionInfo> arrayList = new ArrayList<NodeVersionInfo>(0);
        ListModel listModel = this.nodeLB.getModel();
        boolean bl = true;
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            bl = false;
            arrayList.add((NodeVersionInfo)checkableItem.getObject());
        }
        this.selectedItems = arrayList.toArray(new NodeVersionInfo[0]);
        if (bl) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_SW_UPGRADE_NODE_NOT_SELECTED);
            return false;
        }
        return true;
    }

    private void populateLB() {
        ArrayList<CheckableItem> arrayList = new ArrayList<CheckableItem>(0);
        this.nodeLB.setListData(new Object[0]);
        int n = this.dataSource.getRowCount();
        for (int i = 0; i < n; ++i) {
            INodeModel iNodeModel;
            INodeModel iNodeModel2;
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)this.dataSource.getObjectAtRow(i);
            if (nodeVersionInfo.getStatusString().equals("Activating") || nodeVersionInfo.getStatusString().equals("Reverting") || (iNodeModel2 = nodeVersionInfo.getNodeModel()) == null || !iNodeModel2.isInited() || iNodeModel2.getNeType().startsWith("15600") || !this.isRevert && iNodeModel2.provides(Feature.ML_VERSION_UP) && iNodeModel2.getNeType().startsWith("15454") && iNodeModel2.getDelayedUpgradeModel().getAllowDelayedUpgrades() || this.isRevert && iNodeModel2.provides(Feature.DETAILED_SW_UPGRADE) || !nodeVersionInfo.canDownload() || !this.isAuthorized(iNodeModel = nodeVersionInfo.getNodeModel())) continue;
            arrayList.add(new CheckableItem(nodeVersionInfo, n == 1));
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)((CheckableItem)object).getObject();
                    NodeVersionInfo nodeVersionInfo2 = (NodeVersionInfo)((CheckableItem)object2).getObject();
                    return nodeVersionInfo.toString().compareTo(nodeVersionInfo2.toString());
                }
            });
        }
        this.nodeLB.setListData(arrayList.toArray(new CheckableItem[0]));
        this.setOkButtonState();
    }

    public Object[] getSelectedItems() {
        return this.selectedItems;
    }
}

