/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.download;

import cerent.cms.ui.NodeVersionInfo;
import cerent.cms.ui.SoftMaintDataSource;
import cerent.cms.ui.download.AbstractSoftMaintPane;
import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.UScrollPane;
import cerent.util.job.JobGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SoftMaintCancelDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String TITLE = "Cancel Download";
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int MARGIN = 5;
    private JButton okButton;
    private JButton cancelButton;
    private SoftMaintDataSource dataSource;
    private CheckableList nodeLB;
    private Object[] selectedItems = new Object[0];
    private AbstractSoftMaintPane parent;

    public SoftMaintCancelDialog(AbstractSoftMaintPane abstractSoftMaintPane, SoftMaintDataSource softMaintDataSource) {
        super(JOptionPane.getFrameForComponent((Component)((Object)abstractSoftMaintPane)), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SoftMaintCancelDialog.this.dispose();
            }
        });
        this.parent = abstractSoftMaintPane;
        this.dataSource = softMaintDataSource;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getListPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.populateLB();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)abstractSoftMaintPane));
        this.setOkButtonState();
        this.nodeLB.addListSelectionListener(this);
        this.setVisible(true);
    }

    private JPanel getListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nodeLB = new CheckableList();
        this.nodeLB.setVisibleRowCount(6);
        jPanel.add((Component)new JLabel("Select Nodes:"), "North");
        jPanel.add((Component)new UScrollPane((Component)this.nodeLB), "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.apply();
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setOkButtonState();
    }

    protected void setOkButtonState() {
        this.okButton.setEnabled(false);
        ListModel listModel = this.nodeLB.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            this.okButton.setEnabled(true);
            return;
        }
    }

    private void apply() {
        ArrayList<JobGroup> arrayList = new ArrayList<JobGroup>(0);
        ListModel listModel = this.nodeLB.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            RunningJob runningJob = (RunningJob)checkableItem.getObject();
            arrayList.add(runningJob.getJobGroup());
        }
        this.selectedItems = arrayList.toArray(new JobGroup[0]);
    }

    @Override
    public void dispose() {
        this.nodeLB.removeListSelectionListener(this);
        super.dispose();
    }

    public Object[] getSelectedItems() {
        return this.selectedItems;
    }

    private void populateLB() {
        HashMap hashMap = this.dataSource.getRunningJobs();
        ArrayList<CheckableItem> arrayList = new ArrayList<CheckableItem>(0);
        Set set = hashMap.entrySet();
        for (Map.Entry entry : set) {
            CheckableItem checkableItem;
            String string;
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)entry.getValue();
            JobGroup jobGroup = (JobGroup)entry.getKey();
            try {
                string = nodeVersionInfo.getNodeModel().getName();
            }
            catch (Exception exception) {
                string = "unknown";
            }
            if (nodeVersionInfo.getStatusString().indexOf("copying to stby") != -1 || nodeVersionInfo.getStatusString().indexOf("copying to other TCCs") != -1) {
                checkableItem = new CheckableItem(new RunningJob(jobGroup, string + " (copying to standby)"));
                checkableItem.setEnabled(false);
                arrayList.add(checkableItem);
                continue;
            }
            if (nodeVersionInfo.getStatusString().indexOf("canceling download...") != -1) {
                checkableItem = new CheckableItem(new RunningJob(jobGroup, string + " (canceling download)"));
                checkableItem.setEnabled(false);
                arrayList.add(checkableItem);
                continue;
            }
            arrayList.add(new CheckableItem(new RunningJob(jobGroup, string)));
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    RunningJob runningJob = (RunningJob)((CheckableItem)object).getObject();
                    RunningJob runningJob2 = (RunningJob)((CheckableItem)object2).getObject();
                    return runningJob.toString().compareTo(runningJob2.toString());
                }
            });
        }
        this.nodeLB.setListData(arrayList.toArray(new CheckableItem[0]));
        this.setOkButtonState();
    }

    class RunningJob {
        private JobGroup jg;
        private String nodeName;

        RunningJob(JobGroup jobGroup, String string) {
            this.jg = jobGroup;
            this.nodeName = string;
        }

        public JobGroup getJobGroup() {
            return this.jg;
        }

        public String toString() {
            return this.nodeName;
        }
    }
}

