/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.download;

import cerent.cms.model.DownloadChecker;
import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConstCom;
import cerent.cms.ui.NodeVersionInfo;
import cerent.cms.ui.SoftMaintDataSource;
import cerent.cms.ui.download.AbstractSoftMaintPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.CheckableItem;
import cerent.util.gui.CheckableList;
import cerent.util.gui.FilePropertyEditor;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;

public class SoftMaintSelDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
ListSelectionListener {
    private static final String PREFS_CTC = "ctc";
    private static final String PREFS_DOWNLOAD_FILE_PATH = "download.file.path";
    private static final String PREFS_DOWNLOAD_CONCURRENT = "download.num.threads";
    private static final String TITLE = "Download Selection";
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int MARGIN = 5;
    private static final int DEFAULT_DOWNLOAD_THREADS = 8;
    private int myNumDownloadThreads;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel versionLabel;
    private FilePropertyEditor fileEdit;
    private SoftMaintDataSource dataSource;
    private CheckableList nodeLB;
    private Object[] selectedItems = new Object[0];
    private String selectedFile = "";
    private AbstractSoftMaintPane parent;
    private static final SDebug db = new SDebug("SoftMaintSelDialog");

    public SoftMaintSelDialog(AbstractSoftMaintPane abstractSoftMaintPane, SoftMaintDataSource softMaintDataSource) {
        super(JOptionPane.getFrameForComponent((Component)((Object)abstractSoftMaintPane)), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SoftMaintSelDialog.this.dispose();
            }
        });
        this.parent = abstractSoftMaintPane;
        this.dataSource = softMaintDataSource;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getFileEditPanel(), "North");
        container.add((Component)this.getListPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.readFileFromPreferences();
        this.myNumDownloadThreads = Preferences.instance().getInt(PREFS_CTC, PREFS_DOWNLOAD_CONCURRENT, 8);
        this.setOkButtonState();
        this.nodeLB.addListSelectionListener(this);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)abstractSoftMaintPane));
        this.setVisible(true);
    }

    private void readFileFromPreferences() {
        String string = Preferences.instance().getProperty(PREFS_CTC, PREFS_DOWNLOAD_FILE_PATH, null);
        if (string != null && string.length() > 0) {
            boolean bl = true;
            try {
                File file = new File(string);
                if (!file.exists() || !file.canRead()) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                bl = false;
            }
            if (bl) {
                this.fileEdit.setValue(string);
                this.populateLB(string);
            }
        }
    }

    private JPanel getFileEditPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fileEdit = new FilePropertyEditor("Package name:");
        this.fileEdit.setAcceptAllFileFilterUsed(false);
        this.fileEdit.setFilter("Cisco ONS15XXX Software", "pkg");
        this.fileEdit.setTextEntryEnabled(false);
        this.fileEdit.addPropertyChangeListener(this);
        jPanel.add((Component)this.fileEdit, "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("Package version: "));
        this.versionLabel = new JLabel("");
        jPanel2.add(this.versionLabel);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel getListPanel() {
        String string = "Select the nodes to download the package: ";
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nodeLB = new CheckableList();
        this.nodeLB.setVisibleRowCount(6);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)new UScrollPane((Component)this.nodeLB), "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConstCom.SoftMaintSelDialog));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    private boolean apply() {
        DownloadChecker downloadChecker;
        this.selectedFile = (String)this.fileEdit.getValue();
        if (this.selectedFile.length() == 0) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_SW_PKG_NOT_SELECTED);
            return false;
        }
        try {
            downloadChecker = new DownloadChecker(this.selectedFile);
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_INVALID_PKG_FILE);
            return false;
        }
        String string = downloadChecker.getPlatformType();
        boolean bl = string.equals("MSPP") || string.equals("MSTP_UTS");
        boolean bl2 = false;
        ArrayList<NodeVersionInfo> arrayList = new ArrayList<NodeVersionInfo>(0);
        ListModel listModel = this.nodeLB.getModel();
        boolean bl3 = true;
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            bl3 = false;
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)checkableItem.getObject();
            arrayList.add(nodeVersionInfo);
            if (!bl || !downloadChecker.isCompatibleByMsppUtsDownloadEnable(nodeVersionInfo.getNodeModel())) continue;
            bl2 = true;
        }
        Preferences.instance().setProperty(PREFS_CTC, PREFS_DOWNLOAD_FILE_PATH, this.selectedFile);
        if (bl3) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_SW_UPGRADE_NODE_NOT_SELECTED);
            return false;
        }
        if (bl2) {
            StringBuffer stringBuffer = null;
            if (string.equals("MSPP")) {
                stringBuffer = new StringBuffer("One or more nodes selected for TDM package download contains a DWDM package.");
                stringBuffer.append("\nWe do not recommend this download operation as it could lead to traffic loss when\nthe TDM package is activated.\n\nDo you still want continue ?");
            } else {
                stringBuffer = new StringBuffer("One or more nodes selected for DWDM package download contains a TDM package.");
                stringBuffer.append("\nWe do not recommend this download operation as it could lead to traffic loss when\nthe DWDM package is activated.\n\nDo you still want continue ?");
            }
            boolean bl4 = CerentDialog.yesNoDialog((Component)this, (String)stringBuffer.toString(), (String)"Package Download Confirmation");
            if (!bl4) {
                return bl4;
            }
        }
        this.selectedItems = arrayList.toArray(new NodeVersionInfo[0]);
        return true;
    }

    public Object[] getSelectedItems() {
        return this.selectedItems;
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    public int getNumThreads() {
        return this.myNumDownloadThreads;
    }

    private boolean isAuthorized(INodeModel iNodeModel) {
        if (iNodeModel.provides(Feature.SUPPORTS_MAINTENANCE_DOWNLOAD)) {
            return AbstractSoftMaintPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.MAINTENANCE);
        }
        return AbstractSoftMaintPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.SUPERUSER);
    }

    private void populateLB(String string) {
        DownloadChecker downloadChecker;
        ArrayList<CheckableItem> arrayList = new ArrayList<CheckableItem>(0);
        this.nodeLB.setListData(new Object[0]);
        try {
            downloadChecker = new DownloadChecker(string);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.versionLabel.setText("");
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_BAD_PACKAGE_PARAM_1, (Object)exception.getMessage());
            return;
        }
        this.versionLabel.setText(downloadChecker.getFullVersion());
        int n = this.dataSource.getRowCount();
        for (int i = 0; i < n; ++i) {
            INodeModel iNodeModel;
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)this.dataSource.getObjectAtRow(i);
            if (!nodeVersionInfo.canDownload() || !downloadChecker.isCompatible(iNodeModel = nodeVersionInfo.getNodeModel()) || !this.isAuthorized(iNodeModel)) continue;
            arrayList.add(new CheckableItem(nodeVersionInfo, n == 1));
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)((CheckableItem)object).getObject();
                    NodeVersionInfo nodeVersionInfo2 = (NodeVersionInfo)((CheckableItem)object2).getObject();
                    return nodeVersionInfo.toString().compareTo(nodeVersionInfo2.toString());
                }
            });
        }
        this.nodeLB.setListData(arrayList.toArray(new CheckableItem[0]));
        this.setOkButtonState();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setOkButtonState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.selectedFile = (String)this.fileEdit.getValue();
        if (this.selectedFile.length() > 0) {
            this.populateLB(this.selectedFile);
        }
    }

    protected void setOkButtonState() {
        this.okButton.setEnabled(false);
        ListModel listModel = this.nodeLB.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            this.okButton.setEnabled(true);
            return;
        }
    }

    @Override
    public void dispose() {
        try {
            this.nodeLB.removeListSelectionListener(this);
            this.fileEdit.removePropertyChangeListener(this);
            super.dispose();
        }
        catch (Exception exception) {
            db.finer("Exception in dispose() " + exception);
        }
    }
}

