/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Ds123Media.eAttRequestType;
import cerent.cms.idl.Ds123Media.sStats;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NotT1403Mode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.IFixedColumnsTableModel;
import javax.swing.table.AbstractTableModel;

public class Ds1BfdlPmTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    protected TDMTerminology terms;
    protected Ds123LineModel[] model;
    protected sStats[] statsVal;
    protected int numLines;
    protected int numCols;
    protected EntityCellRenderer myPortRenderer;
    public static final int PARAM_COLUMN_INDEX = 0;
    public static final int CSS_ROW_INDEX = 0;
    public static final int ES_ROW_INDEX = 1;
    public static final int SES_ROW_INDEX = 2;
    public static final int BES_ROW_INDEX = 3;
    public static final int UAS_ROW_INDEX = 4;
    public static final int LOFC_ROW_INDEX = 5;
    public static final int EXPECTED_54016_MESSAGE_LENGTH = 98;
    private static final int FIXED_COLUMNS = 1;
    public String[] columnNames;
    public String[] paramNames;
    public sStats[] defaultStats;
    private sStats defStats;
    private static final SDebug db = new SDebug("Ds123PmThresholdsTableModel");

    public Ds1BfdlPmTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        this.terms = iNodeModel.getTDMTerminology();
        String[] stringArray = new String[]{"CSS", "ES", "SES", "BES", "UAS", "LOFC"};
        String[] stringArray2 = new String[]{"Param", "Curr", "Curr 1Day", "Prev", "Prev-1", "Prev-2", "Prev-3", "Prev-4", "Prev-5", "Prev-6", "Prev-7", "Prev-8", "Prev-9", "Prev-10", "Prev-11", "Prev-12", "Prev-13", "Prev-14", "Prev-15", "Prev-16", "Prev-17", "Prev-18", "Prev-19", "Prev-20", "Prev-21", "Prev-22", "Prev-23", "Prev-24", "Prev-25", "Prev-26", "Prev-27", "Prev-28", "Prev-29", "Prev-30", "Prev-31", "Prev-32", "Prev-33", "Prev-34", "Prev-35", "Prev-36", "Prev-37", "Prev-38", "Prev-39", "Prev-40", "Prev-41", "Prev-42", "Prev-43", "Prev-44", "Prev-45", "Prev-46", "Prev-47", "Prev-48", "Prev-49", "Prev-50", "Prev-51", "Prev-52", "Prev-53", "Prev-54", "Prev-55", "Prev-56", "Prev-57", "Prev-58", "Prev-59", "Prev-60", "Prev-61", "Prev-62", "Prev-63", "Prev-64", "Prev-65", "Prev-66", "Prev-67", "Prev-68", "Prev-69", "Prev-70", "Prev-71", "Prev-72", "Prev-73", "Prev-74", "Prev-75", "Prev-76", "Prev-77", "Prev-78", "Prev-79", "Prev-80", "Prev-81", "Prev-82", "Prev-83", "Prev-84", "Prev-85", "Prev-86", "Prev-87", "Prev-88", "Prev-89", "Prev-90", "Prev-91", "Prev-92", "Prev-93", "Prev-94", "Prev-95"};
        this.columnNames = stringArray2;
        this.paramNames = stringArray;
        this.numCols = this.columnNames.length;
        this.model = ds123LineModelArray;
        this.numLines = this.paramNames.length;
        this.init();
    }

    protected void init() {
        this.myPortRenderer = new EntityCellRenderer(true);
        this.numLines = this.numLines;
        this.statsVal = new sStats[this.numCols];
        this.defaultStats = new sStats[this.numCols];
        sPmStat sPmStat2 = new sPmStat(-1, false);
        this.defStats = new sStats(false, null, sPmStat2, sPmStat2, null, null, null, sPmStat2, null, null, null, null, null, null, null, sPmStat2, null, sPmStat2, sPmStat2);
        for (int i = 0; i < this.numCols; ++i) {
            this.statsVal[i] = this.defStats;
            this.defaultStats[i] = this.defStats;
        }
    }

    protected Object getEs(int n) throws NoSuchInterface, WrongInterfaceType, NotT1403Mode {
        return this.statsVal[n].es;
    }

    protected Object getCss(int n) throws NoSuchInterface, WrongInterfaceType, NotT1403Mode {
        return this.statsVal[n].css;
    }

    protected Object getSes(int n) throws NoSuchInterface, WrongInterfaceType, NotT1403Mode {
        return this.statsVal[n].ses;
    }

    protected Object getLofc(int n) throws NoSuchInterface, WrongInterfaceType, NotT1403Mode {
        return this.statsVal[n].lofc;
    }

    protected Object getBes(int n) throws NoSuchInterface, WrongInterfaceType, NotT1403Mode {
        return this.statsVal[n].bes;
    }

    protected Object getUas(int n) throws NoSuchInterface, WrongInterfaceType, NotT1403Mode {
        return this.statsVal[n].uas;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Integer.class;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.numCols;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            if (n2 == 0) {
                return this.paramNames[n];
            }
            int n3 = n2 - 1;
            switch (n) {
                case 1: {
                    return this.getEs(n3);
                }
                case 2: {
                    return this.getSes(n3);
                }
                case 5: {
                    return this.getLofc(n3);
                }
                case 4: {
                    return this.getUas(n3);
                }
                case 0: {
                    return this.getCss(n3);
                }
                case 3: {
                    return this.getBes(n3);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        if (db.on()) {
            db.println("Refreshing line from model");
        }
        this.statsVal[n] = this.defStats;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (int i = 0; i < this.numCols; ++i) {
            this.statsVal[i] = this.defStats;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshModel(int n, int n2) {
        sStats[] sStatsArray = null;
        try {
            this.statsVal = n < 0 ? this.defaultStats : ((sStatsArray = this.model[n].getAtt54016Stats(eAttRequestType.from_int(n2))) == null || sStatsArray.length != 98 ? this.defaultStats : sStatsArray);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            this.statsVal = this.defaultStats;
        }
    }

    public boolean isRowDirty(int n) {
        return false;
    }

    public void resetDirtyBits() {
        if (db.on()) {
            db.println("resetting dirty bits");
        }
    }

    public int getFixedColumnCount() {
        return 1;
    }
}

