/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Ds123Media.eDs1Mapping;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.Ds1ModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.util.SDebug;

public class Ds1LineTableModel
extends Ds123LineTableModel {
    private sLineSyncConfig[] syncConfig;
    private Boolean[] retimingEnabled;
    private Attribute[] ds1Mapping;
    private Attribute[] saBit;
    public static final int PROVIDESSYNC_INDEX = 16;
    public static final int SYNCMESSAGEIN_INDEX = 17;
    public static final int SENDDONOTUSE_INDEX = 18;
    public static final int ENABLERETIMING_INDEX = 19;
    public static final int DS1MAPPING_INDEX = 20;
    public static final int E1SABIT_INDEX = 21;
    public static final int ADMINSSM_INDEX = 22;
    public static final int DS1_LAST_COLUMN = 22;
    public static final String[] ds1ColumnNames = new String[23];

    public Ds1LineTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
        this.syncConfig = new sLineSyncConfig[this.numLines];
        this.retimingEnabled = new Boolean[this.numLines];
        this.ds1Mapping = new Attribute[this.numLines];
        this.saBit = new Attribute[this.numLines];
    }

    @Override
    public int getRangeFor(int n) {
        if (Ds1LineTableModel.between(0, 131, n)) {
            return 131;
        }
        if (Ds1LineTableModel.between(131, 262, n)) {
            return 262;
        }
        if (Ds1LineTableModel.between(262, 393, n)) {
            return 393;
        }
        if (Ds1LineTableModel.between(393, 524, n)) {
            return 524;
        }
        return 655;
    }

    @Override
    protected Attribute getLineLengthAttributeFor(int n) {
        return ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal("DS1_LINE_CARD.Line Length", n);
    }

    @Override
    protected Attribute getDetectedAttributeFor(Object object, int n) {
        db.println("=" + n);
        return this.getAttributeMap().getAttributeForVal("DS1_LINE_CARD." + object.getClass().getName() + ".detected", n);
    }

    @Override
    public int getColumnCount() {
        return ds1ColumnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return ds1ColumnNames[n];
    }

    @Override
    public Class getColumnClass(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 16: {
                    return this.getProvidesSyncFromCard(n);
                }
                case 17: {
                    return this.getSyncMessageIn(n);
                }
                case 18: {
                    return this.getSendDoNotUse(n);
                }
                case 19: {
                    return this.getRetimingEnabled(n);
                }
                case 20: {
                    return this.getDs1Mapping(n);
                }
                case 21: {
                    return this.getE1SaBit(n);
                }
                case 22: {
                    return this.getAdminSsm(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            db.println("Caught exception: " + n2);
            db.println("Caught exception in getValueAt: " + exception);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 17: {
                boolean bl = (Boolean)object;
                if (bl == this.syncConfig[n].syncMessageIn) {
                    return;
                }
                this.syncConfig[n].syncMessageIn = bl;
                break;
            }
            case 18: {
                boolean bl = (Boolean)object;
                if (bl == this.syncConfig[n].sendDoNotUse) {
                    return;
                }
                this.syncConfig[n].sendDoNotUse = bl;
                break;
            }
            case 19: {
                if ((Boolean)object == this.retimingEnabled[n]) {
                    return;
                }
                this.retimingEnabled[n] = (Boolean)object;
                break;
            }
            case 20: {
                if (this.ds1Mapping[n] == object) {
                    return;
                }
                this.ds1Mapping[n] = (Attribute)object;
                break;
            }
            case 21: {
                if (this.saBit[n] == object) {
                    return;
                }
                this.saBit[n] = (Attribute)object;
                break;
            }
            case 22: {
                int n3 = 0;
                try {
                    n3 = ((Attribute)object).getIntValue();
                }
                catch (NullPointerException nullPointerException) {
                    db.println("Null value in Ds1LineTableModel");
                    return;
                }
                if (n3 == this.syncConfig[n].adminSSM.value()) {
                    return;
                }
                if (this.isSonetTiming()) {
                    this.syncConfig[n].adminSSM = eQualityLevel.from_int(n3);
                    break;
                }
                this.syncConfig[n].adminSSM = eQualityLevel.STU_SDH;
                break;
            }
        }
        super.setValueAt(object, n, n2);
    }

    protected sLineSyncConfig getSyncConfig(int n) throws NoSuchInterface, UnsupportedOperation {
        if (this.syncConfig[n] == null) {
            this.syncConfig[n] = ((Ds1LineModel)this.model[n]).getSyncConfig();
        }
        return this.syncConfig[n];
    }

    private Boolean getProvidesSyncFromCard(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).providesSyncFromCard);
    }

    private Boolean getSyncMessageIn(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).syncMessageIn);
    }

    private Boolean getSendDoNotUse(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).sendDoNotUse);
    }

    private Attribute getAdminSsm(int n) throws NoSuchInterface, UnsupportedOperation, AbstractCmsNoSuchEntityException {
        if (this.isSonetTiming()) {
            SynchronizationModel synchronizationModel = ((PortModel)this.model[0].getPortModel()).getChassis().getSyncModel();
            if (synchronizationModel.isG1SsmGeneration()) {
                return this.getAttributeMap().getAttributeForVal("timingSonetSsmQuality", this.getSyncConfig((int)n).adminSSM.value());
            }
            return this.getAttributeMap().getAttributeForVal("timingSonetG2SsmQuality", this.getSyncConfig((int)n).adminSSM.value());
        }
        return this.getAttributeMap().getAttributeForVal("timingSdhSsmQuality", 11);
    }

    protected Boolean getRetimingEnabled(int n) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        if (this.retimingEnabled[n] == null) {
            this.retimingEnabled[n] = new Boolean(((Ds1LineModel)this.model[n]).getDs1RetimingEnabled());
        }
        return this.retimingEnabled[n];
    }

    protected Attribute getDs1Mapping(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.ds1Mapping[n] == null) {
            eDs1Mapping eDs1Mapping2 = ((Ds1LineModel)this.model[n]).getDs1Mapping();
            this.ds1Mapping[n] = this.getAttributeFor(eDs1Mapping2, eDs1Mapping2.value());
        }
        return this.ds1Mapping[n];
    }

    protected Attribute getE1SaBit(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.saBit[n] == null) {
            eSaBit eSaBit2 = ((Ds1LineModel)this.model[n]).getE1SaBit();
            this.saBit[n] = this.getSaBitAttributeFor(eSaBit2.value());
        }
        return this.saBit[n];
    }

    protected Attribute getSaBitAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("DS1_LINE_CARD.SABIT", n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 16: {
                return false;
            }
            case 19: {
                return !this.isSyncReference(n);
            }
            case 17: 
            case 18: {
                return this.isSonetTiming();
            }
            case 22: {
                if (this.isSonetTiming()) {
                    return (Boolean)this.getValueAt(n, 17) == false;
                }
                return false;
            }
        }
        return super.isCellEditable(n, n2);
    }

    private boolean isSyncReference(int n) {
        try {
            Ds1ModuleModel ds1ModuleModel = (Ds1ModuleModel)this.model[n].getModuleModel();
            if (ds1ModuleModel.getEqType() == 218) {
                eCardOperMode eCardOperMode2 = ds1ModuleModel.getCardOperMode();
                int n2 = eCardOperMode2 == eCardOperMode.OPER_MODE_DS1E1_E1_ONLY ? 1 : 0;
                switch (n2) {
                    case 0: {
                        if (n <= 27) break;
                        return true;
                    }
                    case 1: {
                        if (n <= 20) break;
                        return true;
                    }
                }
            }
            return this.getSyncConfig((int)n).providesSyncFromCard;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void refreshFromModel() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            this.syncConfig[i] = null;
            this.retimingEnabled[i] = null;
            this.ds1Mapping[i] = null;
            this.saBit[i] = null;
        }
        super.refreshFromModel();
    }

    @Override
    public void refreshLineFromModel(int n) {
        this.syncConfig[n] = null;
        this.retimingEnabled[n] = null;
        this.ds1Mapping[n] = null;
        this.saBit[n] = null;
        super.refreshLineFromModel(n);
    }

    @Override
    protected Attribute getAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS1_LINE_CARD." + object.getClass().getName(), n);
    }

    private boolean isSonetTiming() {
        return ((NodeModelDelegate)this.node).getNcChassis().getSyncModel().isSonetTimingStandard();
    }

    static {
        System.arraycopy(Ds123LineTableModel.columnNames, 0, ds1ColumnNames, 0, Ds123LineTableModel.columnNames.length);
        Ds1LineTableModel.ds1ColumnNames[16] = "ProvidesSync";
        Ds1LineTableModel.ds1ColumnNames[17] = "SyncMsgIn";
        Ds1LineTableModel.ds1ColumnNames[18] = "Send DoNotUse";
        Ds1LineTableModel.ds1ColumnNames[19] = "Enable Retiming";
        Ds1LineTableModel.ds1ColumnNames[20] = "Ds1 Mapping";
        Ds1LineTableModel.ds1ColumnNames[21] = "SA Bit";
        Ds1LineTableModel.ds1ColumnNames[22] = "Admin SSM";
    }
}

