/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1i;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1i.Ds1iLinePmThresholdsPane;
import cerent.cms.ui.ds1i.Ds1iLineProvPane;
import cerent.cms.ui.ds1i.Ds1iPathPmThresholdsPane;
import cerent.cms.ui.e1.E1SdhPmThresholdsPane;
import cerent.util.TDMTerminology;
import java.awt.Component;

public class Ds1iProvPane
extends NodeProvPane {
    Ds123LineModel[] lineModels = null;

    public Ds1iProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        this(string, tabbedView, ds123LineModelArray, true);
    }

    public Ds1iProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, boolean bl) {
        super(string, tabbedView);
        INodeModel iNodeModel = tabbedView.getUiModel().getNodeModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        this.lineModels = ds123LineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Line", (Component)this.getLineProvTab());
        this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold());
        this.subTabs.addTab("Elect Path Thresholds", (Component)this.getPathThreshold());
        this.subTabs.addTab("SDH Thresholds", (Component)this.getSdhThreshold());
        if (bl) {
            this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        }
        this.add((Component)this.subTabs);
    }

    private Pane getLineProvTab() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1iLineProvPane("DS1 Line", this.getParentView(), this.lineModels));
    }

    private Pane getLineThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1iLinePmThresholdsPane("Line Thresholds", this.getParentView(), this.lineModels));
    }

    private Pane getPathThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1iPathPmThresholdsPane("Elect Path Thresholds", this.getParentView(), this.lineModels));
    }

    private Pane getSdhThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E1SdhPmThresholdsPane("SDH Thresholds", this.getParentView(), this.lineModels));
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }
}

