/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3e;

import cerent.cms.model.Attribute;
import cerent.cms.model.Busy;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds123.Ds123LineMaintTableModel;
import cerent.cms.ui.ds123.Ds123LineMaintenancePane;
import cerent.cms.ui.ds3e.Ds3eMaintenanceTableModel;
import cerent.util.SDebug;
import javax.swing.table.TableColumn;

public class Ds3eLineMaintenancePane
extends Ds123LineMaintenancePane {
    private static final SDebug db = new SDebug("Ds3eLineMaintenance");

    public Ds3eLineMaintenancePane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView, ds123LineModelArray);
    }

    @Override
    protected Ds123LineMaintTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new Ds3eMaintenanceTableModel(iNodeModel, this.lineModels);
    }

    protected boolean supportsSendCode() {
        boolean bl;
        block4: {
            bl = false;
            try {
                int n = this.lineModels[0].getModuleModel().getEqType();
                if (db.on()) {
                    db.println("Checking card type of " + n);
                }
                if (n == 233 || n == 234 || n == 185) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    @Override
    protected void setSendCodeColumnEditor() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        if (this.supportsSendCode()) {
            super.setSendCodeColumnEditor();
        } else {
            this.table.removeColumn(tableColumn);
        }
    }

    @Override
    protected Attribute[] getAttributeArray(Class clazz) {
        return ElementDefaults.getAttributeMap((IModel)this.node).getAttributeArray("DS3E_LINE_CARD." + clazz.getName());
    }

    @Override
    protected void applyDerivativeChangesToModel(int n) throws NoSuchInterface, WrongInterfaceType, InvalidState, UnsupportedOperation, Busy, EMCProvisionError {
        this.lineModels[n].setInhibitLoopback(((Ds3eMaintenanceTableModel)this.dataModel).getInhibitLoopback(n));
        if (this.supportsSendCode()) {
            super.applyDerivativeChangesToModel(n);
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.Ds3eLineMaintenancePane;
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            this.unregisterWithModel();
            this.lineModels = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
            this.numLines = this.lineModels == null ? 0 : this.lineModels.length;
            this.registerWithModel();
            ((Ds3eMaintenanceTableModel)this.dataModel).refreshMyLines(this.lineModels);
        }
    }
}

