/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;

public abstract class AbstractDwdmDynamicPane
extends AbstractPane {
    protected AbstractDwdmLineModel[] dwdmLines;
    protected DwdmModuleModel moduleModel;
    protected AbstractPane currentPane;
    protected InterfaceModel[] upperModels;
    protected List allModels;
    private boolean isVisible = false;
    protected static final SDebug db = new SDebug("AbstractDwdmDynamicPane");

    public AbstractDwdmDynamicPane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView);
        this.setLineModels(abstractDwdmLineModelArray);
        this.setLayout(new BorderLayout());
    }

    public AbstractDwdmDynamicPane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        this(string, tabbedView, dwdmModuleModel.getDwdmLineModels());
        this.moduleModel = dwdmModuleModel;
    }

    protected abstract AbstractPane createDwdmTdmPane();

    protected abstract AbstractPane createDwdmComboPane();

    protected abstract AbstractPane createDwdmRmonPane(DwdmModuleModel var1);

    protected abstract AbstractPane createDwdm8B10BPane(int var1, DwdmModuleModel var2);

    protected AbstractPane createDynamicPane() {
        AbstractPane abstractPane;
        block11: {
            abstractPane = null;
            try {
                if (this.moduleModel != null) {
                    this.setLineModels(this.moduleModel.getDwdmLineModels());
                }
                if (this.dwdmLines != null && this.dwdmLines.length > 0) {
                    int n;
                    int n2 = this.dwdmLines[0].getFramingType();
                    if (n2 != (n = this.dwdmLines[this.dwdmLines.length - 1].getFramingType())) {
                        return this.createDwdmComboPane();
                    }
                    switch (n2) {
                        case 0: 
                        case 1: {
                            abstractPane = this.createDwdmTdmPane();
                            break;
                        }
                        case 2: {
                            abstractPane = this.createDwdmRmonPane(this.moduleModel);
                            break;
                        }
                        case 3: {
                            abstractPane = this.createDwdm8B10BPane(this.dwdmLines[0].getDataRate(), this.moduleModel);
                            break;
                        }
                        case 5: {
                            abstractPane = this.createDwdmUnframedPane(false);
                            break;
                        }
                        default: {
                            db.println("createDynamicPane: Unknown payload type " + n2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                db.println("Exception " + exception + " at getPayloadType()");
                if (!db.on()) break block11;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return abstractPane;
    }

    protected AbstractPane createDwdmUnframedPane(boolean bl) {
        return NAProtectPane.createPane(this.getParentView(), bl);
    }

    @Override
    public JTable getTable() {
        return this.currentPane != null ? this.currentPane.getTable() : null;
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        if (this.currentPane != null) {
            this.remove((Component)((Object)this.currentPane));
            this.currentPane.destroy();
            this.currentPane = null;
        }
        this.currentPane = this.createDynamicPane();
        if (this.currentPane != null) {
            this.add((Component)((Object)this.currentPane), "Center");
            if (this.isVisible) {
                try {
                    this.currentPane.setShowing(true);
                    this.repaint();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                if (this.currentPane.getTable() != null) {
                    TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                }
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.currentPane != null) {
            if (this.currentPane.getTable() != null) {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            }
            this.currentPane.setShowing(false);
        }
        this.isVisible = false;
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.currentPane != null && !this.isUpperLayerModelValid()) {
            this.remove((Component)((Object)this.currentPane));
            this.currentPane.destroy();
            this.currentPane = null;
        }
        if (this.currentPane == null) {
            this.currentPane = this.createDynamicPane();
            if (this.currentPane != null) {
                this.add((Component)((Object)this.currentPane), "Center");
            }
        }
        if (this.currentPane != null) {
            this.currentPane.setShowing(true);
            if (this.currentPane.getTable() != null) {
                TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            }
        }
        this.isVisible = true;
    }

    @Override
    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    @Override
    public void destroy() {
        this.upperModels = null;
        if (this.currentPane != null) {
            this.currentPane.destroy();
            this.currentPane = null;
        }
        super.destroy();
    }

    private boolean isUpperLayerModelValid() {
        try {
            return this.upperModels != null && this.upperModels.length > 0 && this.upperModels[0].getPortModel() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void setLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        this.dwdmLines = abstractDwdmLineModelArray;
        this.upperModels = InterfaceModel.getHigherLayerModels(this.dwdmLines, 1, this.getUiModel()).toArray(new InterfaceModel[this.dwdmLines.length]);
        this.allModels = new ArrayList(this.dwdmLines.length + this.upperModels.length);
        this.allModels.addAll(Arrays.asList(this.dwdmLines));
        this.allModels.addAll(Arrays.asList(this.upperModels));
    }
}

