/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TraceMode;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.Dwdm40GPathPane;
import cerent.cms.ui.dwdm.Dwdm40GPathTableModel;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class Dwdm40GPathProvPane
extends AbstractSubTabbedPane
implements ITabName {
    boolean isSDH;
    DwdmModuleModel mm;
    NAProtectPane notApplTab;
    Dwdm40GPathPane pathPane;
    GenericTraceProvPane j1ProvPane;
    TabbedView parent;
    SDebug db = new SDebug("Dwdm40GPathProvPane");

    public Dwdm40GPathProvPane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        super(string, tabbedView);
        this.mm = dwdmModuleModel;
        this.isSDH = dwdmModuleModel.getNodeModel().getTdmProtocolTypeObj().isSdh();
        this.notApplTab = NAProtectPane.createPane(this.getParentView(), true);
        this.notApplTab.setText("", "");
        this.parent = tabbedView;
    }

    @Override
    protected void createSubTabs() {
        boolean bl = false;
        IGenericTraceLine[] iGenericTraceLineArray = this.mm.getHO();
        if (iGenericTraceLineArray.length > 0) {
            this.pathPane = new Dwdm40GPathPane(this.isSDH ? "SDH" : "SONET", this.subTabs, (TdmHoModel[])iGenericTraceLineArray, new Dwdm40GPathTableModel(this.mm.getNodeModel(), (TdmHoModel[])iGenericTraceLineArray));
            this.subTabs.add((Component)((Object)this.pathPane));
            this.j1ProvPane = new GenericTraceProvPane("J1 Path Trace", this.getParentView(), TraceMode.PATH, iGenericTraceLineArray, 2);
            this.subTabs.add((Component)((Object)this.j1ProvPane));
        } else {
            this.subTabs.add((Component)((Object)this.notApplTab));
        }
    }

    @Override
    public void refresh() {
        this.subTabs.remove((Component)((Object)this.notApplTab));
        this.subTabs.remove((Component)((Object)this.pathPane));
        this.subTabs.remove((Component)((Object)this.j1ProvPane));
        IGenericTraceLine[] iGenericTraceLineArray = this.mm.getHO();
        if (iGenericTraceLineArray.length > 0) {
            if (this.pathPane != null) {
                this.pathPane.refreshFromModel();
            } else {
                this.pathPane = new Dwdm40GPathPane(this.isSDH ? "SDH" : "SONET", this.subTabs, (TdmHoModel[])iGenericTraceLineArray, new Dwdm40GPathTableModel(this.mm.getNodeModel(), (TdmHoModel[])iGenericTraceLineArray));
            }
            if (this.j1ProvPane != null) {
                this.j1ProvPane.refreshMyLines(iGenericTraceLineArray);
                this.j1ProvPane.refreshFromModel();
            } else {
                this.j1ProvPane = new GenericTraceProvPane("J1 Path Trace", this.getParentView(), TraceMode.PATH, iGenericTraceLineArray, 2);
            }
            this.subTabs.add((Component)((Object)this.pathPane));
            this.subTabs.add((Component)((Object)this.j1ProvPane));
        } else {
            this.subTabs.add((Component)((Object)this.notApplTab));
        }
    }

    @Override
    public void enteringPage() throws Exception {
        this.refresh();
    }
}

