/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class DwdmLineMaintTableModel
extends DwdmTableModel
implements IAdminTableAccess {
    private boolean[][] isDirty = null;
    private Attribute[] loopbackVal = null;
    private AdminState[] adminState = null;
    private IServiceState[] serviceState = null;
    public static final String[] columnNames = new String[]{"Port ", "Admin State", "Service State", "Loopback Type"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int ADMIN_STATE_INDEX = 1;
    public static final int SERVICE_STATE_INDEX = 2;
    public static final int LOOPBACK_INDEX = 3;
    private static final SDebug db = new SDebug("DwdmLineMaintTableModel");

    @Override
    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][1];
    }

    public DwdmLineMaintTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(db, abstractDwdmLineModelArray);
        this.refreshMyLines(abstractDwdmLineModelArray);
    }

    @Override
    public AdminState getAdminState(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    private Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.loopbackVal[n] == null) {
            eLoopback eLoopback2 = this.model[n].getLoopback();
            this.loopbackVal[n] = this.getAttributeFor(eLoopback.class.getName(), eLoopback2.value());
        }
        return this.loopbackVal[n];
    }

    @Override
    protected Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("DWDM." + string, n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        db.fine("Change in value " + n + " " + n2);
        switch (n2) {
            case 1: {
                AdminState adminState = (AdminState)object;
                if (this.adminState[n] == adminState) {
                    return;
                }
                this.adminState[n] = adminState;
                if (AdminState.admitsLoopback(adminState.getAdminStateEnum())) break;
                this.setValueAt(this.getAttributeFor(eLoopback.class.getName(), 0), n, 3);
                break;
            }
            case 3: {
                Attribute attribute = (Attribute)object;
                if (attribute == this.loopbackVal[n]) {
                    return;
                }
                this.loopbackVal[n] = (Attribute)object;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public eAdminState getAdminStateFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public eLoopback getLoopbackValFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return eLoopback.from_int(this.loopbackVal[n].getIntValue());
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        block9: {
            if (this.model != null && this.numLines > 0 && n2 != 2) {
                try {
                    DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.model[0].getModuleModel();
                    if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE) && !dwdmModuleModel.isProtectModule()) {
                        if (n2 == 3) {
                            return this.allowsLoopback(this.model[n]) && AdminState.admitsLoopback(this.getAdminStateFor(n));
                        }
                        return n2 > 0;
                    }
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.fine(noSuchInterface.toString());
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (db.on()) {
                        db.fine(wrongInterfaceType.toString());
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block9;
                    db.fine(abstractCmsNoSuchEntityException.toString());
                }
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 2: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getLoopback(n);
                }
            }
        }
        catch (Exception exception) {
            db.severe("Error in getting values " + exception);
        }
        return null;
    }

    private void resetLineCache(int n) {
        this.portNames[n] = null;
        this.loopbackVal[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        db.fine("refreshing line " + n + " from model");
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        db.fine("refreshing table from model");
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isDirty[n][i]) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public void resetDirtyBits() {
        int n = this.getColumnCount();
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < n; ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void applyToModel() throws Exception {
        int n;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (this.isDirty[n][1] && AdminState.admitsLoopback(this.getAdminStateFor(n))) {
                    this.model[n].setAdminState(this.getAdminStateFor(n));
                    this.isDirty[n][1] = false;
                }
                if (this.isDirty[n][3]) {
                    this.model[n].setLoopback(this.getLoopbackValFor(n));
                    this.isDirty[n][3] = false;
                }
                if (!this.isDirty[n][1]) continue;
                this.model[n].setAdminState(this.getAdminStateFor(n));
                this.isDirty[n][1] = false;
            }
        }
        catch (Exception exception) {
            this.refreshFromModel();
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    @Override
    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.loopbackVal = new Attribute[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.fireTableDataChanged();
    }

    private boolean allowsLoopback(AbstractDwdmLineModel abstractDwdmLineModel) throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        int n = abstractDwdmLineModel.getDataRate();
        switch (abstractDwdmLineModel.getModuleModel().getEqType()) {
            case 243: 
            case 282: {
                return n != 21 && n != 25 && n != 26;
            }
            case 183: 
            case 184: {
                return true;
            }
            case 273: {
                return true;
            }
            case 120: {
                return n == 29 || abstractDwdmLineModel.getPayloadType() != 5;
            }
        }
        return abstractDwdmLineModel.getPayloadType() != 5;
    }
}

