/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.FRRProvTableModel;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FRRProvPane
extends NodeProvPane
implements TableModelListener {
    AbstractDwdmLineModel[] models;
    FRRProvTableModel dataModel;
    eIntervalType intervalType = null;
    int numLines;
    boolean notInited = true;
    ModuleModel eqptModel = null;
    NAProtectPane notApplTab;
    protected static final SDebug db = new SDebug("FRRProvPane");

    public FRRProvPane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView);
        this.models = abstractDwdmLineModelArray;
        this.eqptModel = (ModuleModel)this.getUiModel();
        this.notApplTab = NAProtectPane.createPane(this.getParentView(), true);
        this.notApplTab.setSize(new Dimension(150, 100));
        this.notApplTab.setText("", "");
        this.init();
    }

    private boolean isEligibleForFRR() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        int n2;
        int n3;
        block11: {
            n3 = 0;
            n2 = 0;
            n = 0;
            bl3 = false;
            bl2 = false;
            bl = false;
            OTU2XpModuleModel oTU2XpModuleModel = null;
            AbstractDwdmLineModel[] abstractDwdmLineModelArray = null;
            if (this.getUiModel() instanceof OTU2XpModuleModel) {
                oTU2XpModuleModel = (OTU2XpModuleModel)this.getUiModel();
            }
            try {
                if (oTU2XpModuleModel != null) {
                    n3 = oTU2XpModuleModel.getCardMode();
                    n2 = oTU2XpModuleModel.getPort1to3Mode();
                    n = oTU2XpModuleModel.getPort2to4Mode();
                    abstractDwdmLineModelArray = oTU2XpModuleModel.getAllDwdmLineModels();
                }
                if (abstractDwdmLineModelArray != null && abstractDwdmLineModelArray.length > 0) {
                    for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
                        if (abstractDwdmLineModelArray[i].getPayloadType() != 2) continue;
                        bl3 = true;
                    }
                    if (abstractDwdmLineModelArray.length > 0 && abstractDwdmLineModelArray[0] != null && abstractDwdmLineModelArray[0].getPayloadType() == 2) {
                        bl2 = true;
                    }
                    if (abstractDwdmLineModelArray.length > 1 && abstractDwdmLineModelArray[1] != null && abstractDwdmLineModelArray[1].getPayloadType() == 2) {
                        bl = true;
                    }
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block11;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (bl3 && (n3 == 1 || n3 == 2)) {
            return true;
        }
        return n3 == 3 && (n2 == 1 && bl2 || n == 1 && bl);
    }

    protected void init() {
        this.numLines = this.models.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        if (!this.isEligibleForFRR()) {
            this.removeAll();
            this.add((Component)((Object)this.notApplTab));
            this.registerWithModel();
        } else {
            this.table = new UTable((TableModel)this.dataModel);
            UScrollPane uScrollPane = new UScrollPane((Component)this.table);
            this.table.setColumnSelectionAllowed(false);
            this.table.setRowSelectionAllowed(false);
            this.table.setCellSelectionEnabled(true);
            TableColumn tableColumn = this.table.getColumn(FRRProvTableModel.columnNames[1]);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.getAttributeArray("declFRRTriggerThreshold"))));
            tableColumn = this.table.getColumn(FRRProvTableModel.columnNames[3]);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.getAttributeArray("declFRRRevertThreshold"))));
            this.registerWithModel();
            this.add((Component)uScrollPane, "Center");
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            this.notInited = false;
        }
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected Attribute[] getAttributeArray(String string) {
        return ElementDefaults.getAttributeMap(this.eqptModel).getAttributeArray(string);
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].addObserver((Observer)((Object)this));
        }
    }

    protected FRRProvTableModel dataModel() {
        return this.dataModel;
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                FRRProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.models).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            try {
                this.dataModel.refreshLineFromModel(n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)Integer.toString(n + 1));
            }
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        try {
            this.dataModel.applyToModel();
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)provisionError.getEID());
            this.refreshFromModel();
        }
        this.resetDirty();
    }

    protected FRRProvTableModel getDataModel() {
        this.dataModel = new FRRProvTableModel(this.eqptModel, this.models);
        return this.dataModel;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.FRRProvPane;
    }
}

