/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.sTime;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.OpticsPmPane;
import cerent.cms.ui.dwdm.OpticsPmStatTableModel;
import cerent.cms.ui.dwdm.OpticsPmTableModel;
import cerent.cms.ui.tnc.TNCOpticsPmStatTableModel;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OpticsPmStatPane
extends OpticsPmPane
implements PropertyChangeListener {
    private TableColumn colZero = null;
    private JTable table2 = null;
    private MouseListener headerListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = ((JTableHeader)mouseEvent.getComponent()).getTable();
            if (jTable != null) {
                Point point = mouseEvent.getPoint();
                int n = jTable.getTableHeader().columnAtPoint(point);
                if (n != -1) {
                    jTable.addColumnSelectionInterval(n, n);
                }
            }
        }
    };
    private static final SDebug db = new SDebug("Pane.OpticsPmStatPane");

    public OpticsPmStatPane(String string, TabbedView tabbedView, IOpticsPmModel[] iOpticsPmModelArray) {
        super(string, tabbedView, iOpticsPmModelArray);
    }

    @Override
    protected void setupColumnHeader() {
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table2.getTableHeader().setUpdateTableInRealTime(false);
        ((UTable)this.table2).setExportable(false);
        this.table2.setColumnSelectionAllowed(false);
        this.table2.setRowSelectionAllowed(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        int n = this.table.getFontMetrics(this.table.getFont()).stringWidth(" TX Optical Pwr (Max,dBm) ");
        this.colZero = tableColumnModel.getColumn(0);
        tableColumnModel.removeColumn(this.colZero);
        this.colZero.setPreferredWidth(this.colZeroWidth);
        this.colZero.setMinWidth(this.colZeroWidth);
        this.colZero.addPropertyChangeListener(this);
        defaultTableColumnModel.addColumn(this.colZero);
        for (int i = 0; i < this.opticsModels.length; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(new OpticsPortTableHeaderRenderer());
            PortModel portModel = null;
            try {
                portModel = (PortModel)((InterfaceModel)((Object)this.opticsModels[i])).getPortModel();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            tableColumnModel.getColumn(i).setHeaderValue(portModel);
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
        this.table2.setColumnModel(defaultTableColumnModel);
        this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getPreferredWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        this.table2.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(this.headerListener);
    }

    @Override
    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table2 = new UTable((TableModel)this.dataModel);
        this.setupColumnHeader();
        uScrollPane.setRowHeaderView((Component)this.table2);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.table2.getTableHeader());
        uScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = OpticsPmStatPane.createVerticalPanel(null);
        jPanel.add((Component)uScrollPane);
        this.add(jPanel, "Center");
        this.add(this.createButtonBar(false), "South");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.minuteRB.setEnabled(false);
        this.dayRB.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshPB) {
            this.refreshNow();
        } else if (db.on()) {
            db.println("actionPerformed by unknown component");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshNow() {
        try {
            this.setCursor(3);
            if (this.dataModel == null) {
                db.println("dataModel in OpticsPmStatPane is null!");
            } else {
                this.updateTimeLabel();
                this.dataModel.refreshData();
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught exception in OpticsPmStatPane.refreshNow: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            this.setCursor(0);
        }
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        int n = Preferences.instance().getInt(this.autoRefreshPrefPath, this.autoRefreshPrefKey, 0);
        if (null != this.refreshComboBox) {
            int n2 = this.getIndexForMillis(n);
            this.refreshComboBox.setSelectedIndex(n2);
            if (null != this.refreshTimer) {
                if (0 == n2) {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.A");
                    }
                    this.refreshTimer.stop();
                } else if (!this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.B delay = " + this.refreshTimer.getDelay());
                    }
                    this.refreshTimer.start();
                } else if (db.on()) {
                    db.println("refreshTimer was already running with delay = " + this.refreshTimer.getDelay());
                }
            }
        }
        this.refreshNow();
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (null != this.refreshComboBox) {
            this.saveAutoRefreshPref();
        }
        if (null != this.refreshTimer) {
            if (db.on()) {
                db.println("Stopping auto-refresh timer.B");
            }
            this.refreshTimer.stop();
        }
        super.leavingPage();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.table != null && this.table.getTableHeader() != null) {
            this.table.getTableHeader().removeMouseListener(this.headerListener);
        }
        super.dispose();
    }

    @Override
    protected void updateTimeLabel() {
        sTime sTime2;
        try {
            sTime2 = this.nmd.getTime();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            sTime2 = new sTime(0, 0, 0, 1, 1, 1970, false);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(sTime2.year, sTime2.month - 1, sTime2.day, sTime2.hour, sTime2.minute, sTime2.second);
        this.dateLB.setText("Current statistics at " + DateFormat.getDateTimeInstance(1, 1).format(gregorianCalendar.getTime()));
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OpticsPmStatPane;
    }

    @Override
    protected OpticsPmTableModel createDataModel() {
        if (this.module.getEqType() == 330) {
            return new TNCOpticsPmStatTableModel(this.opticsModels, this.nmd);
        }
        return new OpticsPmStatTableModel(this.opticsModels, this.nmd);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.table2 == null || this.colZero == null) {
            db.severe("propertyChange() : on disposed table model");
        } else {
            this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        }
    }

    public class OpticsPortTableHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public void updateUI() {
            super.updateUI();
            LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
            LookAndFeel.installBorder(this, "TableHeader.cellBorder");
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && object instanceof PortModel) {
                try {
                    PortModel portModel = (PortModel)object;
                    EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                    this.setText("Port " + entityCellRenderer.getPortString(portModel, false));
                    this.setToolTipText("Port " + entityCellRenderer.getPortString(portModel, false));
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    this.setText("?????");
                }
            } else {
                this.setText("?????");
            }
            return this;
        }
    }
}

