/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.OtnThresholdProvPane;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class OtnThresholdPane
extends AbstractPane {
    protected AbstractDwdmLineModel[] models;
    protected OtnThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String FE_TCM2_1DAY_PANEL = "FE_TCM2_1DAY";
    protected static final String FE_TCM2_15MIN_PANEL = "FE_TCM2_15MIN";
    protected static final String NE_TCM2_1DAY_PANEL = "NE_TCM2_1DAY";
    protected static final String NE_TCM2_15MIN_PANEL = "NE_TCM2_15MIN";
    protected static final String FE_TCM1_1DAY_PANEL = "FE_TCM1_1DAY";
    protected static final String FE_TCM1_15MIN_PANEL = "FE_TCM1_15MIN";
    protected static final String NE_TCM1_1DAY_PANEL = "NE_TCM1_1DAY";
    protected static final String NE_TCM1_15MIN_PANEL = "NE_TCM1_15MIN";
    protected static final String FE_PATH_1DAY_PANEL = "FE_PATH_1DAY";
    protected static final String FE_PATH_15MIN_PANEL = "FE_PATH_15MIN";
    protected static final String NE_PATH_1DAY_PANEL = "NE_PATH_1DAY";
    protected static final String NE_PATH_15MIN_PANEL = "NE_PATH_15MIN";
    protected static final String FE_SEC_1DAY_PANEL = "FE_SEC_1DAY";
    protected static final String FE_SEC_15MIN_PANEL = "FE_SEC_15MIN";
    protected static final String NE_SEC_1DAY_PANEL = "NE_SEC_1DAY";
    protected static final String NE_SEC_15MIN_PANEL = "NE_SEC_15MIN";
    protected static final int FE_TCM2_1DAY = 15;
    protected static final int FE_TCM2_15MIN = 14;
    protected static final int NE_TCM2_1DAY = 13;
    protected static final int NE_TCM2_15MIN = 12;
    protected static final int FE_TCM1_1DAY = 11;
    protected static final int FE_TCM1_15MIN = 10;
    protected static final int NE_TCM1_1DAY = 9;
    protected static final int NE_TCM1_15MIN = 8;
    protected static final int FE_PATH_1DAY = 7;
    protected static final int FE_PATH_15MIN = 6;
    protected static final int NE_PATH_1DAY = 5;
    protected static final int NE_PATH_15MIN = 4;
    protected static final int FE_SEC_1DAY = 3;
    protected static final int FE_SEC_15MIN = 2;
    protected static final int NE_SEC_1DAY = 1;
    protected static final int NE_SEC_15MIN = 0;
    protected static final int PANE_NUM = 16;
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private static final SDebug db = new SDebug("OtnThresholdPane");

    public OtnThresholdPane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView);
        this.models = abstractDwdmLineModelArray;
        this.panes = new Pane[16];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (((DwdmModuleModel)this.getUiModel()).hasPluggableTrunk()) {
            if (db.on()) {
                db.println("Registering for pluggable trunk line update");
            }
            this.registerWithModel();
        }
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
            AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.isADMCard() ? dwdmModuleModel.removeIlkTrkLineModels(dwdmModuleModel.getAdmDwdmTrkLineModels()) : dwdmLineUpdate.getDwdmOTNSupportLineModels();
            if (abstractDwdmLineModelArray.length != this.models.length) {
                this.models = abstractDwdmLineModelArray;
                this.panes = new Pane[16];
                this.removeAll();
                this.initializeLayout();
                this.getButtonPanel().refreshAction();
                TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            }
        }
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
    }

    protected OtnThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new OtnThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.tablePanel == null) {
            this.tablePanel = new JPanel();
            this.cl = new CardLayout();
            this.tablePanel.setLayout(this.cl);
            this.tablePanel.setPreferredSize(new Dimension(800, 300));
        } else {
            this.tablePanel.removeAll();
        }
        this.panes[0] = this.getOtnThresholdProvPane(NE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true, eMonitorType.MON_SECTION);
        this.tablePanel.add((Component)this.panes[0], NE_SEC_15MIN_PANEL);
        this.panes[1] = this.getOtnThresholdProvPane(NE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true, eMonitorType.MON_SECTION);
        this.tablePanel.add((Component)this.panes[1], NE_SEC_1DAY_PANEL);
        this.panes[2] = this.getOtnThresholdProvPane(FE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false, eMonitorType.MON_SECTION);
        this.tablePanel.add((Component)this.panes[2], FE_SEC_15MIN_PANEL);
        this.panes[3] = this.getOtnThresholdProvPane(FE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false, eMonitorType.MON_SECTION);
        this.tablePanel.add((Component)this.panes[3], FE_SEC_1DAY_PANEL);
        this.panes[4] = this.getOtnThresholdProvPane(NE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true, eMonitorType.MON_PATH);
        this.tablePanel.add((Component)this.panes[4], NE_PATH_15MIN_PANEL);
        this.panes[5] = this.getOtnThresholdProvPane(NE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true, eMonitorType.MON_PATH);
        this.tablePanel.add((Component)this.panes[5], NE_PATH_1DAY_PANEL);
        this.panes[6] = this.getOtnThresholdProvPane(FE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false, eMonitorType.MON_PATH);
        this.tablePanel.add((Component)this.panes[6], FE_PATH_15MIN_PANEL);
        this.panes[7] = this.getOtnThresholdProvPane(FE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false, eMonitorType.MON_PATH);
        this.tablePanel.add((Component)this.panes[7], FE_PATH_1DAY_PANEL);
        this.panes[8] = this.getOtnThresholdProvPane(NE_TCM1_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true, eMonitorType.MON_TANDEM_CONN1);
        this.tablePanel.add((Component)this.panes[8], NE_TCM1_15MIN_PANEL);
        this.panes[9] = this.getOtnThresholdProvPane(NE_TCM1_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true, eMonitorType.MON_TANDEM_CONN1);
        this.tablePanel.add((Component)this.panes[9], NE_TCM1_1DAY_PANEL);
        this.panes[10] = this.getOtnThresholdProvPane(FE_TCM1_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false, eMonitorType.MON_TANDEM_CONN1);
        this.tablePanel.add((Component)this.panes[10], FE_TCM1_15MIN_PANEL);
        this.panes[11] = this.getOtnThresholdProvPane(FE_TCM1_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false, eMonitorType.MON_TANDEM_CONN1);
        this.tablePanel.add((Component)this.panes[11], FE_TCM1_1DAY_PANEL);
        this.panes[12] = this.getOtnThresholdProvPane(NE_TCM2_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true, eMonitorType.MON_TANDEM_CONN2);
        this.tablePanel.add((Component)this.panes[12], NE_TCM2_15MIN_PANEL);
        this.panes[13] = this.getOtnThresholdProvPane(NE_TCM2_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true, eMonitorType.MON_TANDEM_CONN2);
        this.tablePanel.add((Component)this.panes[13], NE_TCM2_1DAY_PANEL);
        this.panes[14] = this.getOtnThresholdProvPane(FE_TCM2_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false, eMonitorType.MON_TANDEM_CONN2);
        this.tablePanel.add((Component)this.panes[14], FE_TCM2_15MIN_PANEL);
        this.panes[15] = this.getOtnThresholdProvPane(FE_TCM2_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false, eMonitorType.MON_TANDEM_CONN2);
        this.tablePanel.add((Component)this.panes[15], FE_TCM2_1DAY_PANEL);
        this.cl.show(this.tablePanel, NE_SEC_15MIN_PANEL);
        this.currentPane = this.panes[0];
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected OtnThresholdProvPane getOtnThresholdProvPane(String string, eIntervalType eIntervalType2, boolean bl, eMonitorType eMonitorType2) {
        return new OtnThresholdProvPane(string, this.getParentView(), this.models, eIntervalType2, bl, eMonitorType2);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    @Override
    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        this.getButtonPanel().refreshAction();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    @Override
    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            if (this.panes[i] instanceof OtnThresholdProvPane) {
                ((OtnThresholdProvPane)this.panes[i]).dispose();
            }
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class OtnThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonSection;
        public JRadioButton buttonPath;
        public JRadioButton buttonTCM1;
        public JRadioButton buttonTCM2;
        public JButton showButton = new JButton("Refresh");
        public JButton resetToDefaultButton = new JButton("Reset to Default");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secPathButtonGroup;
        protected int TCM2_MASK = 12;
        protected int TCM1_MASK = 8;
        protected int PATH_MASK = 4;
        protected int FE_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public OtnThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonSection = new JRadioButton("SM (OTUk)", true);
            this.buttonPath = new JRadioButton("PM (ODUk)");
            this.buttonTCM1 = new JRadioButton("TCM-1");
            this.buttonTCM2 = new JRadioButton("TCM-2");
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            this.secPathButtonGroup = new ButtonGroup();
            this.secPathButtonGroup.add(this.buttonSection);
            this.secPathButtonGroup.add(this.buttonPath);
            this.showButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OtnThresholdButtonPanel.this.refreshAction();
                }
            });
            this.resetToDefaultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OtnThresholdButtonPanel.this.resetToDefaultAction();
                }
            });
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Directions "));
            jPanel.setPreferredSize(dimension);
            jPanel.add(this.buttonNE);
            jPanel.add(this.buttonFE);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2, 0, 0));
            jPanel3.setBorder(BorderFactory.createTitledBorder(" Types "));
            jPanel3.setPreferredSize(new Dimension(dimension.width * 2, dimension.height));
            jPanel3.add(this.buttonSection);
            jPanel3.add(this.buttonPath);
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(this.showButton);
            this.add(this.resetToDefaultButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void resetToDefaultAction() {
            if (CerentDialog.yesNoDialog((Component)this, (String)"Do you really want to reset the thresholds to the default threshold values?", (String)"Reset to default")) {
                this.resetWithDefaultPmThresholds();
                return;
            }
        }

        public void resetWithDefaultPmThresholds() {
            int n = 0;
            OtnThresholdPane.this.tableLabelString = " ";
            OtnThresholdProvPane otnThresholdProvPane = null;
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                if (db.on()) {
                    db.println("FE");
                }
                n |= this.FE_MASK;
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + "Far End";
            } else {
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + "Near End";
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n |= this.ONE_DAY_MASK;
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", 1 Day";
            } else {
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", 15 Min";
            }
            if (this.secPathButtonGroup.getSelection() == this.buttonPath.getModel()) {
                if (db.on()) {
                    db.println("Path pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", Path";
                n |= this.PATH_MASK;
            } else if (this.secPathButtonGroup.getSelection() == this.buttonTCM1.getModel()) {
                if (db.on()) {
                    db.println("TCM-1 pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", TCM1";
                n |= this.TCM1_MASK;
            } else if (this.secPathButtonGroup.getSelection() == this.buttonTCM2.getModel()) {
                if (db.on()) {
                    db.println("TCM-2 pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", TCM2";
                n |= this.TCM2_MASK;
            } else {
                if (db.on()) {
                    db.println("Section pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", Section";
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("NE SEC 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[0];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("NE SEC 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[1];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("FE SEC 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[2];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("FE SEC 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[3];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 4: {
                    if (db.on()) {
                        db.println("NE PATH 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[4];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 5: {
                    if (db.on()) {
                        db.println("NE PATH 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[5];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 6: {
                    if (db.on()) {
                        db.println("FE PATH 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[6];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 7: {
                    if (db.on()) {
                        db.println("FE PATH 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[7];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 8: {
                    if (db.on()) {
                        db.println("NE TCM1 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[8];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 9: {
                    if (db.on()) {
                        db.println("NE TCM1 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[9];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 10: {
                    if (db.on()) {
                        db.println("FE TCM1 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[10];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 11: {
                    if (db.on()) {
                        db.println("FE TCM1 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[11];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 12: {
                    if (db.on()) {
                        db.println("NE TCM2 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[12];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 13: {
                    if (db.on()) {
                        db.println("NE TCM2 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[13];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 14: {
                    if (db.on()) {
                        db.println("FE TCM2 15MIN");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[14];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
                case 15: {
                    if (db.on()) {
                        db.println("FE TCM2 1DAY");
                    }
                    otnThresholdProvPane = (OtnThresholdProvPane)OtnThresholdPane.this.panes[15];
                    try {
                        otnThresholdProvPane.refreshFromNeDefaults();
                        break;
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        db.println("Error applying changes");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            OtnThresholdPane.this.tableLabel.setText(OtnThresholdPane.this.tableLabelString);
        }

        public void refreshAction() {
            int n = 0;
            OtnThresholdPane.this.tableLabelString = " ";
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                if (db.on()) {
                    db.println("FE");
                }
                n |= this.FE_MASK;
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + "Far End";
            } else {
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + "Near End";
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n |= this.ONE_DAY_MASK;
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", 1 Day";
            } else {
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", 15 Min";
            }
            if (this.secPathButtonGroup.getSelection() == this.buttonPath.getModel()) {
                if (db.on()) {
                    db.println("Path pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", Path";
                n |= this.PATH_MASK;
            } else if (this.secPathButtonGroup.getSelection() == this.buttonTCM1.getModel()) {
                if (db.on()) {
                    db.println("TCM-1 pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", TCM1";
                n |= this.TCM1_MASK;
            } else if (this.secPathButtonGroup.getSelection() == this.buttonTCM2.getModel()) {
                if (db.on()) {
                    db.println("TCM-2 pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", TCM2";
                n |= this.TCM2_MASK;
            } else {
                if (db.on()) {
                    db.println("Section pressed");
                }
                OtnThresholdPane.this.tableLabelString = OtnThresholdPane.this.tableLabelString + ", Section";
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("NE SEC 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("NE SEC 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[1]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("FE SEC 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[2]);
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("FE SEC 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[3]);
                    break;
                }
                case 4: {
                    if (db.on()) {
                        db.println("NE PATH 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[4]);
                    break;
                }
                case 5: {
                    if (db.on()) {
                        db.println("NE PATH 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[5]);
                    break;
                }
                case 6: {
                    if (db.on()) {
                        db.println("FE PATH 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[6]);
                    break;
                }
                case 7: {
                    if (db.on()) {
                        db.println("FE PATH 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[7]);
                    break;
                }
                case 8: {
                    if (db.on()) {
                        db.println("NE TCM1 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[8]);
                    break;
                }
                case 9: {
                    if (db.on()) {
                        db.println("NE TCM1 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[9]);
                    break;
                }
                case 10: {
                    if (db.on()) {
                        db.println("FE TCM1 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[10]);
                    break;
                }
                case 11: {
                    if (db.on()) {
                        db.println("FE TCM1 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[11]);
                    break;
                }
                case 12: {
                    if (db.on()) {
                        db.println("NE TCM2 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[12]);
                    break;
                }
                case 13: {
                    if (db.on()) {
                        db.println("NE TCM2 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[13]);
                    break;
                }
                case 14: {
                    if (db.on()) {
                        db.println("FE TCM2 15MIN");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[14]);
                    break;
                }
                case 15: {
                    if (db.on()) {
                        db.println("FE TCM2 1DAY");
                    }
                    OtnThresholdPane.this.showPanel(OtnThresholdPane.this.panes[15]);
                }
            }
            OtnThresholdPane.this.tableLabel.setText(OtnThresholdPane.this.tableLabelString);
        }
    }
}

