/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e13;

import cerent.cms.idl.Ds123Media.eSendCode;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.e13.E13LineMaintTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class E13LineMaintenancePane
extends NodeProvPane
implements TableModelListener {
    protected INodeModel node;
    protected E13LineMaintTableModel dataModel = null;
    protected Ds123LineModel[] lineModels = null;
    protected JScrollPane scrollPane = null;
    protected Runnable updateThread = null;
    protected int numLines = 0;
    private static final SDebug db = new SDebug("E13LineMaintenance");

    public E13LineMaintenancePane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        TableColumn tableColumn = null;
        this.lineModels = ds123LineModelArray;
        Attribute[] attributeArray = null;
        if (ds123LineModelArray == null) {
            if (db.on()) {
                db.println("DS123 Lines are null");
            }
            this.numLines = 0;
        } else {
            this.numLines = ds123LineModelArray.length;
        }
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(200, 150));
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(this.node.getTdmProtocolType()));
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        try {
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        }
        catch (NoSuchElementException noSuchElementException) {
            this.table.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        try {
            attributeArray = this.getAttributeArray(eLoopback.class);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        try {
            attributeArray = this.getAttributeArray(eSendCode.class);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.getAttributeArray(eSendCode.class))));
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        tableColumn.sizeWidthToFit();
        this.registerWithModel();
        this.add(this.scrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected E13LineMaintTableModel getDataModel() {
        if (this.lineModels == null && db.on()) {
            db.println("LINE MODELS ARE NULL");
        }
        return new E13LineMaintTableModel(this.node, this.lineModels);
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    @Override
    public void dispose() {
        if (db.on()) {
            db.println("Called dispose");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                E13LineMaintenancePane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In E13LineMaintenancePane changeMessage cannot find Model " + observable);
        }
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.node);
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS123." + clazz.getName());
    }

    private boolean verifyApplyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            if (!bl && AdminState.isTransitionToOOS(this.dataModel.getAdminStateFor(i), this.lineModels[i].getAdminStateEnum())) {
                bl = true;
                if (bl2) break;
            }
            if (bl2 || this.dataModel.getLoopbackValFor(i) == eLoopback.NO_LOOPBACK || !this.lineModels[i].getLoopback().equals(eLoopback.NO_LOOPBACK)) continue;
            bl2 = true;
            if (bl) break;
        }
        if (bl || bl2) {
            if (bl) {
                stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            }
            if (bl2) {
                stringBuffer.append("Some lines are being placed in Loopback.").append('\n');
            }
            if (bl) {
                stringBuffer.append(this.getSeverityWarningMsg(bl2));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            bl3 = CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return bl3;
    }

    private String getSeverityWarningMsg(boolean bl) {
        String string;
        try {
            String string2 = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
            string = string2 + "\n\n" + this.getApplyString(false);
        }
        catch (Exception exception) {
            string = "\n" + this.getApplyString();
        }
        return string;
    }

    protected void applyInterdependentChangesToModel(int n) throws Exception {
        if (db.on()) {
            db.println("Setting Loopback for " + (n + 1) + " To " + this.dataModel.getLoopbackValFor(n).value());
        }
        if (AdminState.admitsLoopback(this.dataModel.getAdminStateFor(n))) {
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
            this.applyLoopbackAisChanges(n);
        } else if (AdminState.admitsLoopback(this.lineModels[n].getAdminStateEnum())) {
            this.applyLoopbackAisChanges(n);
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
        } else {
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
            this.applyAisChanges(n);
        }
    }

    protected void applyDerivativeChangesToModel(int n) throws Exception {
    }

    @Override
    public void applyChangesToModel() throws AnnotatedException {
        int n = 0;
        try {
            if (!this.verifyApplyChangesToModel()) {
                return;
            }
            for (n = 0; n < this.numLines; ++n) {
                if (!this.dataModel.isRowDirty(n)) continue;
                this.applyInterdependentChangesToModel(n);
                this.applyDerivativeChangesToModel(n);
            }
            this.dataModel.resetDirtyBits();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        if (db.on()) {
            db.println("Got table changed event");
        }
        int n = 0;
        int n2 = this.numLines - 1;
        if (n != -1) {
            n = tableModelEvent.getFirstRow() < 0 ? 0 : tableModelEvent.getFirstRow();
            n2 = tableModelEvent.getLastRow() > this.numLines ? this.numLines - 1 : tableModelEvent.getLastRow();
        }
        db.info("tableChanged: first/last row are " + n + "/" + n2);
        for (int i = n; i <= n2; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            db.info(" rows are dirty");
            this.setDirty();
            return;
        }
        if (db.on()) {
            db.println("No rows are dirty");
        }
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        try {
            this.refreshFromModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_PANE);
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        if (this.lineModels != null) {
            this.dataModel.refreshFromModel();
            this.resetDirty();
        }
    }

    protected void applyAisChanges(int n) throws Exception {
        if (this.dataModel.isDirty(n, 5)) {
            this.lineModels[n].setFacLoopbackAis(this.dataModel.getFacLoopbackAis(n));
        }
        if (this.dataModel.isDirty(n, 6)) {
            this.lineModels[n].setTermLoopbackAis(this.dataModel.getTermLoopbackAis(n));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void applyLoopbackAisChanges(int n) throws Exception {
        if (!this.dataModel.isDirty(n, 5)) {
            if (!this.dataModel.isDirty(n, 6)) {
                this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
                return;
            }
        }
        if (this.dataModel.getLoopbackValFor(n) == eLoopback.NO_LOOPBACK) {
            this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
            this.applyAisChanges(n);
            return;
        }
        this.applyAisChanges(n);
        this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
    }
}

