/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.ui.ether.EtherMacAddrTableModel;
import cerent.cms.ui.ether.MacAddrDataSource;
import cerent.cms.ui.ether.MacAddrSourceInfo;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;

public class MacAddrClrDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Clear MAC Address";
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    public static final int MARGIN = 5;
    private JButton okButton;
    private JButton cancelButton;
    private JTable table;
    private EtherMacAddrTableModel dataModel;
    private JRadioButton byPairRB;
    private JRadioButton byVlanRB;
    private JRadioButton byPortRB;
    private JComboBox vlanCB;
    private JComboBox portCB;

    public MacAddrClrDialog(Frame frame, JTable jTable) {
        super(frame, TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MacAddrClrDialog.this.dispose();
            }
        });
        this.table = jTable;
        this.dataModel = (EtherMacAddrTableModel)((Object)jTable.getModel());
        Container container = this.getContentPane();
        container.add((Component)this.createAttributesPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.byPairRB = this.makeActionRadioButton("Clear selected VLAN/MAC pairs", true);
        buttonGroup.add(this.byPairRB);
        this.byVlanRB = this.makeActionRadioButton("Clear by VLAN", false);
        buttonGroup.add(this.byVlanRB);
        this.byPortRB = this.makeActionRadioButton("Clear by Port", false);
        buttonGroup.add(this.byPortRB);
        if (this.table.getSelectedRowCount() == 0) {
            this.byPairRB.setEnabled(false);
            this.byVlanRB.setSelected(true);
        }
        this.vlanCB = new JComboBox((E[])this.getVlanList());
        this.vlanCB.setRenderer(new VlanRenderer());
        this.portCB = new JComboBox((E[])this.getPortList());
        this.portCB.setRenderer(new MacAddrPortRenderer());
        this.vlanCB.setEnabled(this.byVlanRB.isSelected());
        this.portCB.setEnabled(this.byPortRB.isSelected());
        jPanel.add(this.byPairRB);
        jPanel.add(new JLabel(""));
        jPanel.add(this.byVlanRB);
        jPanel.add(this.vlanCB);
        jPanel.add(this.byPortRB);
        jPanel.add(this.portCB);
        return jPanel;
    }

    private Object[][] getVlanList() {
        MacAddrDataSource macAddrDataSource = (MacAddrDataSource)this.dataModel.getDataSource();
        TreeMap treeMap = macAddrDataSource.getVlanTreeMap();
        Object[] objectArray = treeMap.keySet().toArray();
        Object[][] objectArray2 = new Object[treeMap.size()][2];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i][0] = objectArray[i];
            objectArray2[i][1] = treeMap.get(objectArray[i]);
        }
        return objectArray2;
    }

    private Object[][] getPortList() {
        MacAddrDataSource macAddrDataSource = (MacAddrDataSource)this.dataModel.getDataSource();
        TreeMap treeMap = macAddrDataSource.getPortTreeMap();
        Object[] objectArray = treeMap.keySet().toArray();
        Object[][] objectArray2 = new Object[treeMap.size()][2];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i][0] = objectArray[i];
            objectArray2[i][1] = treeMap.get(objectArray[i]);
        }
        return objectArray2;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JRadioButton makeActionRadioButton(String string, boolean bl) {
        JRadioButton jRadioButton = new JRadioButton(string, bl);
        jRadioButton.addActionListener(this);
        return jRadioButton;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.byPairRB) {
            this.vlanCB.setEnabled(false);
            this.portCB.setEnabled(false);
        } else if (object == this.byVlanRB) {
            this.vlanCB.setEnabled(true);
            this.portCB.setEnabled(false);
        } else if (object == this.byPortRB) {
            this.vlanCB.setEnabled(false);
            this.portCB.setEnabled(true);
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private boolean apply() {
        if (this.byPairRB.isSelected()) {
            this.dataModel.clearSelectedRows(this.table.getSelectedRows());
        } else if (this.byVlanRB.isSelected()) {
            if (this.vlanCB.getSelectedIndex() == -1) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"VLAN");
                return false;
            }
            Object[] objectArray = (Object[])this.vlanCB.getSelectedItem();
            this.dataModel.clearByVlan((Short)objectArray[1]);
        } else if (this.byPortRB.isSelected()) {
            if (this.portCB.getSelectedIndex() == -1) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"port");
                return false;
            }
            Object[] objectArray = (Object[])this.portCB.getSelectedItem();
            this.dataModel.clearByPort((Integer)objectArray[1]);
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    class MacAddrPortRenderer
    extends JLabel
    implements ListCellRenderer {
        public MacAddrPortRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            try {
                this.setText(((MacAddrSourceInfo)objectArray[0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    class VlanRenderer
    extends JLabel
    implements ListCellRenderer {
        public VlanRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            try {
                this.setText((String)objectArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

