/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.FcmrPortModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.fcmr.FcmrLineMaintTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FcmrLineMaintPane
extends NodeProvPane
implements TableModelListener {
    private FcmrLineMaintTableModel dataModel = null;
    private FcmrLineModel[] lineModels = null;
    private int numLines = 0;
    private int numPorts = 0;
    private static final SDebug db = new SDebug("FcmrLineMaintPane");

    public FcmrLineMaintPane(String string, TabbedView tabbedView, FcmrPortModel[] fcmrPortModelArray, FcmrLineModel[] fcmrLineModelArray) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        FcmrModuleModel fcmrModuleModel = null;
        this.lineModels = fcmrLineModelArray;
        this.numPorts = fcmrPortModelArray == null ? 0 : fcmrPortModelArray.length;
        int n = this.numLines = fcmrLineModelArray == null ? 0 : fcmrLineModelArray.length;
        if (this.getParentView().getUiModel() instanceof FcmrModuleModel) {
            fcmrModuleModel = (FcmrModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not FcmrModuleModel");
        }
        this.dataModel = new FcmrLineMaintTableModel(fcmrModuleModel, fcmrPortModelArray, fcmrLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(fcmrModuleModel.getNodeModel().getTdmProtocolType()));
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[3]);
        attributeArray = this.getAttributeArray("G1000 Loopback Type");
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        this.table.sizeColumnsToFit(-1);
        this.registerForUpdates();
        this.add(jScrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private UComboBox getComboBoxFor(Attribute[] attributeArray) {
        UComboBox uComboBox = new UComboBox((Object[])attributeArray);
        uComboBox.setEditable(false);
        return uComboBox;
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.getParentView().getUiModel().getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    private void registerForUpdates() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                FcmrLineMaintPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In FcmrLineMaintPane change Message cannot find Model " + observable);
        }
    }

    @Override
    public void destroy() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
            }
            this.lineModels = null;
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.numPorts == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.numPorts ? this.numPorts - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws AnnotatedException {
        int n = 0;
        try {
            if (!this.verifyApplyChangesToModel()) {
                return;
            }
            for (n = 0; n < this.numLines; ++n) {
                if (!this.dataModel.isRowDirty(n)) continue;
                this.applyInterdependentChangesToModel(n);
            }
            this.dataModel.resetRowDirty();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refresh();
        this.dataModel.resetRowDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected void applyInterdependentChangesToModel(int n) throws Exception {
        if (db.on()) {
            db.println("Setting Loopback for " + (n + 1) + " To " + this.dataModel.getLoopbackFor(n));
        }
        eAdminState eAdminState2 = this.dataModel.getAdminStateFor(n);
        sFCLineAdminInfo sFCLineAdminInfo2 = this.dataModel.getLineAdminInfo(n);
        switch (eAdminState2.value()) {
            case 0: 
            case 1: 
            case 3: {
                sFCLineAdminInfo2.portState = eAdminState2;
                sFCLineAdminInfo2.portLoopback = eLoopback.from_int(0);
                this.lineModels[n].setFcLineAdminInfo(sFCLineAdminInfo2);
                break;
            }
            case 2: {
                sFCLineAdminInfo2.portState = eAdminState2;
                sFCLineAdminInfo2.portLoopback = eLoopback.from_int(this.dataModel.getLoopbackFor(n));
                this.lineModels[n].setFcLineAdminInfo(sFCLineAdminInfo2);
                break;
            }
        }
    }

    private boolean verifyApplyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.dataModel.isRowDirty(i) || this.dataModel.getLineAdminInfo((int)i).portLoopback == eLoopback.NO_LOOPBACK || this.lineModels[i].getFcLineAdminInfo().portLoopback != eLoopback.NO_LOOPBACK) continue;
            stringBuffer.append("Some lines are being placed in Loopback.").append('\n');
            break;
        }
        if (stringBuffer.length() > 0) {
            if (bl2) {
                stringBuffer.append(AdminState.getSevWarningMsg(this.dataModel, this.lineModels, false));
            }
            bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return bl;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.FcmrLineMaintPane;
    }
}

