/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvChassisModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvSlotModel;
import cerent.cms.model.INodeShelfModel;
import cerent.cms.ui.functional.FunctNode;
import cerent.cms.ui.functional.FunctNodeCardElem;
import cerent.cms.ui.functional.ViewManagerDelegate;
import cerent.util.view.fv.IViewGrapherTreeEvt;
import cerent.util.view.fv.TreeViewCommand;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.helper.IFunctNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class FunctNodeManager
implements IViewGrapherTreeEvt {
    private IFvNodeModel nm;
    private FunctNode root;
    private DefaultMutableTreeNode treemodel = null;
    private ViewManagerDelegate viewManager = null;
    static final String SQUARE_BRACHET_OPEN = "[";
    static final String SQUARE_BRACHET_CLOSED = "] ";

    public FunctNodeManager(IFvNodeModel iFvNodeModel, ViewManagerDelegate viewManagerDelegate) {
        this.nm = iFvNodeModel;
        this.viewManager = viewManagerDelegate;
        this.init();
    }

    public void dispose() {
        this.root = null;
        this.treemodel = null;
        this.viewManager = null;
    }

    private void init() {
        this.getFunctionalNodes();
        this.treemodel = this.createTree(this.root);
    }

    private IFunctNode getFunctionalNodes() {
        this.root = new FunctNode(this.nm.getName());
        this.root.setNodeTyp(1);
        IFvChassisModel[] iFvChassisModelArray = this.nm.getAllChassisModels();
        Arrays.sort(iFvChassisModelArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                if (object instanceof IFvEntityModel && object2 instanceof IFvEntityModel) {
                    IFvEntityModel iFvEntityModel = (IFvEntityModel)object;
                    IFvEntityModel iFvEntityModel2 = (IFvEntityModel)object2;
                    n = iFvEntityModel.getShelfId() - iFvEntityModel2.getShelfId();
                }
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return this.equals(object);
            }
        });
        for (int i = 0; i < iFvChassisModelArray.length; ++i) {
            this.makeNode((IFvEntityModel)iFvChassisModelArray[i], this.root);
        }
        return this.root;
    }

    private FunctNode getRoot() {
        return this.root;
    }

    private IFunctNode makeNode(IFvEntityModel iFvEntityModel, IFunctNode iFunctNode) {
        FunctNode functNode = null;
        if (this.isChassis(iFvEntityModel)) {
            String string = "Shelf";
            if (this.isMultiShelf(iFvEntityModel)) {
                string = string + "Id " + iFvEntityModel.getShelfId();
                functNode = new FunctNode(string, iFunctNode);
                functNode.setNodeTyp(5);
            } else {
                functNode = new FunctNode(string, iFunctNode);
                functNode.setNodeTyp(4);
            }
            ArrayList arrayList = this.getCards(iFvEntityModel);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.makeNode((IFvEntityModel)arrayList.get(i), functNode);
            }
        } else if (this.isCard(iFvEntityModel)) {
            functNode = new FunctNodeCardElem((IFvCardModel)iFvEntityModel, iFunctNode);
            functNode.setNodeTyp(6);
        } else if (iFvEntityModel instanceof IFvSlotModel) {
            IFvSlotModel iFvSlotModel = (IFvSlotModel)iFvEntityModel;
            functNode = new FunctNode(FunctNodeManager.getNodeLabel((IFvEntityModel)iFvSlotModel, true), iFunctNode);
        }
        iFunctNode.addChild(functNode);
        return functNode;
    }

    public static String getNodeLabel(IFvEntityModel iFvEntityModel, boolean bl) {
        int n = iFvEntityModel.getSlot();
        String string = SQUARE_BRACHET_OPEN;
        if (n < 10) {
            string = string + "0";
        }
        string = string + n;
        string = bl ? string + "] Empty Slot" : string + SQUARE_BRACHET_CLOSED + iFvEntityModel.getEqLabel();
        return string;
    }

    private boolean isMultiShelf(IFvEntityModel iFvEntityModel) {
        return ((INodeShelfModel)iFvEntityModel).isMultishelf();
    }

    private boolean isChassis(IFvEntityModel iFvEntityModel) {
        return iFvEntityModel instanceof INodeShelfModel;
    }

    private boolean isCard(IFvEntityModel iFvEntityModel) {
        return iFvEntityModel instanceof IFvCardModel;
    }

    private ArrayList getCards(IFvEntityModel iFvEntityModel) {
        ArrayList arrayList = new ArrayList();
        List list = iFvEntityModel.getChildren();
        IFvEntityModel iFvEntityModel2 = null;
        if (list != null && list.size() > 0) {
            iFvEntityModel2 = (IFvEntityModel)list.get(0);
        }
        List list2 = null;
        if (iFvEntityModel2 != null) {
            list2 = iFvEntityModel2.getChildren();
        }
        int n = list2 != null ? list2.size() : 17;
        IFvEntityModel iFvEntityModel3 = null;
        for (int i = 1; i <= n; ++i) {
            String string = "Empty";
            if (list2 == null) continue;
            iFvEntityModel3 = (IFvEntityModel)list2.get(i - 1);
            List list3 = iFvEntityModel3.getChildren();
            if (list3.size() > 0) {
                Object e = list3.get(0);
                if (!(e instanceof IFvCardModel)) continue;
                arrayList.add(e);
                if (!this.isDoubleSlot((IFvCardModel)e)) continue;
                ++i;
                continue;
            }
            arrayList.add(iFvEntityModel3);
        }
        return arrayList;
    }

    private boolean isDoubleSlot(IFvCardModel iFvCardModel) {
        switch (iFvCardModel.getEqType()) {
            case 132: 
            case 191: 
            case 192: 
            case 241: 
            case 242: 
            case 263: 
            case 264: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 297: {
                return true;
            }
        }
        return false;
    }

    private DefaultMutableTreeNode createTree(IFunctNode iFunctNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(iFunctNode);
        IFunctNode[] iFunctNodeArray = iFunctNode.getChildren();
        for (int i = 0; i < iFunctNodeArray.length; ++i) {
            defaultMutableTreeNode.add(this.createTree(iFunctNodeArray[i]));
        }
        return defaultMutableTreeNode;
    }

    private void debugNode(IFunctNode iFunctNode) {
        String string = "";
        switch (iFunctNode.getNodeTyp()) {
            case 1: {
                string = "NODE_ROOT_TYP";
                break;
            }
            case 4: {
                string = "NODE_SHELF_TYP";
                break;
            }
            case 5: {
                string = "NODE_CHASSIS_TYP";
                break;
            }
            case 6: {
                string = "NODE_CARD_TYP";
                break;
            }
            case 3: {
                string = "NODE_ELE_TYP";
                break;
            }
            case 7: {
                string = "NODE_SIDE_TYP";
                break;
            }
            case 2: {
                string = "NODE_OTHER_TYP";
                break;
            }
            case 0: {
                string = "NODE_UNK_TYP";
            }
        }
        ViewManager.addToLog((Object)this, (String)("node: " + iFunctNode.getFullName() + " is a " + string));
    }

    private IFunctNode getFunctNode(TreePath treePath) {
        Object var2_2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return (IFunctNode)defaultMutableTreeNode.getUserObject();
    }

    private void setRoot(FunctNode functNode) {
        this.root = functNode;
    }

    public void doTreeClick(TreeViewCommand treeViewCommand) {
        IFunctNode iFunctNode = this.getFunctNode(treeViewCommand.getEvent().getPath());
        if (iFunctNode != null) {
            iFunctNode.nodeClicked(treeViewCommand);
        }
    }
}

