/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.NodeAlarmPane;
import cerent.cms.ui.event.NodeHistoryPane;
import cerent.cms.ui.event.ShelfAlarmPane;
import cerent.cms.ui.functional.ViewManagerDelegate;
import cerent.cms.ui.functional.circuit.FunctionalCircuitPath;
import cerent.util.EID;
import cerent.util.IFvDebug;
import cerent.util.gui.IFunctionalView;
import cerent.util.view.fv.helper.FunctDebug;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedList;

public class FunctionalTabbedView
extends MainTabbedView
implements ITabName,
IFunctionalView {
    private IEventPanelController myController;
    private IGuestPaneFactory gpf;
    private Pane alarmPane;
    private IFvSideModel sideModel;
    protected IFvDebug db = FunctDebug.instance().addChild("FunctionalTabbedView", "Dump the info related to TabView");
    ViewManagerDelegate vm;
    private int activeCircuitId;
    private FunctionalCircuitPath circuitPath;
    private Pane circuitPane;

    public FunctionalTabbedView(INodeModel iNodeModel, ViewManagerDelegate viewManagerDelegate, IFvSideModel iFvSideModel) {
        super((IModel)iNodeModel);
        this.init(viewManagerDelegate, iFvSideModel);
    }

    public FunctionalTabbedView(IChassisModel iChassisModel, ViewManagerDelegate viewManagerDelegate, IFvSideModel iFvSideModel) {
        super(iChassisModel);
        this.init(viewManagerDelegate, iFvSideModel);
    }

    private void init(ViewManagerDelegate viewManagerDelegate, IFvSideModel iFvSideModel) {
        this.vm = viewManagerDelegate;
        this.gpf = viewManagerDelegate.getToolKit();
        this.sideModel = iFvSideModel;
        this.showing = true;
        this.circuitPath = new FunctionalCircuitPath(viewManagerDelegate, this.sideModel);
        viewManagerDelegate.setFunctionalCircuitPath(this.circuitPath);
        this.myController = viewManagerDelegate.getEventPanelController();
        int n = iFvSideModel != null ? iFvSideModel.getId() : 0;
        this.alarmPane = this.getAlarmTab(n);
        this.addTab("Alarms", (Component)this.alarmPane);
        this.circuitPane = this.getCircuitTab();
        this.addTab("Circuits", (Component)this.circuitPane);
    }

    public Pane getAlarmTab(int n) {
        NodeAlarmPane nodeAlarmPane = null;
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.uiModel.getNodeModel();
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)nodeModelDelegate.getElementAlarmStore();
        if (!nodeModelDelegate.isMultishelf()) {
            elementAlarmStore = (ElementAlarmStore)((ChassisModel)this.uiModel).getShelfAlarmStore();
            nodeAlarmPane = n == 0 ? new ShelfAlarmPane("Alarms", nodeModelDelegate, (TabbedView)this, elementAlarmStore, this.myController) : new ShelfAlarmPane("Alarms", nodeModelDelegate, (TabbedView)this, elementAlarmStore.getSideAlarmStore(DwdmSide.getSideFromOffset(n)), this.myController);
        } else {
            elementAlarmStore = (ElementAlarmStore)nodeModelDelegate.getElementAlarmStore();
            nodeAlarmPane = n == 0 ? new NodeAlarmPane("Alarms", nodeModelDelegate, (TabbedView)this, elementAlarmStore, this.myController) : new NodeAlarmPane("Alarms", nodeModelDelegate, (TabbedView)this, elementAlarmStore.getSideAlarmStore(DwdmSide.getSideFromOffset(n)), this.myController);
        }
        return nodeAlarmPane;
    }

    @Override
    public Pane getEventTab() {
        ElementEventStore elementEventStore = (ElementEventStore)((ChassisModel)this.uiModel).getShelfEventStore();
        return new NodeHistoryPane("History", this, elementEventStore, this.myController);
    }

    @Override
    public Pane getCircuitTab() {
        return (Pane)this.gpf.getGuestPane(15, (TabbedView)this);
    }

    @Override
    public void destroy() {
        this.myController = null;
        this.gpf = null;
        this.circuitPane.destroy();
        this.alarmPane.destroy();
        super.destroy();
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
    }

    public IEventPanelController getMyController() {
        return this.myController;
    }

    @Override
    public Pane getAlarmTab() {
        return null;
    }

    public IFvSideModel getSide() {
        return this.sideModel;
    }

    public void createDwdmPath(IFVSelectedPowerModel iFVSelectedPowerModel, int n) {
        int n2;
        IEntityModel iEntityModel2;
        int n3;
        INodeOpticsTopologyModel iNodeOpticsTopologyModel = null;
        InterfaceModel interfaceModel = null;
        if (iFVSelectedPowerModel.getCircuitModel() == null) {
            return;
        }
        HashMap<Integer, IEntityModel> hashMap = new HashMap<Integer, IEntityModel>();
        int n4 = iFVSelectedPowerModel.getLambda();
        LinkedList linkedList = iFVSelectedPowerModel.getPathIn();
        if (linkedList.size() > 0) {
            if (linkedList == null) {
                return;
            }
            for (n3 = 0; n3 < linkedList.size(); ++n3) {
                iEntityModel2 = (IEntityModel)linkedList.get(n3);
                if (hashMap.containsKey(iEntityModel2.getIndex())) continue;
                hashMap.put(iEntityModel2.getIndex(), iEntityModel2);
            }
        }
        if (((n2 = iFVSelectedPowerModel.getCircuitType().intValue()) == 15 || n2 == 14) && (linkedList = iFVSelectedPowerModel.getPathOut()).size() > 0) {
            if (linkedList == null) {
                return;
            }
            for (n3 = 0; n3 < linkedList.size(); ++n3) {
                iEntityModel2 = (IEntityModel)linkedList.get(n3);
                if (hashMap.containsKey(iEntityModel2.getIndex())) continue;
                hashMap.put(iEntityModel2.getIndex(), iEntityModel2);
            }
        }
        for (IEntityModel iEntityModel2 : hashMap.values()) {
            if (!(iEntityModel2 instanceof IPortModel)) continue;
            IPortModel iPortModel = (IPortModel)iEntityModel2;
            InterfaceModel[] interfaceModelArray = null;
            interfaceModel = (InterfaceModel)iPortModel.getInterfaceModel();
            if (!(interfaceModel instanceof DwdmTrkLineModel) && !(interfaceModel instanceof OpticsChannelModel)) {
                if (!(interfaceModel instanceof OpticsLineModel) && !(interfaceModel instanceof OpticsAmplifiedLineModel)) continue;
                InterfaceModel interfaceModel2 = (InterfaceModel)iPortModel.getInterfaceModel();
                interfaceModelArray = interfaceModel2.getHigherLayerModels();
                for (int i = 0; i < interfaceModelArray.length; ++i) {
                    try {
                        if (((AbstractOpticsLineModel)interfaceModelArray[i]).getActualWaveLength() != n4) continue;
                        interfaceModel = interfaceModelArray[i];
                        continue;
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        wrongInterfaceType.printStackTrace();
                        continue;
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        noSuchInterface.printStackTrace();
                    }
                }
            }
            iNodeOpticsTopologyModel = this.uiModel.getNodeModel().getINodeOpticsTopologyModel();
            if (this.db.on()) {
                this.db.println("Adding circuit path elements associated w/ port: " + iEntityModel2);
            }
            this.circuitPath.addPath(iNodeOpticsTopologyModel.getAllOchListFromPort(interfaceModel.getIndex()), n2, n4);
        }
        this.circuitPath.paint();
        this.activeCircuitId = n;
    }

    public void deleteDwdmPath(int n) {
        if (this.activeCircuitId == n) {
            this.vm.getCircuitsPathManager().clearActiveCircuit();
        }
    }

    public void deleteAllDwdmPath() {
        this.vm.getCircuitsPathManager().clearActiveCircuit();
    }
}

