/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmPortModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.functional.link.FunctTxpViewLink;
import cerent.cms.ui.functional.link.FunctViewPureGraphicalLink;
import cerent.util.view.fv.IViewLink;
import java.util.HashMap;
import java.util.StringTokenizer;

public class PowerInfoComposerHelper {
    public static final String POUT = "POUT";
    public static final String PIN = "PIN";
    public static final String IDX = "IDX";
    public static final String NAME = "NAME";

    public static HashMap<String, String> addThisLink(IFvOptLinkModel iFvOptLinkModel, IFvPortModel iFvPortModel, IFvPortModel iFvPortModel2, IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2, int n, int n2, IFvNodeModel iFvNodeModel) throws NoSuchInterface, WrongInterfaceType {
        return PowerInfoComposerHelper.addLink(iFvOptLinkModel.getIndex(), iFvPortModel, iFvPortModel2, n, n2, iFvNodeModel, new String[2], null);
    }

    public static HashMap<String, String> addThisLink(int n, IFvPortModel iFvPortModel, IFvPortModel iFvPortModel2, IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2, int n2, int n3, IFvNodeModel iFvNodeModel) throws NoSuchInterface, WrongInterfaceType {
        return PowerInfoComposerHelper.addLink(n, iFvPortModel, iFvPortModel2, n2, n3, iFvNodeModel, new String[2], null);
    }

    public static HashMap<String, String> addThisCircuitLink(IViewLink iViewLink, IFvPortModel iFvPortModel, IFvPortModel iFvPortModel2, IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2, int n, int n2, IFvNodeModel iFvNodeModel, String[] stringArray, String string) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (iViewLink instanceof FunctTxpViewLink) {
            return PowerInfoComposerHelper.addThisCircuitTXPLink((FunctTxpViewLink)iViewLink, iFvEntityModel, iFvEntityModel2, string);
        }
        if (iViewLink instanceof FunctViewPureGraphicalLink) {
            if (stringArray != null) {
                String string2 = stringArray[0];
                stringArray[0] = stringArray[1];
                stringArray[1] = string2;
            }
            return PowerInfoComposerHelper.addLink(iViewLink.getIndex(), iFvPortModel, iFvPortModel2, n, n2, iFvNodeModel, stringArray, string);
        }
        return PowerInfoComposerHelper.addLink(iViewLink.getIndex(), iFvPortModel, iFvPortModel2, n, n2, iFvNodeModel, stringArray, string);
    }

    public static HashMap<String, String> addThisPort(IFvPortModel iFvPortModel, int n, boolean bl, IFvNodeModel iFvNodeModel) {
        return PowerInfoComposerHelper.addPort(iFvPortModel, n, bl, iFvNodeModel, null, null);
    }

    public static HashMap<String, String> addThisPort(IFvPortModel iFvPortModel, int n, boolean bl, IFvNodeModel iFvNodeModel, String string, String string2) {
        return PowerInfoComposerHelper.addPort(iFvPortModel, n, bl, iFvNodeModel, string, string2);
    }

    private static HashMap<String, String> addPort(IFvPortModel iFvPortModel, int n, boolean bl, IFvNodeModel iFvNodeModel, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 == null) {
            hashMap.put(IDX, String.valueOf(iFvPortModel.getIndex()));
        } else {
            hashMap.put(IDX, string2);
        }
        String string3 = PowerInfoComposerHelper.cardName(n, iFvPortModel);
        String string4 = "";
        if (bl) {
            PowerInfoComposerHelper.portName(string3, iFvPortModel, POUT, hashMap, string);
        } else {
            PowerInfoComposerHelper.portName(string3, iFvPortModel, PIN, hashMap, string);
        }
        PowerInfoComposerHelper.setName(iFvNodeModel, string4, string3, hashMap);
        return hashMap;
    }

    private static HashMap<String, String> addLink(int n, IFvPortModel iFvPortModel, IFvPortModel iFvPortModel2, int n2, int n3, IFvNodeModel iFvNodeModel, String[] stringArray, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            hashMap.put(IDX, new Integer(n).toString());
        } else {
            hashMap.put(IDX, string);
        }
        String string2 = PowerInfoComposerHelper.cardName(n2, iFvPortModel);
        PowerInfoComposerHelper.portName(string2, iFvPortModel, POUT, hashMap, stringArray[1]);
        String string3 = PowerInfoComposerHelper.cardName(n3, iFvPortModel2);
        PowerInfoComposerHelper.portName(string3, iFvPortModel2, PIN, hashMap, stringArray[0]);
        PowerInfoComposerHelper.setName(iFvNodeModel, string3, string2, hashMap);
        return hashMap;
    }

    private static void setName(IFvNodeModel iFvNodeModel, String string, String string2, HashMap<String, String> hashMap) {
        String string3 = null;
        String string4 = iFvNodeModel.getName() + "\n   ";
        string3 = string4 + string2 + "\n   " + string;
        hashMap.put(NAME, string3);
    }

    private static String portName(String string, IFvPortModel iFvPortModel, String string2, HashMap<String, String> hashMap, String string3) {
        try {
            if (iFvPortModel instanceof IFvOpticsPortModel) {
                if (((IFvOpticsPortModel)iFvPortModel).isPassivePort()) {
                    string3 = "N/A";
                } else {
                    String string4 = ((IFvOpticsPortModel)iFvPortModel).getOptPortTypeString();
                    string = string + "/" + string4;
                    IFvOpticsLineModel iFvOpticsLineModel = (IFvOpticsLineModel)iFvPortModel.getIFvInterfaceModel();
                    if (string3 == null && (string3 = PowerInfoComposerHelper.portHasNIM(string4, iFvPortModel.getCardModel(), iFvOpticsLineModel)) == null) {
                        string3 = ConvertPwrToDb.convertPwrToDb(new Integer(iFvOpticsLineModel.getActualPower()));
                    }
                }
            } else if (iFvPortModel instanceof IFvDwdmPortModel) {
                string = string + "/Trunk-TX";
                IFvInterfaceModel iFvInterfaceModel = iFvPortModel.getIFvInterfaceModel();
                string3 = PowerInfoComposerHelper.getCurrentPwr(string2, iFvInterfaceModel);
            } else {
                string = string + "/Trunk-TX";
                IFvInterfaceModel iFvInterfaceModel = iFvPortModel.getIFvInterfaceModel();
                string3 = PowerInfoComposerHelper.getCurrentPwr(string2, iFvInterfaceModel);
            }
        }
        catch (Exception exception) {
            string3 = "N/A";
        }
        hashMap.put(string2, string3);
        return string;
    }

    public static String getCurrentPwr(String string, IFvInterfaceModel iFvInterfaceModel) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        String string2 = "N/A";
        int n = -1;
        if (string.equals(PIN)) {
            n = 0;
        } else if (string.equals(POUT)) {
            n = 1;
        }
        if (n != -1) {
            string2 = ConvertPwrToDb.converPmValue(iFvInterfaceModel.getCurrentPmPower()[n], 0);
        }
        return string2;
    }

    private static String portHasNIM(String string, IFvCardModel iFvCardModel, IFvOpticsLineModel iFvOpticsLineModel) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (string.contains("OSC")) {
            return ConvertPwrToDb.convertPwrToDb(new Integer(iFvOpticsLineModel.getOSCPower()));
        }
        if (iFvCardModel.getEqType() == 128 && string.contains("LINE")) {
            int n = iFvCardModel.getSide();
            IFvSideModel[] iFvSideModelArray = iFvCardModel.getIFVNodeModel().getIfvSideModels();
            for (int i = 0; i < iFvSideModelArray.length; ++i) {
                IFvSideModel iFvSideModel = iFvSideModelArray[i];
                if (iFvSideModel.getId() != n) continue;
                IFvEntityModel iFvEntityModel = iFvCardModel.getIFVNodeModel().getEntityModelByIndex(iFvSideModel.getLineIn()).getParentModel();
                if (iFvEntityModel == iFvCardModel) {
                    return null;
                }
                return ConvertPwrToDb.convertPwrToDb(new Integer(iFvOpticsLineModel.getOSCPower()));
            }
        }
        return null;
    }

    private static String cardName(int n, IFvPortModel iFvPortModel) {
        String string = " (" + DwdmSide.getSideFromOffset(DwdmSide.getSideLabelFromId(n)) + ") ";
        if (string.contains("Unknown")) {
            string = "";
        }
        String string2 = string + iFvPortModel.getCardModel().getEqLabel() + " " + iFvPortModel.getPortString() + ": ";
        if (iFvPortModel.getIFVNodeModel().isMultishelf()) {
            string2 = string2 + iFvPortModel.getShelfId() + "-";
        }
        string2 = string2 + iFvPortModel.getSlot() + "-" + iFvPortModel.getPort();
        return string2;
    }

    public static HashMap<String, String> addThisCircuitTXPLink(FunctTxpViewLink functTxpViewLink, IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2, String string) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IDX, string);
        String string2 = !(iFvEntityModel instanceof IFvOpticsCardModel) ? iFvEntityModel.getEqLabel() : iFvEntityModel2.getEqLabel();
        hashMap.put(NAME, string2);
        hashMap.put(PIN, PowerInfoComposerHelper.getCurrentPwr(PIN, (IFvInterfaceModel)functTxpViewLink.getTrnk()));
        hashMap.put(POUT, PowerInfoComposerHelper.getCurrentPwr(POUT, (IFvInterfaceModel)functTxpViewLink.getTrnk()));
        return hashMap;
    }

    public static String getEAD_EXPRXNumber(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        while (!string2.contains("EAD") && !string2.contains("EXP-RX")) {
            string2 = stringTokenizer.nextToken();
        }
        return stringTokenizer.nextToken();
    }
}

