/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.idl.Common.eBandGridOpticalType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.WzDiagDebug;
import java.util.Stack;

public class IntPatchCreationInfo {
    private INodeModel node;
    private eIntPatchCordType patchType;
    private boolean isBidi;
    private int wlen = -1;
    private boolean cl = false;
    private eBandGridOpticalType grid;
    private eIntPatchPortType pt = null;
    private boolean mpo = false;
    private boolean psmProtection = false;
    private boolean autorun = false;
    private boolean repetition = false;
    private int termIdx;
    private Stack<TermInfo> termsInfo;
    private final WzDiagDebug db;

    public IntPatchCreationInfo(INodeModel iNodeModel, WzDiagDebug wzDiagDebug) {
        this.node = iNodeModel;
        this.db = wzDiagDebug;
        this.init();
    }

    private void init() {
        this.db.info("IntPatchCreationInfo.<init>");
        this.termsInfo = new Stack();
        this.termsInfo.push(new TermInfo(this.mpo));
        this.termIdx = 0;
    }

    public INodeModel getNode() {
        return this.node;
    }

    public boolean isBidi() {
        return this.isBidi;
    }

    public void setBidi(boolean bl) {
        this.isBidi = bl;
    }

    public eIntPatchCordType getPatchType() {
        return this.patchType;
    }

    public void setPatchType(eIntPatchCordType eIntPatchCordType2) {
        this.db.info("setPatchType=" + (Object)((Object)eIntPatchCordType2));
        if (this.patchType == null || this.patchType != eIntPatchCordType2) {
            this.patchType = eIntPatchCordType2;
            this.init();
        }
    }

    public int getWavelength() {
        return this.wlen;
    }

    public void setWavelength(int n) {
        this.db.info("setWavelength=" + n);
        if (this.wlen != n) {
            this.wlen = n;
            this.init();
        }
    }

    public boolean isColorless() {
        return this.cl;
    }

    public void setColorless(boolean bl) {
        this.db.info("setColorless=" + bl);
        if (this.cl != bl) {
            this.cl = bl;
            this.init();
        }
    }

    public eBandGridOpticalType getGrid() {
        return this.grid;
    }

    public void setGrid(eBandGridOpticalType eBandGridOpticalType2) {
        this.db.info("setGrid=" + eBandGridOpticalType2);
        if (this.grid != eBandGridOpticalType2) {
            this.grid = eBandGridOpticalType2;
            this.init();
        }
    }

    public void setPortTypeFilter(eIntPatchPortType eIntPatchPortType2) {
        this.db.info("setPortTypeFilter=" + (Object)((Object)eIntPatchPortType2));
        if (this.pt != eIntPatchPortType2) {
            this.pt = eIntPatchPortType2;
            this.init();
        }
    }

    public boolean isMPOConnection() {
        return this.mpo;
    }

    public void setMPOConnection(boolean bl) {
        this.db.info("setMPOConnection=" + bl);
        if (this.mpo != bl) {
            this.mpo = bl;
            this.init();
        }
    }

    public void setPsmProtection(boolean bl) {
        this.db.info("setPsmProtection=" + bl);
        if (this.psmProtection != bl) {
            this.psmProtection = bl;
            this.init();
        }
    }

    public boolean isPsmProtection() {
        return this.psmProtection;
    }

    public void setAutorun(boolean bl) {
        this.db.info("setAutorun=" + bl);
        this.autorun = bl;
    }

    public boolean isAutorun() {
        return this.autorun;
    }

    public boolean acceptRepetition() {
        return this.repetition;
    }

    public void setAcceptRepetition(boolean bl) {
        this.db.info("setAcceptRepetition=" + bl);
        if (this.repetition != bl) {
            this.repetition = bl;
            this.init();
        }
    }

    INodeModel getNodeModel() {
        return this.node;
    }

    public TermInfo[] getTermsInfo() {
        int n = this.termIdx > 0 ? this.termIdx : 1;
        TermInfo[] termInfoArray = new TermInfo[n];
        for (int i = 0; i < n; ++i) {
            termInfoArray[i] = (TermInfo)this.termsInfo.get(i);
        }
        return termInfoArray;
    }

    public TermInfo[] getActiveTermsInfo() {
        TermInfo[] termInfoArray = new TermInfo[this.termIdx];
        for (int i = 0; i < this.termIdx; ++i) {
            termInfoArray[i] = (TermInfo)this.termsInfo.get(i);
        }
        return termInfoArray;
    }

    public TermInfo getActiveTerm() {
        return (TermInfo)this.termsInfo.get(this.termIdx);
    }

    public TermInfo getPreviousTerm() {
        if (this.termIdx > 0) {
            return (TermInfo)this.termsInfo.get(this.termIdx - 1);
        }
        return null;
    }

    public int getActiveTermIdx() {
        return this.termIdx;
    }

    public boolean isEntityUsed(IEntityModel iEntityModel, boolean bl, boolean bl2) {
        for (int i = 0; i < this.termIdx; ++i) {
            TermInfo termInfo = (TermInfo)this.termsInfo.get(i);
            if (termInfo == null || iEntityModel != termInfo.getSrcPort() && iEntityModel != termInfo.getDstPort() && iEntityModel != termInfo.getSecSrcPort() && iEntityModel != termInfo.getSecDstPort()) continue;
            if (this.db.on()) {
                this.db.info(iEntityModel + " already used @ " + i + "/" + this.termIdx);
            }
            return true;
        }
        TermInfo termInfo = (TermInfo)this.termsInfo.get(this.termIdx);
        if (termInfo != null) {
            if (bl) {
                if (bl2 && (iEntityModel == termInfo.getSrcPort() || iEntityModel == termInfo.getDstPort())) {
                    if (this.db.on()) {
                        this.db.info(iEntityModel + " already used @ latest");
                    }
                    return true;
                }
            } else {
                if (iEntityModel == termInfo.getSrcPort()) {
                    if (this.db.on()) {
                        this.db.info(iEntityModel + " already used @ source");
                    }
                    return true;
                }
                if (bl2 && (iEntityModel == termInfo.getDstPort() || iEntityModel == termInfo.getSecSrcPort())) {
                    if (this.db.on()) {
                        this.db.info(iEntityModel + " already used @ source/destination");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public eIntPatchPortType getPatchPortType(boolean bl, boolean bl2) {
        return this.getPatchPortType(bl, bl2, 0);
    }

    public eIntPatchPortType getNextPatchPortType(boolean bl, boolean bl2) {
        return this.getPatchPortType(bl, bl2, 1);
    }

    public TermInfo push() {
        ++this.termIdx;
        this.db.info("push()=" + this.termIdx);
        if (this.termIdx == this.termsInfo.size()) {
            this.termsInfo.push(new TermInfo(this.mpo));
        }
        return this.getActiveTerm();
    }

    public TermInfo pop() {
        if (this.termIdx > 0) {
            --this.termIdx;
        }
        this.db.info("pop()=" + this.termIdx);
        return this.getActiveTerm();
    }

    public IModuleModel getPSMModule() {
        if (this.psmProtection) {
            switch (this.getPSMStep()) {
                case 3: {
                    if (this.patchType == eIntPatchCordType.OCH2OCH) {
                        return ((TermInfo)this.termsInfo.get(0)).srcPort.getModuleModel();
                    }
                }
                case 2: {
                    if (this.patchType != eIntPatchCordType.TRK2OCH) break;
                    return ((TermInfo)this.termsInfo.get(0)).dstPort.getModuleModel();
                }
            }
        }
        return null;
    }

    private static boolean isFirstOrLatest(boolean bl, boolean bl2) {
        return bl && !bl2 || !bl && bl2;
    }

    private eIntPatchPortType getPatchPortType(boolean bl, boolean bl2, int n) {
        if (this.psmProtection) {
            switch (this.getPSMStep() + n) {
                case 1: {
                    return IntPatchCreationInfo.isFirstOrLatest(bl, bl2) ? eIntPatchPortType.TRK : eIntPatchPortType.PSM_COM;
                }
                case 2: {
                    return IntPatchCreationInfo.isFirstOrLatest(bl, bl2) ? eIntPatchPortType.PSM_WRK : eIntPatchPortType.OCH;
                }
                case 3: {
                    return IntPatchCreationInfo.isFirstOrLatest(bl, bl2) ? eIntPatchPortType.PSM_PRT : eIntPatchPortType.OCH;
                }
            }
            return eIntPatchPortType.NONE;
        }
        switch (this.patchType) {
            case TRK2OCH: {
                return IntPatchCreationInfo.isFirstOrLatest(bl, bl2) ? eIntPatchPortType.TRK : eIntPatchPortType.OCH;
            }
            case OCH2OCH: {
                return eIntPatchPortType.OCH;
            }
            case OTS2OTS: {
                if (this.pt != null) {
                    return this.pt;
                }
                return eIntPatchPortType.OTS;
            }
            case TRK2TRK: {
                return eIntPatchPortType.TRKL2;
            }
        }
        return eIntPatchPortType.NONE;
    }

    private int getPSMStep() {
        return this.patchType == eIntPatchCordType.TRK2OCH ? this.termIdx + 1 : this.termIdx + 2;
    }

    public static class TermInfo {
        private IEntityModel srcPort;
        private IEntityModel secSrcPort;
        private IEntityModel[] secSrcPorts;
        private IEntityModel dstPort;
        private IEntityModel secDstPort;
        private IEntityModel[] secDstPorts;
        private boolean revAutoSrc;
        private boolean revAutoDst;
        private boolean mpo;

        public TermInfo(boolean bl) {
            this.mpo = bl;
        }

        public TermInfo(TermInfo termInfo) {
            this.srcPort = termInfo.srcPort;
            this.secDstPort = termInfo.secDstPort;
            this.secDstPorts = termInfo.secDstPorts;
            this.secSrcPort = termInfo.secSrcPort;
            this.secSrcPorts = termInfo.secSrcPorts;
            this.dstPort = termInfo.dstPort;
            this.revAutoDst = termInfo.revAutoDst;
            this.revAutoSrc = termInfo.revAutoSrc;
            this.mpo = termInfo.mpo;
        }

        public void reset() {
            this.srcPort = null;
            this.secSrcPort = null;
            this.secSrcPorts = null;
            this.revAutoSrc = false;
            this.revAutoDst = false;
            this.dstPort = null;
            this.secDstPort = null;
            this.secDstPorts = null;
            this.mpo = false;
        }

        public IEntityModel getSrcPort() {
            return this.srcPort;
        }

        public void setSrcPort(IEntityModel iEntityModel) {
            this.srcPort = iEntityModel;
        }

        public IEntityModel getSecSrcPort() {
            return this.secSrcPort;
        }

        public IEntityModel[] getSecSrcPorts() {
            return this.secSrcPorts;
        }

        public void setSecSrcPort(IEntityModel iEntityModel) {
            this.secSrcPort = iEntityModel;
        }

        public void setSecSrcPorts(IEntityModel[] iEntityModelArray) {
            this.secSrcPorts = iEntityModelArray;
        }

        public IEntityModel getDstPort() {
            return this.dstPort;
        }

        public void setDstPort(IEntityModel iEntityModel) {
            this.dstPort = iEntityModel;
        }

        public IEntityModel getSecDstPort() {
            return this.secDstPort;
        }

        public IEntityModel[] getSecDstPorts() {
            return this.secDstPorts;
        }

        public void setSecDstPort(IEntityModel iEntityModel) {
            this.secDstPort = iEntityModel;
        }

        public void setSecDstPorts(IEntityModel[] iEntityModelArray) {
            this.secDstPorts = iEntityModelArray;
        }

        public void setAutoRevSrc(boolean bl) {
            this.revAutoSrc = bl;
        }

        public void setAutoRevDst(boolean bl) {
            this.revAutoDst = bl;
        }

        public boolean isAutoRevSrc() {
            return this.revAutoSrc;
        }

        public boolean isAutoRevDst() {
            return this.revAutoDst;
        }

        public boolean isMPOConnection() {
            return this.mpo;
        }

        public void setMPOConnection(boolean bl) {
            this.mpo = bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Node: ");
            if (this.getSrcPort() != null) {
                stringBuffer.append(this.getSrcPort().getNodeModel().getName());
            } else {
                stringBuffer.append("<not initialized>");
            }
            stringBuffer.append(", src: ").append(this.getSrcPort());
            stringBuffer.append(", dst: ").append(this.getDstPort());
            if (this.getSecSrcPort() != null) {
                stringBuffer.append(", sec. src: ").append(this.getSecSrcPort());
            }
            if (this.getSecDstPort() != null) {
                stringBuffer.append(", sec. dst: ").append(this.getSecDstPort());
            }
            if (this.isMPOConnection()) {
                stringBuffer.append(", MPO");
            }
            return stringBuffer.toString();
        }
    }

    public static enum eIntPatchCordType {
        TRK2OCH,
        OTS2OTS,
        TRK2TRK,
        OCH2OCH,
        CARD2CARD;

    }

    public static enum eIntPatchPortType {
        OTS,
        OSC,
        DC,
        OCH,
        TRK,
        TRKL2,
        PSM_COM,
        PSM_WRK,
        PSM_PRT,
        NONE;

    }
}

