/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.ui.AbstractEntitySelectorAttr;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.IntPatchCreationDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.ans.AnsConnColumnRenderer;
import cerent.cms.ui.intpatch.IntPatchCreateOperator;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import cerent.cms.ui.intpatch.IntPatchHelper;
import cerent.util.SDebug;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class IntPatchcdCardPane
extends WzPane {
    private final IntPatchCreationInfo info;
    private final IntPatchCreateOperator operator;
    private IntPatchCreationInfo.TermInfo active;
    private CardSelector cardFrom;
    private CardSelector cardTo;
    private PatchCordSelector pcord;
    private HelpOnLine hol;
    private IModuleModel[] opticsModules;
    private static final SDebug db = new SDebug("IntPatchcdCardPane");

    public IntPatchcdCardPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
        this.info = ((IntPatchCreationDialog)wzDialog).getInfo();
        this.operator = ((IntPatchCreationDialog)wzDialog).getOperator();
        this.active = this.info.getActiveTerm();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.IntPatchcdCardPane;
    }

    @Override
    protected String getNextPaneName() {
        return "Internal Patchcord Card List";
    }

    @Override
    protected void initPane() {
        this.setLayout(new BorderLayout(1, 1));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBottomComponent(this.getPatchcsListPanel());
        jSplitPane.setTopComponent(this.getCardSelectionPanel());
        this.add((Component)jSplitPane, "North");
    }

    private JPanel getCardSelectionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(2, 1));
        this.cardFrom = new CardSelector("Card From Selection", true);
        this.cardTo = new CardSelector("Card To Selection", false);
        jPanel.add((Component)this.cardFrom, "West");
        jPanel.add((Component)this.cardTo, "East");
        this.opticsModules = IntPatchHelper.getOpticModules(this.info.getNode());
        this.cardFrom.loadCards(this.opticsModules, null, null);
        return jPanel;
    }

    private JPanel getPatchcsListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.info.getNodeModel();
        OpticalPatchCordModel opticalPatchCordModel = nodeModelDelegate.getOpticalPatchCordModel();
        this.pcord = new PatchCordSelector(opticalPatchCordModel, this.parent);
        this.hol = new HelpOnLine();
        jPanel.add((Component)this.pcord.getUI(), "North");
        jPanel.add((Component)this.hol.getUI(), "South");
        return jPanel;
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        this.parent.setButtonsEnabled(false, true);
        if (this.active != this.info.getActiveTerm()) {
            IntPatchCreationInfo.TermInfo termInfo = this.info.getPreviousTerm();
            this.active = this.info.getActiveTerm();
            if (this.active.getSrcPort() != null) {
                IModuleModel iModuleModel = this.active.getSrcPort().getModuleModel();
                IModuleModel iModuleModel2 = this.active.getDstPort().getModuleModel();
                this.cardFrom.loadCards(this.opticsModules, iModuleModel);
                this.cardTo.loadCards(this.opticsModules, iModuleModel2, iModuleModel);
                this.pcord.setSelected(this.active.getSrcPort(), this.active.getDstPort());
            } else if (termInfo != null && termInfo.getDstPort() != null) {
                this.cardFrom.loadCards(this.opticsModules, termInfo.getDstPort().getModuleModel());
            }
        }
    }

    @Override
    public void validatePage() throws Exception {
        IOptLinkModel iOptLinkModel = this.pcord.getSelected();
        if (iOptLinkModel == null) {
            return;
        }
        this.active.setSrcPort((IEntityModel)iOptLinkModel.getFromModel());
        this.active.setDstPort((IEntityModel)iOptLinkModel.getToModel());
        this.active.setMPOConnection(iOptLinkModel.getType() == 7);
        this.operator.createPatchcord(this.active, this.info);
        this.info.push();
    }

    @Override
    protected void handleNextException(Exception exception) {
        this.parent.handleFinishException(exception);
    }

    @Override
    public boolean handleBack() {
        boolean bl = super.handleBack();
        IntPatchCreationInfo.TermInfo termInfo = this.info.pop();
        if (termInfo != null && termInfo != this.active && termInfo.getSrcPort() != null && termInfo.getDstPort() != null) {
            try {
                this.operator.deletePatchcord(termInfo, this.info);
            }
            catch (Exception exception) {
                this.parent.handleFinishException(exception);
            }
        }
        return bl;
    }

    @Override
    public String getShortName() {
        return "#" + Integer.toString(this.info.getActiveTermIdx()) + "-" + super.getShortName();
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        IOptLinkModel iOptLinkModel = this.pcord.getSelected();
        try {
            if (iOptLinkModel != null) {
                arrayList.add(new String[]{"From: ", iOptLinkModel.getFromPortName(false)});
                arrayList.add(new String[]{"To: ", iOptLinkModel.getToPortName(false)});
                if (iOptLinkModel.getWaveLength() != 174) {
                    arrayList.add(new String[]{"Wavelength: ", iOptLinkModel.getWaveLengthString()});
                }
                if (iOptLinkModel.getType() == 7) {
                    arrayList.add(new String[]{"MPO: ", "enabled"});
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return IntPatchcdCardPane.getGridPanel(arrayList);
    }

    private GridBagConstraints getGC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 3, 0);
        gridBagConstraints.anchor = 18;
        return gridBagConstraints;
    }

    class CardSelector
    extends AbstractEntitySelectorAttr {
        private Map<Integer, Set<IModuleModel>> opticsUnitsMap;
        private Set<PassiveModuleModel> passiveUnitsSet;
        private boolean isFrom;

        CardSelector(String string, boolean bl) {
            super(IntPatchcdCardPane.this.info.getNode(), string, false, new CombosCellRenderer(), IntPatchcdCardPane.this.getGC());
            this.opticsUnitsMap = new TreeMap<Integer, Set<IModuleModel>>();
            this.passiveUnitsSet = new HashSet<PassiveModuleModel>();
            this.isFrom = bl;
        }

        IModuleModel getModule() {
            return (IModuleModel)this.slotCB.getSelectedEntity();
        }

        void loadCard(IModuleModel iModuleModel) {
            this.clearAll();
            this.updateMaps(iModuleModel);
            this.updateUI(iModuleModel, null);
        }

        void loadCards(IModuleModel[] iModuleModelArray, IModuleModel iModuleModel) {
            this.loadCards(iModuleModelArray, iModuleModel, null);
        }

        void loadCards(IModuleModel[] iModuleModelArray, IModuleModel iModuleModel, IModuleModel iModuleModel2) {
            IModuleModel iModuleModel3 = iModuleModel != null ? iModuleModel : this.getModule();
            this.clearAll();
            for (IModuleModel iModuleModel4 : iModuleModelArray) {
                if (iModuleModel4.equals(iModuleModel2)) continue;
                this.updateMaps(iModuleModel4);
            }
            this.updateUI(iModuleModel3, iModuleModel2);
        }

        void clearAll() {
            this.clearAllModels();
            this.opticsUnitsMap.clear();
            this.passiveUnitsSet.clear();
        }

        void updateUI(IModuleModel iModuleModel, IModuleModel iModuleModel2) {
            boolean bl = iModuleModel != null ? iModuleModel instanceof PassiveModuleModel : this.isPassiveCardSelected();
            this.selectorCB.restoreSelection(bl);
            if (this.passiveUnitsSet.isEmpty()) {
                this.selectorCB.removeSelection(true);
            } else if (this.opticsUnitsMap.isEmpty()) {
                this.selectorCB.removeSelection(false);
            }
            this.updateCardModels(bl);
            if (iModuleModel != null && !iModuleModel.equals(iModuleModel2)) {
                IEntityModel iEntityModel = this.slotCB.getSelectedEntity();
                if (iEntityModel != null && iEntityModel.getShelfId() != iModuleModel.getShelfId()) {
                    this.loadSelectedShelf(iModuleModel.getShelfId());
                }
                this.slotCB.setSelectedEntity((IEntityModel)iModuleModel);
            } else {
                this.slotCB.setSelectedEntity(0);
            }
        }

        void updateMaps(IModuleModel iModuleModel) {
            if (iModuleModel instanceof PassiveModuleModel) {
                this.passiveUnitsSet.add((PassiveModuleModel)iModuleModel);
            } else {
                Integer n = new Integer(iModuleModel.getShelfId());
                Set<IModuleModel> set = this.opticsUnitsMap.get(n);
                if (set == null) {
                    set = new HashSet<IModuleModel>();
                    this.opticsUnitsMap.put(n, set);
                }
                set.add(iModuleModel);
            }
        }

        @Override
        protected boolean isCardSelectorNeeded() {
            return true;
        }

        @Override
        protected boolean isMPOSelectorNeeded() {
            return false;
        }

        @Override
        protected boolean isPortSelectorNeeded() {
            return false;
        }

        @Override
        protected boolean isSideSelectorNeeded() {
            return false;
        }

        @Override
        protected void loadSelectedCard(IModuleModel iModuleModel) {
            if (iModuleModel != null) {
                if (this.isFrom) {
                    IntPatchcdCardPane.this.cardTo.loadCards(IntPatchcdCardPane.this.opticsModules, null, iModuleModel);
                } else {
                    IntPatchcdCardPane.this.pcord.loadList(IntPatchcdCardPane.this.cardFrom.getModule(), IntPatchcdCardPane.this.cardTo.getModule());
                }
            }
        }

        @Override
        protected void loadSelectedShelf(Integer n) {
            this.slotCB.clearModel();
            if (n != null) {
                this.shelfCB.setSelectedItem(n);
                Set<IModuleModel> set = this.opticsUnitsMap.get(n);
                Object[] objectArray = set.toArray(new IModuleModel[0]);
                this.slotCB.loadModel(objectArray);
            }
        }

        @Override
        protected void loadSelectedSide(String string) {
        }

        @Override
        protected void updateCardModels(boolean bl) {
            if (this.isPassiveCardSelected()) {
                this.slotCB.clearModel();
                Object[] objectArray = this.passiveUnitsSet.toArray(new PassiveModuleModel[0]);
                this.slotCB.loadModel(objectArray);
            } else {
                this.shelfCB.loadModel(this.opticsUnitsMap.keySet().toArray());
                this.loadSelectedShelf((Integer)this.shelfCB.getItemAt(0));
            }
        }
    }

    class HelpOnLine {
        private final JPanel p;
        private final JTextArea text;
        private final Font f = new Font("Arial", 1, 11);
        private static final String HELP = "Select the source and destination Card and port.\nSelect from the list the patch-cord you want to create.\nPress Finish button to commit the change or Next button to create another one.\nThe Back button Undo the last selection\nThe Cancel button cancel the whole operation (no patch-cord will be created)\nThe left side window tracks all the operation performed.";

        HelpOnLine() {
            this.p = new JPanel();
            this.text = new JTextArea();
            this.p.add(this.text);
            this.text.setEditable(false);
            this.text.setPreferredSize(new Dimension(445, 90));
            this.text.setBorder(BorderFactory.createEtchedBorder());
            this.text.setFont(this.f);
            this.updateHelp();
        }

        JPanel getUI() {
            return this.p;
        }

        void updateHelp() {
            this.text.setText(HELP);
        }
    }

    static class PatchCordDataSource
    extends AbstractRowDataSource {
        private OpticalPatchCordModel optPatchCordModel = null;
        private List<IOptLinkModel> optLinkList = new ArrayList<IOptLinkModel>();

        public PatchCordDataSource(OpticalPatchCordModel opticalPatchCordModel) {
            this.optPatchCordModel = opticalPatchCordModel;
        }

        void getOpticalLinkList(IModuleModel iModuleModel, IModuleModel iModuleModel2) {
            db.finest("From " + iModuleModel + ", To " + iModuleModel2);
            this.optLinkList.clear();
            try {
                OptLinkModel[] optLinkModelArray;
                for (OptLinkModel optLinkModel : optLinkModelArray = this.optPatchCordModel.getOptLinksBetweenCards(iModuleModel, iModuleModel2)) {
                    if (this.optLinkList.indexOf(optLinkModel) != -1) continue;
                    this.optLinkList.add(optLinkModel);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.finest("Exception in getOpticalLinkList() " + (Object)((Object)abstractCmsIOException));
            }
            catch (NoSuchEquipment noSuchEquipment) {
                db.finest("NoSuchEquipment in getOpticalLinkList() " + (Object)((Object)noSuchEquipment));
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
            this.fireDataSourceChanged();
        }

        IOptLinkModel findOpticalLink(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            int n = iEntityModel.getEntityIndex();
            int n2 = iEntityModel2.getEntityIndex();
            for (IOptLinkModel iOptLinkModel : this.optLinkList) {
                if (iOptLinkModel.getFrom() != n || iOptLinkModel.getTo() != n2) continue;
                return iOptLinkModel;
            }
            return null;
        }

        public Object getObjectAtRow(int n) {
            return this.optLinkList.get(n);
        }

        public int getRowCount() {
            return this.optLinkList.size();
        }

        public Collection getAllObjects() {
            return this.optLinkList;
        }
    }

    static class PatchCordSelector
    implements ListSelectionListener {
        private JScrollPane pane;
        private PatchCordDataSource dataSource;
        private SortableRowTableModel dataModel;
        private UTable table;
        private final WzDialog wzParent;
        static final int[] sortCols = new int[]{0, 1, 2, 3};
        static final boolean[] sortDir = new boolean[]{true, true, true, true};

        PatchCordSelector(OpticalPatchCordModel opticalPatchCordModel, WzDialog wzDialog) {
            this.wzParent = wzDialog;
            this.dataSource = new PatchCordDataSource(opticalPatchCordModel);
            this.dataModel = new SortableRowTableModel((RowDataSource)this.dataSource, AnsConnColumnRenderer.createTableRenderersWithType(), IOptLinkModel.class, sortCols, sortDir);
            this.table = new UTable((TableModel)((Object)this.dataModel));
            this.table.setSelectionMode(0);
            this.dataModel.initTable((JTable)this.table);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredSize().width, 140));
            this.pane = new JScrollPane((Component)this.table, 20, 30);
        }

        JScrollPane getUI() {
            return this.pane;
        }

        void loadList(IModuleModel iModuleModel, IModuleModel iModuleModel2) {
            this.dataSource.getOpticalLinkList(iModuleModel, iModuleModel2);
        }

        IOptLinkModel getSelected() {
            if (this.table.getSelectedRow() >= 0) {
                return (IOptLinkModel)this.dataModel.getValueAt(this.table.getSelectedRow(), 0);
            }
            return null;
        }

        void setSelected(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            IOptLinkModel iOptLinkModel = this.dataSource.findOpticalLink(iEntityModel, iEntityModel2);
            this.dataModel.setSelectedRow(iOptLinkModel);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            db.finest("valueChanged " + this.table.getSelectedRows());
            boolean bl = this.table.getSelectedRow() >= 0;
            this.wzParent.setButtonsEnabled(bl, true);
        }
    }
}

