/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2ModuleModel;
import cerent.cms.ui.ml2.CEMRLoUsageTableModel;
import cerent.cms.ui.ml2.CEMRPosPortUsagePane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.TablePrintPane;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CEMRLoMapDialog
extends TablePrintPane
implements ActionListener {
    protected static final int MARGIN = 5;
    private JButton retrieveButton;
    private JLabel retrieveLabel;
    private CEMRLoUsageTableModel tableModel;
    private ML2ModuleModel model;
    private TDMTerminology terms;
    private static DateFormat dateFormat;
    private UTable utable;
    private int stsNum;
    private static final SDebug db;

    public CEMRLoMapDialog(CEMRPosPortUsagePane cEMRPosPortUsagePane, ML2ModuleModel mL2ModuleModel, int n) {
        super("");
        this.model = mL2ModuleModel;
        this.terms = mL2ModuleModel.getNodeModel().getTDMTerminology();
        this.stsNum = n;
        this.initContentPane();
        this.customizePane();
        this.updateTitle();
        this.setSize(500, 400);
        this.setLocationRelativeTo((Component)((Object)cEMRPosPortUsagePane));
    }

    private void initContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.retrieveButton = new JButton("Retrieve");
        this.retrieveLabel = new JLabel("");
        this.retrieveButton.addActionListener(this);
        this.tableModel = new CEMRLoUsageTableModel(this.model, this.stsNum);
        this.utable = new UTable((TableModel)this.tableModel);
        this.setTable((JTable)this.utable);
        this.setAdapter(new TableModelAdapter((TableModel)this.tableModel, (JTable)this.utable));
        this.utable.setCellSelectionEnabled(true);
        this.utable.setAutoResizeMode(4);
        ((DefaultTableCellRenderer)this.utable.getDefaultRenderer(JLabel.class)).setHorizontalAlignment(2);
        UScrollPane uScrollPane = new UScrollPane((Component)this.utable);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)uScrollPane, "Center");
        jPanel.add((Component)this.retrieveButton, "West");
        jPanel.add((Component)this.retrieveLabel, "East");
        container.add((Component)jPanel, "South");
    }

    protected void customizePane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.utable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.utable.getColumn((Object)this.tableModel.getColumnName(0));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.utable.getColumn((Object)this.tableModel.getColumnName(1));
        tableColumn.setPreferredWidth(50);
        tableColumn = this.utable.getColumn((Object)this.tableModel.getColumnName(2));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.utable.getColumn((Object)this.tableModel.getColumnName(3));
        tableColumn.setPreferredWidth(150);
    }

    @Override
    public void show() {
        super.show();
        this.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.retrieveButton)) {
            this.refresh();
            if (dateFormat == null) {
                dateFormat = DateFormat.getDateTimeInstance(1, 1);
            }
            String string = "Retrieved: " + dateFormat.format(new Date());
            this.retrieveLabel.setText(string);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void refresh() {
        try {
            this.tableModel.updateTableModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void updateTitle() {
        this.setTitle(this.terms.getGeneralTerms(1) + " Map of " + this.terms.getGeneralTerms(0) + "-" + this.tableModel.getHoIndex(this.stsNum));
    }

    @Override
    public void dispose() {
        this.tableModel = null;
        super.dispose();
    }

    static {
        db = new SDebug("CEMRLoMapDialog");
    }
}

