/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.AdminState;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2EtherPortModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ml2.ML2MapGigEPortTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ML2MapGigEPortProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected ML2MapGigEPortTableModel dataModel = null;
    protected ML2ModuleModel eqpmtModel = null;
    protected ML2EtherLineModel[] lineModels = null;
    protected ML2EtherPortModel[] portModels = null;
    private static final SDebug db = new SDebug("ML2MapGigEPortProvPane");

    public ML2MapGigEPortProvPane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, tabbedView);
        this.portModels = mL2ModuleModel.getEtherPortModels();
        this.lineModels = mL2ModuleModel.getEtherLineModels();
        if (mL2ModuleModel == null || this.portModels == null || this.lineModels == null || this.portModels.length != this.lineModels.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + this.portModels + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.dataModel = new ML2MapGigEPortTableModel(mL2ModuleModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object var2_2 = null;
        Object var3_3 = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(50);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getAdminStateAttrs())));
        tableColumn.setPreferredWidth(75);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setPreferredWidth(120);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(ML2MapGigEPortTableModel.columnNames[4]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getFlowControlAttrs())));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        tableColumn.setPreferredWidth(125);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
        tableColumn.setPreferredWidth(125);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getMaxSizeAttrs())));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getWaterMarksAttrs())));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(100);
        this.table.sizeColumnsToFit(-1);
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    private JComboBox getComboBoxFor(Vector vector) {
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    private boolean preApply() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            bl = true;
        }
        if (bl || bl2) {
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl, true);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            return CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (!this.preApply()) {
            return;
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.lineModels.length; ++i) {
            if (this.dataModel.validateChanges(i)) {
                this.dataModel.applyToModel(i);
                continue;
            }
            vector.add(new Integer(this.portModels[i].getPort()));
        }
        if (vector.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (vector.size() > 1) {
                stringBuffer.append("s ");
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append((Integer)vector.get(i));
                    if (i < vector.size() - 1) {
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(" " + (Integer)vector.get(0));
            }
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_ML2_PORT_CHANGE_DISALLOWED_PARAM_2, stringBuffer, this.terms.getTermForAdminState(0));
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    @Override
    public boolean onValidate() {
        if (!this.dataModel.isWaterMarkValid()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_WATERMARK_VALUE);
            return false;
        }
        return true;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.ML2MapGigEPortProvPane;
    }
}

