/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.EtherLineModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ml2.ML2RPRSpanInfoTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ML2PosPortInfoPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    private ML2RPRSpanInfoTableModel dataModel = null;
    private EtherLineModel[] lineModels = null;
    private int numLines = 0;
    private int numPorts = 0;
    private JScrollPane scrollPane = null;
    private UTable table = null;
    private UTableHeader tableHeader = null;
    private static final SDebug db = new SDebug("ML2PosPortInfoPane");

    public ML2PosPortInfoPane(String string, TabbedView tabbedView, ML2PosPortModel[] mL2PosPortModelArray, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        this.lineModels = etherLineModelArray;
        this.numPorts = mL2PosPortModelArray == null ? 0 : mL2PosPortModelArray.length;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        ML2ModuleModel mL2ModuleModel = null;
        if (this.getParentView().getUiModel() instanceof ML2ModuleModel) {
            mL2ModuleModel = (ML2ModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not ML2ModuleModel");
        }
        this.dataModel = new ML2RPRSpanInfoTableModel(mL2ModuleModel, mL2PosPortModelArray, etherLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane);
        this.tableHeader = new UTableHeader(this.table.getColumnModel());
        this.setTable();
        this.registerForUpdates();
    }

    private void setTable() {
        TableColumn tableColumn = null;
        this.table.setModel((TableModel)this.dataModel);
        this.tableHeader.setColumnModel(this.table.getColumnModel());
        this.table.setTableHeader((JTableHeader)this.tableHeader);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn((Object)this.dataModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn((Object)this.dataModel.columnNames[4]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        this.table.sizeColumnsToFit(-1);
        this.scrollPane.setViewportView((Component)this.table);
        this.validate();
    }

    private void registerForUpdates() {
        this.registerWithModel();
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (null != this.lineModels[i]) {
                this.lineModels[i].addObserver((Observer)((Object)this));
                if (!ML2PosPortInfoPane.db.on) continue;
                db.finest("ML2PosPortInfoPane added as observer for lineModel: " + this.lineModels[i]);
                continue;
            }
            db.println("Could not add observer for line=" + i + " because the lineModel is null!");
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (ML2PosPortInfoPane.db.on) {
            db.finest("ob:" + observable + ", o:" + object);
        }
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private synchronized Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                ML2PosPortInfoPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else {
            this.dataModel.refresh();
            if (db.on()) {
                db.println("Do full refresh on table");
            }
        }
    }

    @Override
    public void destroy() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
                if (!ML2PosPortInfoPane.db.on) continue;
                db.finest("ML2PosPortInfoPane deleted as observer for lineModel: " + this.lineModels[i]);
            }
            this.lineModels = null;
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.numPorts == 0) {
            return;
        }
        if (this.dataModel.isDirty()) {
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws AnnotatedException {
        try {
            this.dataModel.applyToModel();
            this.dataModel.resetDirty();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes.", exception);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refresh();
        this.dataModel.resetDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.ML2PosPortInfoPane;
    }

    class UTableHeader
    extends JTableHeader {
        TableColumnModel columnModel;

        public UTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.columnModel = tableColumnModel;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnModel.getColumnIndexAtX(point.x);
            int n2 = this.columnModel.getColumn(n).getModelIndex();
            ML2PosPortInfoPane.this.dataModel;
            return ML2RPRSpanInfoTableModel.columnToolTips[n2];
        }

        @Override
        public void setColumnModel(TableColumnModel tableColumnModel) {
            super.setColumnModel(tableColumnModel);
            this.columnModel = tableColumnModel;
        }
    }
}

