/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.ChassisModels;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ShelfInfo;
import cerent.cms.ui.ms.NppMultishelfLayoutPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class MultishelfLayoutEditDialog
extends UDialog
implements ActionListener {
    private static String TITLE = "Edit Shelf Locations";
    private JButton okButton;
    private JButton cancelButton;
    private JSpinner[] rackSP;
    private JSpinner[] baySP;
    private ShelfInfo[] sis;
    private NppMultishelfLayoutPane pane;

    public static MultishelfLayoutEditDialog instance(NppMultishelfLayoutPane nppMultishelfLayoutPane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)nppMultishelfLayoutPane));
        return new MultishelfLayoutEditDialog(frame, nppMultishelfLayoutPane);
    }

    private MultishelfLayoutEditDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.pane = (NppMultishelfLayoutPane)object;
        this.sis = this.pane.getShelfLayoutInfo();
        jPanel.add((Component)this.createAttributesPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public ShelfInfo[] getShelfLayoutInfo() {
        ShelfInfo[] shelfInfoArray = this.sis;
        if (this.sis != null) {
            this.sis = null;
        }
        return shelfInfoArray;
    }

    public void dispose() {
        this.sis = null;
        this.pane = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.apply();
                this.dispose();
            }
            catch (InvalidData invalidData) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FAIL_MULTISHELF_LAYOUT_PARAM_1, (Object)invalidData.getMessage());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FAIL_MULTISHELF_LAYOUT_PARAM_1, (Object)provisionError.getMessage());
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FAIL_MULTISHELF_LAYOUT_PARAM_1, (Object)exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private void apply() throws Exception {
        ShelfInfo[] shelfInfoArray = new ShelfInfo[this.sis.length];
        for (int i = 0; i < this.sis.length; ++i) {
            shelfInfoArray[i] = new ShelfInfo(this.sis[i]);
            shelfInfoArray[i].setRackNum(((Number)this.rackSP[i].getValue()).shortValue());
            shelfInfoArray[i].setRackPos(((Number)this.baySP[i].getValue()).shortValue());
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.pane.getUiModel().getNodeModel();
        ChassisModels chassisModels = nodeModelDelegate.getChassisModelsInstance();
        chassisModels.setShelfInfos(shelfInfoArray);
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel(new GridLayout(this.sis.length, 3));
        this.rackSP = new JSpinner[this.sis.length];
        this.baySP = new JSpinner[this.sis.length];
        for (int i = 0; i < this.sis.length; ++i) {
            this.rackSP[i] = new JSpinner(new SpinnerNumberModel(this.sis[i].getRackNum(), 1, this.pane.chassisModels.getMaxRacks(), 1));
            this.baySP[i] = new JSpinner(new SpinnerNumberModel(this.sis[i].getRackPos(), 1, this.pane.chassisModels.getMaxRUs(), 1));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            if (this.sis[i].getShelfId() <= 30) {
                jPanel2.add(new JLabel("Shelf " + this.sis[i].getShelfId() + " (" + this.sis[i].getShelfTypeStr() + ")"));
            } else {
                jPanel2.add(new JLabel("R." + this.sis[i].getRackNum() + "/P." + this.sis[i].getRackPos() + " (" + this.sis[i].getShelfTypeStr() + ")"));
            }
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel3.add(new JLabel("Rack "));
            jPanel3.add(this.rackSP[i]);
            jPanel.add(jPanel3);
            JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel4.add(new JLabel("Position "));
            jPanel4.add(this.baySP[i]);
            jPanel.add(jPanel4);
        }
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

