/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmApcModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.ISideModel;
import cerent.cms.model.IpConfig;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecureIpConfig;
import cerent.cms.model.SideModels;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.ApcRenderer;
import cerent.cms.ui.VitalStatsPane;
import cerent.util.IObservable;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.text.DateFormat;
import java.util.Observable;
import java.util.Observer;

public class NodeVitalStatsPane
extends VitalStatsPane
implements Observer {
    private NodeModelDelegate nodeM;
    private boolean isApcSite = false;
    private IDwdmApcModel[] apcModels;
    private SideModels sideModels;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final SDebug db = new SDebug("NodeVitalStatsPane");
    private static final String emptySpaces = "            ";

    public NodeVitalStatsPane(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getElementAlarmStore());
        this.nodeM = nodeModelDelegate;
        this.isApcSite = nodeModelDelegate.getPlatform().supportsDWDM();
        if (this.isApcSite) {
            nodeModelDelegate.getDwdmApcModels().addObserver(this);
            this.apcModels = nodeModelDelegate.getDwdmApcModels().getAllDwdmApcModel();
            this.registerApcObserver();
        }
        this.sideModels = nodeModelDelegate.getSideModelsModel();
        this.sideModels.addObserver(this);
        this.registerSidesObserver();
        this.updateTextArea();
        nodeModelDelegate.addObserver(this);
    }

    private void registerSidesObserver() {
        if (this.sideModels != null) {
            ISideModel[] iSideModelArray = this.sideModels.getSides();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                ((Model)iSideModelArray[i]).addObserver(this);
            }
        }
    }

    private void registerApcObserver() {
        if (this.apcModels != null) {
            for (int i = 0; i < this.apcModels.length; ++i) {
                IDwdmApcModel iDwdmApcModel = this.apcModels[i];
                ((IObservable)iDwdmApcModel).addObserver((Observer)this);
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof IDwdmApcModel || observable instanceof IDwdmApcModels) {
            if (this.apcModels != null) {
                for (int i = 0; i < this.apcModels.length; ++i) {
                    ((IObservable)this.apcModels[i]).deleteObserver((Observer)this);
                }
            }
            this.apcModels = this.nodeM.getDwdmApcModels().getAllDwdmApcModel();
            this.registerApcObserver();
        }
        if (observable instanceof SideModels) {
            this.registerSidesObserver();
        }
        if (object == ModelUpdateType.DELETED && object instanceof IDwdmApcModel) {
            if (db.on()) {
                db.println("NodeVitalStatsPane.update(DELETED): DELETED ignored -- no operation.");
            }
            return;
        }
        this.updateTextArea();
    }

    private void updateTextArea() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string9 = "";
        String string10 = null;
        if (this.nodeM != null) {
            block30: {
                block29: {
                    block28: {
                        string = this.nodeM.getName();
                        string2 = this.getNodeIpAddr();
                        string4 = this.getIPv6Address();
                        if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode()) {
                            string3 = this.getSecureIpAddr();
                        }
                        string5 = this.nodeM.getUserName();
                        string6 = ElementDefaults.securityLevelToString(this.nodeM.getSecurityLevel());
                        try {
                            string7 = this.nodeM.getSwVersion();
                        }
                        catch (Exception exception) {
                            if (!db.isFineEnabled()) break block28;
                            db.fine("Exception received when getting node sw version");
                        }
                    }
                    try {
                        string8 = this.nodeM.getDefaultsDescription();
                    }
                    catch (Exception exception) {
                        if (!db.isFineEnabled()) break block29;
                        db.fine("Exception received when getting defaults description: " + exception);
                    }
                }
                try {
                    string10 = dateFormat.format(this.nodeM.getBootTime());
                }
                catch (Exception exception) {
                    if (!db.isFineEnabled()) break block30;
                    db.fine("Exception received when getting boot time: " + exception);
                }
            }
            if (this.isApcSite && this.nodeM.isDwdmNodeType() && this.apcModels != null) {
                boolean bl = false;
                for (Object object : this.apcModels) {
                    try {
                        if (object.getApcState() == 0) continue;
                        bl = true;
                        break;
                    }
                    catch (WrongNodeSide wrongNodeSide) {
                        if (!db.isFineEnabled()) continue;
                        db.fine("Caught " + (Object)((Object)wrongNodeSide));
                    }
                }
                for (int i = 0; i < this.apcModels.length; ++i) {
                    DwdmApcModel dwdmApcModel = (DwdmApcModel)this.apcModels[i];
                    if (!bl) continue;
                    try {
                        Object object;
                        if (i == 0) {
                            stringBuilder2.append("\nAPC state : ");
                            stringBuilder2.append("Side ");
                        } else {
                            stringBuilder2.append(emptySpaces).append("Side ");
                        }
                        int n = dwdmApcModel.getApcState();
                        object = ApcRenderer.getAPCStateAsString(n);
                        stringBuilder2.append(dwdmApcModel.getApcNodeSideString());
                        stringBuilder2.append(" - ").append((String)object).append("\n");
                        continue;
                    }
                    catch (Exception exception) {
                        if (!db.isFineEnabled()) continue;
                        db.fine("Caught " + exception);
                    }
                }
                string9 = this.createSideStr();
            }
        }
        if (string == null) {
            string = "unknown node";
        }
        if (string2 == null) {
            string2 = "unavailable";
        }
        if (string3 == null) {
            string3 = "unavailable";
        }
        if (string5 == null) {
            string5 = "unavailable";
        }
        if (string6 == null) {
            string6 = "unavailable";
        }
        if (string7 == null) {
            string7 = "unavailable";
        }
        if (string8 == null) {
            string8 = "unavailable";
        }
        if (string10 == null) {
            string10 = "unknown";
        }
        this.setTitle(string);
        if (this.nodeM.allowIpDisplayed(true)) {
            stringBuilder.append("Node Addr : ").append(string2).append('\n');
            if (null != string4) {
                stringBuilder.append("IPv6 Addr : ").append(string4).append('\n');
            }
        }
        if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode() && this.nodeM.allowIpDisplayed(false)) {
            stringBuilder.append("Backplane Node Addr   : ").append(string3).append('\n');
        }
        stringBuilder.append("Booted    : ").append(string10).append('\n').append("User      : ").append(string5).append('\n').append("Authority : ").append(string6).append('\n').append("SW Version: ").append(string7).append('\n').append("Defaults  : ").append(string8).append((CharSequence)stringBuilder2).append(string9);
        this.setText(stringBuilder.toString());
    }

    private String createSideStr() {
        ISideModel[] iSideModelArray = this.nodeM.getSideModels().getSides();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            try {
                PortModel portModel = (PortModel)this.nodeM.getEntityTableModel().getEntityModelByIndex(iSideModelArray[i].getLineIn());
                if (i > 0) {
                    stringBuffer.append(emptySpaces);
                }
                stringBuffer.append(iSideModelArray[i].getName() + " In (Shelf " + portModel.getShelfId() + " - Slot " + portModel.getSlot() + ")\n");
                portModel = (PortModel)this.nodeM.getEntityTableModel().getEntityModelByIndex(iSideModelArray[i].getLineOut());
                stringBuffer.append("              Out (Shelf " + portModel.getShelfId() + " - Slot " + portModel.getSlot() + ")\n\n");
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        if (iSideModelArray.length > 0) {
            stringBuffer.insert(0, "\nSide      : ");
        }
        return stringBuffer.toString();
    }

    private String getSecureIpAddr() {
        SecureIpConfig secureIpConfig;
        String string = null;
        if (this.nodeM != null && (secureIpConfig = (SecureIpConfig)this.nodeM.getSecureIpConfig()) != null) {
            string = InetUtil.makeDottedString(secureIpConfig.getIpAddress());
        }
        return string;
    }

    private String getNodeIpAddr() {
        String string = null;
        if (this.nodeM != null) {
            IpConfig ipConfig = (IpConfig)this.nodeM.getIpConfig();
            string = InetUtil.makeDottedString(ipConfig.getIpAddress());
        }
        return string;
    }

    private String getIPv6Address() {
        IpConfig ipConfig;
        String string = null;
        if (this.nodeM != null && (ipConfig = (IpConfig)this.nodeM.getIpConfig()).getNodeMode()) {
            string = InetUtil.makeDottedString(ipConfig.getIpv6Address());
        }
        return string;
    }

    @Override
    public void dispose() {
        this.nodeM.deleteObserver(this);
        if (this.isApcSite) {
            this.nodeM.getDwdmApcModels().deleteObserver(this);
            if (this.apcModels != null) {
                for (int i = 0; i < this.apcModels.length; ++i) {
                    ((IObservable)this.apcModels[i]).deleteObserver((Observer)this);
                }
            }
        }
        if (this.sideModels != null) {
            this.sideModels.deleteObserver(this);
            ISideModel[] iSideModelArray = this.sideModels.getSides();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                ((Model)iSideModelArray[i]).deleteObserver(this);
            }
        }
        super.dispose();
    }
}

