/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.ChassisPolicy;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.PassiveUnitPolicy;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.Map;

public class ShelfBehavior {
    public static final String DELETE_SHELF = "Delete Shelf";
    public static final String DELETE_UNIT = "Delete Unit";
    public static final String UPGRADE_UNIT = "Upgrade To";
    public static final String OPEN_SHELF = "Open Shelf";
    public static final String ADD_SHELF = "Add Shelf";
    public static final String ADD_UNIT = "Add Unit";
    public static final String UNDELETE_SHELF = "Undelete Shelf";
    private final NodeModelDelegate nmd;
    private final ChassisModels cms;
    private final EntityTableModel etm;
    protected final SDebug db;

    public ShelfBehavior(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.nmd = nodeModelDelegate;
        this.cms = nodeModelDelegate.getChassisModelsInstance();
        this.etm = nodeModelDelegate.getEntityTableModel();
        this.db = sDebug;
    }

    public Map<String, Object> getProvisionableShelves(short s) {
        return ChassisPolicy.getMapOfValidChassis(this.cms, s);
    }

    public Map<String, Object> getProvisionableShelves(short s, short s2) {
        return this.cms.getMapOfValidChassis(s, s2);
    }

    public String getShelfName(eEqType eEqType2) {
        return EntityModel.eqType2Name(this.nmd.getTDMTerminology(), eEqType2);
    }

    public Integer[] getAvailableShelfIds(String string) {
        if (PassiveUnitPolicy.isPassiveUnit(string)) {
            return new Integer[]{0};
        }
        return this.cms.getAvailableShelfIds(EntityModel.name2EqType(this.nmd, string));
    }

    public Integer[] getAvailableSlots(String string) {
        int n;
        if (PassiveUnitPolicy.isPassiveUnit(string) && (n = PassiveUnitPolicy.getNumberOfSlots(string)) > 1) {
            Integer[] integerArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                integerArray[i] = new Integer(i + 1);
            }
            return integerArray;
        }
        return new Integer[0];
    }

    public Integer[] getShelfSizes(String string, short n) {
        short s = 0;
        if (PassiveUnitPolicy.isPassiveUnit(string)) {
            s = PassiveUnitPolicy.getRUOccupied(this.nmd, string);
            if (s == 0) {
                Integer[] integerArray = new Integer[n];
                for (int i = 0; i < n; ++i) {
                    integerArray[i] = new Integer(i + 1);
                }
                return integerArray;
            }
        } else {
            eEqType eEqType2 = EntityModel.name2EqType(this.nmd, string);
            s = ChassisPolicy.getChassisHeight(eEqType2);
        }
        return new Integer[]{s};
    }

    public void addShelf(final Component component, final short s, final short s2, final short s3, final short s4, final short s5, final String string) {
        new Thread("Shelf Provisioner"){

            @Override
            public void run() {
                try {
                    if (PassiveUnitPolicy.isPassiveUnit(string)) {
                        eEqType eEqType2 = PassiveUnitPolicy.getEqType(string);
                        short s6 = (short)PassiveUnitPolicy.getNumberOfSlots(string);
                        short s22 = (short)PassiveUnitPolicy.getSlotsOccupied(string);
                        PassiveModuleModel.provisionPassiveModule(ShelfBehavior.this.etm, 0, eEqType2, string, s2, s3, false, s4, s6, s5, s22);
                    } else {
                        eEqType eEqType3 = EntityModel.name2EqType(ShelfBehavior.this.nmd, string);
                        ShelfBehavior.this.cms.provisionShelf(s, s2, s3, s4, s5, (short)1, eEqType3);
                    }
                }
                catch (InvalidData invalidData) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)invalidData);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)("shelf ID " + s + " is invalid."));
                }
                catch (ProvisionError provisionError) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)provisionError);
                    }
                    ErrorMsg.displayError((Component)component, (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
                }
                catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)"the equipment does not support multishelf.");
                }
                catch (ResourceInUse resourceInUse) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)resourceInUse);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)"the resource is in use.");
                }
                catch (Exception exception) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)"Unknown Error.");
                }
            }
        }.start();
    }

    public void unDeleteShelf(Component component, IShelfViewModel iShelfViewModel) {
        this.addShelf(component, (short)iShelfViewModel.getShelfId(), iShelfViewModel.getRackNumber(), iShelfViewModel.getRackPosition(), iShelfViewModel.getRUOccupied(), (short)0, iShelfViewModel.getShelfTypeName());
    }

    public boolean deleteShelf(Component component, IShelfViewModel iShelfViewModel) {
        boolean bl = false;
        if (iShelfViewModel.getShelfId() == 1) {
            bl = false;
            ErrorMsg.displayError((Component)component, (EID)EMC.NOT_DELETE_NC);
            return bl;
        }
        if (CerentDialog.yesNoDialog((Component)component, (String)"Are you sure?", (String)"Deleting Shelf")) {
            try {
                bl = false;
                iShelfViewModel.unprovision();
                bl = true;
            }
            catch (ResourceInUse resourceInUse) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("it is in use.");
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_DELETE_PARAM_1, (Object)stringBuffer.toString());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_DELETE_PARAM_1, (Object)"provision error");
            }
        }
        return bl;
    }

    public void addUnit(Component component, short s, short s2, short s3, short s4, String string) {
        this.addShelf(component, (short)0, s, s2, s4, s3, string);
    }

    public void upgradeUnit(final Component component, final IEntityModel iEntityModel, final String string) {
        if (CerentDialog.yesNoWarningDialog((Component)component, (String)"This Operation is Causing Reset of Node\nIt is reccomended to backup you Node before doing this operation\nDo you want to continue?", (String)"Passive Unit Upgrade", (int)1)) {
            new Thread("Passive Unit Updater"){

                @Override
                public void run() {
                    try {
                        eEqType eEqType2 = EntityModel.name2EqType(ShelfBehavior.this.nmd, string);
                        ((PassiveModuleModel)iEntityModel).upgrade(eEqType2);
                    }
                    catch (ProvisionError provisionError) {
                        if (ShelfBehavior.this.db.on()) {
                            SDebug.printStackTrace((Throwable)provisionError);
                        }
                        ErrorMsg.displayError((Component)component, (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
                    }
                    catch (Exception exception) {
                        if (ShelfBehavior.this.db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        ErrorMsg.displayError((Component)component, (EID)EMC.EID_GENERIC_PROV_ERROR);
                    }
                }
            }.start();
        }
    }
}

