/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.idl.Optics.sAlarmThresholds;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.OpticalThresholdTableModel;
import cerent.util.SDebug;

public class MuxDmuxOpticalThresholdTableModel
extends OpticalThresholdTableModel {
    public static final int ADD_POWER_FAILURE_LOW_INDEX = 11;
    public static final int GAIN_DEGRADE_LOW_INDEX = 12;
    public static final int GAIN_DEGRADE_HIGH_INDEX = 13;
    public static final String[] columnNames = new String[]{"Power ADD Failure Low (dBm)", "Gain Degrade Low (dBm)", "Gain Degrade High (dBm)"};
    private sAlarmThresholds[] AddAlmThresholdsVal;
    private String[] AddPowerFailureL;
    private static final SDebug db = new SDebug("MuxDmuxOpticalThresholdTableModel");

    public MuxDmuxOpticalThresholdTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n) {
        super(abstractOpticsLineModelArray, n);
        this.AddAlmThresholdsVal = new sAlarmThresholds[this.numLines];
        this.AddPowerFailureL = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.AddAlmThresholdsVal[i] = null;
            this.AddPowerFailureL[i] = null;
        }
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        bl = super.isCellEditable(n, n2);
        if (191 == this.eqpmtModel.getEqType() || 263 == this.eqpmtModel.getEqType() || 267 == this.eqpmtModel.getEqType() || 242 == this.eqpmtModel.getEqType()) {
            if (this.model[0] != null && this.model[0] instanceof OpticsChannelModel) {
                if (n2 == 11 && this.AddPowerFailureL[n].compareTo("N/A") != 0) {
                    bl = true;
                }
                if (n2 == 3) {
                    bl = false;
                }
            }
        } else if (n2 == 11 && this.AddPowerFailureL[n].compareTo("N/A") != 0) {
            bl = true;
        }
        if ((131 == this.eqpmtModel.getEqType() || 132 == this.eqpmtModel.getEqType()) && n2 == 3 && this.model[n] instanceof OpticsChannelModel) {
            bl = false;
        }
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        if (n < 11) {
            return super.getColumnName(n);
        }
        return columnNames[n - 11];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 12: {
                    return this.getGainDegradeL(n);
                }
                case 13: {
                    return this.getGainDegradeH(n);
                }
                case 11: {
                    return this.getAddFailureLow(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("MuxDmuxOpticalThresholdTableModel: error in getValueAt" + exception);
            }
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 11: {
                    String string = (String)object;
                    this.AddPowerFailureL[n] = (String)object;
                    if (MuxDmuxOpticalThresholdTableModel.isValidNumber(string, "Add Power failure Low")) {
                        int n3 = MuxDmuxOpticalThresholdTableModel.ValPerTen(string);
                        if (this.AddAlmThresholdsVal[n] != null) {
                            this.AddAlmThresholdsVal[n].fail.low = n3;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.AddPowerFailureL[n] = null;
                    this.getAddFailureLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                default: {
                    super.setValueAt(object, n, n2);
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    protected String getAddFailureLow(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.AddPowerFailureL[n] == null) {
            this.Flg_FeatureUnsupported[n][11] = true;
            try {
                int n2 = this.model[n].getAddPTThresholdFailLow();
                if (n2 != -1000000) {
                    this.AddPowerFailureL[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][11] = false;
                } else {
                    this.AddPowerFailureL[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.AddPowerFailureL[n] = "N/A";
            }
        }
        return this.AddPowerFailureL[n];
    }

    protected String getGainDegradeL(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.GAIN, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.LOWIDX);
            if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    protected String getGainDegradeH(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.GAIN, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.HIGHIDX);
            if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    @Override
    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.AddAlmThresholdsVal[n] = null;
        this.AddPowerFailureL[n] = null;
    }

    @Override
    protected void refreshAdditionalAlarmTh(int n) {
        block5: {
            try {
                if (this.AddAlmThresholdsVal[n] == null && (this.model[n].getFeatures() & 0x10) == 16) {
                    this.AddAlmThresholdsVal[n] = this.model[n].getAddPTThresholds();
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (MuxDmuxOpticalThresholdTableModel.db.on) {
                    db.fine("Caught " + (Object)((Object)noSuchInterface) + " in refreshAdditionalAlarmTh");
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!MuxDmuxOpticalThresholdTableModel.db.on) break block5;
                db.fine("Caught " + (Object)((Object)wrongInterfaceType) + " in refreshAdditionalAlarmTh");
            }
        }
    }

    @Override
    protected void applyAdditionalAlarmTh(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError {
        this.model[n].setAddPTThresholds(this.AddAlmThresholdsVal[n]);
    }
}

