/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.muxdemux.MuxDmuxOCHPmPane;
import cerent.cms.ui.muxdemux.MuxDmuxOTSPmPane;
import cerent.cms.ui.oadm.OadmOMSPmPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class MuxDmuxPerfPane
extends AbstractPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    private OpticsModuleModel model;
    private OpticsChannelModel[] chModels;
    private OpticsMultiplexSectionModel[] omsModels;
    private OpticsLineModel[] otsModels;
    private static final SDebug db = new SDebug("MuxDmuxPerfPane");

    public MuxDmuxPerfPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        this.eqpmtModel = moduleModel;
        this.model = (OpticsModuleModel)this.getUiModel();
        this.chModels = this.model.getOpticsChannelModels();
        this.omsModels = this.model.getOpticsOMSModels();
        this.otsModels = this.model.getOpticsLineModels();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.model.getNodeModel();
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        this.subTabs.addTab("Optical Chn", (Component)this.getOptOchPMTab(this.chModels));
        if (133 == moduleModel.getEqType()) {
            this.subTabs.addTab("Optical Band", (Component)this.getOptOmsPMTab(this.omsModels));
        } else {
            this.subTabs.addTab("Optical Line", (Component)this.getOptOtsPMTab(this.otsModels));
        }
        this.subTabs.setTabPlacement(2);
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected Pane getPmOtsTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new MuxDmuxOtsPmPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getPmOchTabs(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
        return new MuxDmuxOchPmPane(tabbedView, opticsChannelModelArray);
    }

    protected Pane getPmOmsTabs(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new MuxDmuxOmsPmPane(tabbedView, opticsMultiplexSectionModelArray);
    }

    protected Pane getOptOtsPMTab(OpticsLineModel[] opticsLineModelArray) {
        return new MuxDmuxOTSPmPane("Optics PM", this.getParentView());
    }

    protected Pane getOptOchPMTab(OpticsChannelModel[] opticsChannelModelArray) {
        return new MuxDmuxOCHPmPane("Optics PM", this.getParentView());
    }

    protected Pane getOptOmsPMTab(OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new OadmOMSPmPane("Optics PM", this.getParentView());
    }

    public boolean hasSubTabs() {
        return true;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public void leavingPage() throws Exception {
    }

    private class MuxDmuxOchPmPane
    extends AbstractPane {
        public MuxDmuxOchPmPane(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
            super("MuxDmuxOCHPmPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Optics PM", (Component)MuxDmuxPerfPane.this.getOptOchPMTab(opticsChannelModelArray));
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }

        @Override
        public void refresh() {
        }

        @Override
        public void enteringPage() throws Exception {
        }

        @Override
        public void leavingPage() throws Exception {
        }
    }

    private class MuxDmuxOmsPmPane
    extends AbstractPane {
        public MuxDmuxOmsPmPane(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
            super("MuxDmuxOMSPmPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Optics PM", (Component)MuxDmuxPerfPane.this.getOptOmsPMTab(opticsMultiplexSectionModelArray));
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }

        @Override
        public void refresh() {
        }

        @Override
        public void enteringPage() throws Exception {
        }

        @Override
        public void leavingPage() throws Exception {
        }
    }

    private class MuxDmuxOtsPmPane
    extends AbstractPane {
        public MuxDmuxOtsPmPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("MuxDmuxOTSPmPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Optics PM", (Component)MuxDmuxPerfPane.this.getOptOtsPMTab(opticsLineModelArray));
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }

        @Override
        public void refresh() {
        }

        @Override
        public void enteringPage() throws Exception {
        }

        @Override
        public void leavingPage() throws Exception {
        }
    }
}

