/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractNodeSetupPreDialog
extends JDialog
implements ActionListener {
    private static final String VIGNETTE = "/images/CTC_dialogVignette.gif";
    private static final String NEXT = "Next>";
    private static final String CANCEL = "Cancel";
    private JButton nextButton;
    private JButton cancelButton;
    private boolean cancelled = false;
    protected final Frame parent;
    protected final boolean makeModal;
    protected final NsdWizardInfo wizardInfo;
    protected final SDebug dbg;

    public AbstractNodeSetupPreDialog(Frame frame, boolean bl, String string, NsdWizardInfo nsdWizardInfo, SDebug sDebug) {
        super(frame, string + nsdWizardInfo.getNodeName(), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractNodeSetupPreDialog.this.cancelled = true;
                AbstractNodeSetupPreDialog.this.dispose();
            }
        });
        this.parent = frame;
        this.makeModal = bl;
        this.wizardInfo = nsdWizardInfo;
        this.dbg = sDebug;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getBottomPane(), "South");
        container.add((Component)this.getUpperPane(), "Center");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.dbg.info("AbstractNodeSetupPreDialog() initialized");
    }

    protected abstract JPanel getRightPane();

    private final JPanel getLeftPane() {
        this.dbg.info("Entered AbstractNodeSetupPreDialog.getLeftPane()");
        JPanel jPanel = new JPanel();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(VIGNETTE));
        jPanel.add(new JLabel(imageIcon));
        return jPanel;
    }

    private final JPanel getUpperPane() {
        this.dbg.info("Entered AbstractNodeSetupPreDialog.getUpperPane()");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getLeftPane(), "West");
        jPanel.add((Component)this.getRightPane(), "Center");
        return jPanel;
    }

    private final JPanel getBottomPane() {
        this.dbg.info("Entered AbstractNodeSetupPreDialog.getBottomPane()");
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.nextButton = new JButton(NEXT);
        this.cancelButton = new JButton(CANCEL);
        jPanel.add(this.nextButton);
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConst.NodeSetupWizard));
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.cancelButton.addActionListener(this);
        return jPanel;
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nextButton) {
            this.dbg.info("AbstractNodeSetupPreDialog.handleNext()");
            this.handleNext();
        } else if (object == this.cancelButton && this.handleCancel()) {
            this.cancelled = true;
            this.dispose();
        }
    }

    protected abstract void handleNext();

    protected boolean handleCancel() {
        return true;
    }

    protected final void setNextEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void dispose() {
        this.dbg.info("AbstractNodeSetupPreDialog.dispose()");
        super.dispose();
    }
}

