/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Vector;

public class AnsManager
extends WzTask {
    public AnsManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
    }

    @Override
    public synchronized void doTask() {
        this.setWorking();
        this.wzInfo.logInfo(">> Starting ANS Parameters import...\n");
        this.importAnsParams();
        this.setCompleted();
    }

    private String importAnsParams() {
        Vector<NsdWizardInfo.AnsParamStructure> vector = this.wzInfo.getAnsParameters();
        ANSManager aNSManager = this.node.getANSManager();
        ArrayList<ANSElement> arrayList = new ArrayList<ANSElement>();
        for (NsdWizardInfo.AnsParamStructure object : vector) {
            this.wzInfo.logInfo(">> Parsing ANS parameter " + object + "\n");
            ANSElement aNSElement = null;
            int n = 0;
            if (object.port != null) {
                PortModel portModel = this.getPortModel(object.shelf, object.slot, null, object.port);
                if (portModel == null) continue;
                n = portModel.getEntityIndex();
            }
            int n2 = 174;
            if (object.wavelength != null) {
                try {
                    n2 = this.convertWl(object.wavelength).value();
                }
                catch (Exception exception) {
                    this.wzInfo.logError(">> " + object.wavelength + " wrong wavelength data" + "\n");
                    continue;
                }
            }
            try {
                aNSElement = aNSManager.makeElementWithInfo(object.paramName, n, n2, object.paramValue);
            }
            catch (ProvisionError provisionError) {
                this.wzInfo.logError(">> Error " + provisionError.getMessage() + "\n");
                continue;
            }
            arrayList.add(aNSElement);
        }
        try {
            for (ANSElement aNSElement : arrayList) {
                this.wzInfo.logInfo(">> Importing " + aNSElement.getFullName() + " with value = " + aNSElement.getANSValue().getValue() + "\n");
                aNSManager.importParameter(aNSElement.getKey(), aNSElement.getANSValue().getIntValue());
                this.wzInfo.logSuccess(">> Done...\n");
            }
            this.node.getANSManager().getNeANSModel().updateLocalStructure();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            this.wzInfo.logError(">> Exception: cannot load ans parameters section\n");
        }
        return null;
    }
}

