/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.PassiveChassisModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdcuModuleModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class NodeInfo {
    private Document xmldoc = null;
    private static final SDebug db = new SDebug("NodeInfo");

    private Element createPassiveElement(PassiveModuleModel passiveModuleModel, PassiveChassisModel passiveChassisModel) {
        Element element = this.xmldoc.createElementNS(null, "slot");
        element.setAttributeNS(null, "pos", "" + passiveModuleModel.getSlotPosition());
        element.setAttributeNS(null, "occupancy", "" + passiveChassisModel.getRUOccupied());
        Element element2 = this.xmldoc.createElementNS(null, "eqtype");
        Element element3 = this.xmldoc.createElementNS(null, "description");
        Element element4 = this.xmldoc.createElementNS(null, "unit_id");
        Text text = this.xmldoc.createTextNode(EqTypeHelper.eqTypeToName((TDMTerminology)passiveModuleModel.getNodeModel().getTDMTerminology(), (int)passiveModuleModel.getEqType()));
        String string = passiveModuleModel.getEqTypeName();
        if (string.equalsIgnoreCase("FIBER STORAGE")) {
            string = "FIBERSTORAGE SHELF";
        }
        Text text2 = this.xmldoc.createTextNode(string);
        Text text3 = this.xmldoc.createTextNode("" + passiveModuleModel.getID());
        element2.appendChild(text);
        element3.appendChild(text2);
        element4.appendChild(text3);
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        return element;
    }

    private String[] getMpNamefromCTCName(String string) {
        String string2 = null;
        int n = 0;
        if (string.equals("Network Type")) {
            string2 = "NetworkType";
        } else if (string.equals("WXC Dithering")) {
            string2 = "Dithering";
        } else if (string.equals("Min Expected Span Loss")) {
            string2 = "MinExpSpanLoss";
            n = 1;
        } else if (string.equals("Max Expected Span Loss")) {
            string2 = "MaxExpSpanLoss";
            n = 2;
        } else if (string.equals("Amplifier Working Mode")) {
            string2 = "WkgMode";
            n = 3;
        } else if (string.equals("Power")) {
            string2 = "ChPwr";
            n = 6;
        } else if (string.equals("Amplifier Gain")) {
            string2 = "Gain";
            n = 4;
        } else if (string.equals("Amplifier Tilt")) {
            string2 = "Tilt";
            n = 5;
        } else if (string.equals("OSC LOS Threshold")) {
            string2 = "OscLossTh";
            n = 9;
        } else if (string.equals("OSC Power")) {
            string2 = "OscPower";
            n = 8;
        } else if (string.equals("Channel LOS Threshold")) {
            string2 = "ChLossTh";
            n = 7;
        } else if (string.equals("VOA Attenuation")) {
            string2 = "VoaAttenuation";
            n = 10;
        } else if (string.equals("Raman Ratio")) {
            string2 = "Ratio";
            n = 11;
        } else if (string.equals("Raman Total Power")) {
            string2 = "RamanTotalPower";
            n = 12;
        }
        String[] stringArray = new String[]{string2, "" + n};
        return stringArray;
    }

    private Element createElementwithAttribute(String string, String string2) {
        Element element = this.xmldoc.createElementNS(null, string);
        element.setAttributeNS(null, "value", string2);
        return element;
    }

    private Element getANSParameters(NodeModelDelegate nodeModelDelegate) {
        Element element;
        block12: {
            element = this.xmldoc.createElementNS(null, "ans");
            HashMap<Integer, Element> hashMap = new HashMap<Integer, Element>();
            ANSNode aNSNode = null;
            ANSManager aNSManager = ANSManager.getInstance(nodeModelDelegate);
            try {
                int n;
                aNSNode = aNSManager.getAnsParametersTree();
                ANSNode[] aNSNodeArray = aNSNode.getChildren();
                Element[] elementArray = new Element[aNSNodeArray.length];
                int n2 = 0;
                for (n = 0; n < aNSNodeArray.length; ++n) {
                    Object object;
                    int n3;
                    Object object2;
                    String string = this.getMpNamefromCTCName(aNSNodeArray[n].getName())[0];
                    if (string != null) {
                        object2 = this.xmldoc.createElementNS(null, "node_parameter");
                        for (n3 = 0; n3 < aNSNodeArray[n].getChildren().length; ++n3) {
                            if (!(aNSNodeArray[n].getChildren()[n3] instanceof ANSElement)) continue;
                            object = (ANSElement)aNSNodeArray[n].getChildren()[n3];
                            Element element2 = this.createElementwithAttribute(string, ((ANSElement)object).getANSValue().getValue());
                            object2.appendChild(element2);
                        }
                        elementArray[n2++] = object2;
                        continue;
                    }
                    object2 = aNSNodeArray[n].getChildren();
                    for (n3 = 0; n3 < ((ANSNode[])object2).length; ++n3) {
                        object = object2[n3].getChildren();
                        for (int i = 0; i < ((ANSNode[])object).length; ++i) {
                            Element element3 = this.xmldoc.createElementNS(null, "port_parameter");
                            hashMap.clear();
                            ANSNode[] aNSNodeArray2 = object[i].getChildren();
                            for (int j = 0; j < aNSNodeArray2.length; ++j) {
                                Element element4;
                                Object object3;
                                Object object4;
                                ANSNode aNSNode2 = aNSNodeArray2[j];
                                while (!(aNSNode2 instanceof ANSElement)) {
                                    aNSNode2 = aNSNode2.getChildren()[0];
                                }
                                if (j == 0) {
                                    int n4 = ((ANSElement)aNSNode2).getKey().paramLocation;
                                    object4 = (PortModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n4);
                                    object3 = this.xmldoc.createElementNS(null, "shelf_position");
                                    Text text = this.xmldoc.createTextNode("" + ((EntityModel)object4).getShelfId());
                                    object3.appendChild(text);
                                    element4 = this.xmldoc.createElementNS(null, "slot_position");
                                    Text text2 = this.xmldoc.createTextNode("" + ((EntityModel)object4).getSlot());
                                    element4.appendChild(text2);
                                    Element element5 = this.xmldoc.createElementNS(null, "port_position");
                                    Text text3 = this.xmldoc.createTextNode("" + ((PortModel)object4).getPortNum()[0]);
                                    element5.appendChild(text3);
                                    element3.appendChild((Node)object3);
                                    element3.appendChild(element4);
                                    element3.appendChild(element5);
                                }
                                ANSElement aNSElement = (ANSElement)aNSNode2;
                                object4 = this.getMpNamefromCTCName(aNSElement.getName())[0];
                                object3 = aNSElement.getANSValue().getValue();
                                int n5 = Integer.parseInt(this.getMpNamefromCTCName(aNSElement.getName())[1]);
                                element4 = this.createElementwithAttribute((String)object4, (String)object3);
                                hashMap.put(n5, element4);
                            }
                            Iterator iterator = hashMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                int n6 = (Integer)iterator.next();
                                element3.appendChild((Node)hashMap.get(n6));
                            }
                            element.appendChild(element3);
                        }
                    }
                }
                for (n = 0; n < elementArray.length; ++n) {
                    element.appendChild(elementArray[n]);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block12;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return element;
    }

    private int getNumberOfSlots(String string) {
        int n = 0;
        if (string.contains("M6")) {
            n = 8;
        } else if (string.contains("M2")) {
            n = 3;
        } else if (string.contains("SDH") || string.contains("454")) {
            n = 17;
        }
        return n;
    }

    private String getOtu2xpMode(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Transponder";
                break;
            }
            case 1: {
                string = "Standard Regen";
                break;
            }
            case 2: {
                string = "Enhanced FEC";
                break;
            }
            case 3: {
                string = "Mixed";
                break;
            }
            case 4: {
                string = "LAN-WAN";
                break;
            }
            case 5: {
                string = "Splitter";
                break;
            }
            case 6: {
                string = "LAN-WAN Splitter";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private String getCardModeFromInt(eCardOperMode eCardOperMode2) {
        String string = null;
        switch (eCardOperMode2.value()) {
            case 1: {
                string = "MXPMR25G_FCGE";
                break;
            }
            case 3: {
                string = "MXPMR25G_ESCON";
                break;
            }
            case 2: {
                string = "MXPMR25G_MIXED";
                break;
            }
            case 16: {
                string = "MXPMR10DME_PG1_4GFC_PG2_4GFC";
                break;
            }
            case 15: {
                string = "MXPMR10DME_PG1_4GFC_PG2_FCGEISC";
                break;
            }
            case 14: {
                string = "MXPMR10DME_PG1_FCGEISC_PG2_4GFC";
                break;
            }
            case 13: {
                string = "MXPMR10DME_PG1_FCGEISC_PG2_FCGEISC";
                break;
            }
            case 18: {
                string = "GEXP_MXP";
                break;
            }
            case 19: {
                string = "GEXP_2MXP";
                break;
            }
            case 20: {
                string = "GEXP_MXP_L2_SWITCH";
                break;
            }
            case 21: {
                string = "10GEXP_TXP";
                break;
            }
            case 22: {
                string = "10GEXP_TXP_L2_SWITCH";
                break;
            }
            case 30: {
                string = "BIDIRECTIONAL";
                break;
            }
            case 32: {
                string = "DE-MULTIPLEXER";
                break;
            }
            case 31: {
                string = "MULTIPLEXER";
            }
        }
        return string;
    }

    private Element[] patchcordFromArray(IPortModel iPortModel) {
        Object object;
        Element[] elementArray = new Element[3];
        Element element = this.xmldoc.createElementNS(null, "from_unit");
        Element element2 = this.xmldoc.createElementNS(null, "from_shelf");
        Element element3 = this.xmldoc.createElementNS(null, "from_slot");
        Element element4 = this.xmldoc.createElementNS(null, "from_port");
        if (iPortModel.getModuleModel() instanceof PassiveModuleModel) {
            object = (PassiveModuleModel)iPortModel.getModuleModel();
            Text text = this.xmldoc.createTextNode("" + ((PassiveModuleModel)object).getID());
            element.appendChild(text);
            elementArray[0] = element;
            elementArray[1] = null;
        } else {
            object = this.xmldoc.createTextNode("" + iPortModel.getShelfId());
            Text text = this.xmldoc.createTextNode("" + iPortModel.getSlot());
            element2.appendChild((Node)object);
            element3.appendChild(text);
            elementArray[0] = element2;
            elementArray[1] = element3;
        }
        object = this.xmldoc.createTextNode("" + iPortModel.getPortNum()[0]);
        element4.appendChild((Node)object);
        elementArray[2] = element4;
        return elementArray;
    }

    private Element[] patchcordToArray(IPortModel iPortModel) {
        Object object;
        Element[] elementArray = new Element[3];
        Element element = this.xmldoc.createElementNS(null, "to_shelf");
        Element element2 = this.xmldoc.createElementNS(null, "to_slot");
        Element element3 = this.xmldoc.createElementNS(null, "to_unit");
        Element element4 = this.xmldoc.createElementNS(null, "to_port");
        if (iPortModel.getModuleModel() instanceof PassiveModuleModel) {
            object = (PassiveModuleModel)iPortModel.getModuleModel();
            Text text = this.xmldoc.createTextNode("" + ((PassiveModuleModel)object).getID());
            element3.appendChild(text);
            elementArray[0] = null;
            elementArray[1] = element3;
        } else {
            object = this.xmldoc.createTextNode("" + iPortModel.getShelfId());
            Text text = this.xmldoc.createTextNode("" + iPortModel.getSlot());
            element.appendChild((Node)object);
            element2.appendChild(text);
            elementArray[0] = element;
            elementArray[1] = element2;
        }
        object = this.xmldoc.createTextNode("" + iPortModel.getPortNum()[0]);
        element4.appendChild((Node)object);
        elementArray[2] = element4;
        return elementArray;
    }

    private void addParameters(Element element, Node node, Node node2, Node node3, Node node4, Node node5, Node node6) {
        Element element2 = this.xmldoc.createElementNS(null, "parameter");
        Element element3 = this.xmldoc.createElementNS(null, "shelf_position");
        Element element4 = this.xmldoc.createElementNS(null, "slot_position");
        Element element5 = this.xmldoc.createElementNS(null, "port_position");
        Element element6 = this.xmldoc.createElementNS(null, "ppm_position");
        Element element7 = this.xmldoc.createElementNS(null, "name");
        Element element8 = this.xmldoc.createElementNS(null, "value");
        Element element9 = this.xmldoc.createElementNS(null, "unit_id");
        if (node != null) {
            element3.appendChild(node);
            element2.appendChild(element3);
        }
        if (node2 != null) {
            element4.appendChild(node2);
            element2.appendChild(element4);
        }
        if (node4 != null) {
            element5.appendChild(node4);
            element2.appendChild(element5);
        }
        if (node3 != null) {
            element9.appendChild(node3);
            element2.appendChild(element9);
        }
        element7.appendChild(node5);
        element8.appendChild(node6);
        element2.appendChild(element6);
        element2.appendChild(element7);
        element2.appendChild(element8);
        element.appendChild(element2);
    }

    private void appendParameter(Element element, ModuleModel moduleModel, String string, String string2, String string3) {
        Text text = this.xmldoc.createTextNode("" + moduleModel.getShelfId());
        Text text2 = this.xmldoc.createTextNode("" + moduleModel.getSlot());
        Text text3 = this.xmldoc.createTextNode(string2);
        Text text4 = this.xmldoc.createTextNode(string3);
        if (string == null) {
            this.addParameters(element, text, text2, null, null, text3, text4);
        } else {
            Text text5 = this.xmldoc.createTextNode(string);
            this.addParameters(element, text, text2, null, text5, text3, text4);
        }
    }

    private void getParameters(ModuleModel moduleModel, Element element) {
        block85: {
            Object object;
            Object object2;
            block84: {
                Object object3;
                Object object4;
                block82: {
                    Object object5;
                    String string;
                    block77: {
                        if (moduleModel instanceof OpticsModuleModel && (object2 = ((OpticsModuleModel)moduleModel).getOpticsAmplifiedLineModels()) != null && ((InterfaceModel[])object2).length > 0) {
                            try {
                                object = this.xmldoc.createTextNode("" + moduleModel.getShelfId());
                                object4 = this.xmldoc.createTextNode("" + moduleModel.getSlot());
                                object3 = this.xmldoc.createTextNode("OPT_AMP");
                                string = null;
                                if (((OpticsModuleModel)moduleModel).getAmpliRole().equals(eOpticalAmplifierRole.PRE_AMPLI)) {
                                    string = "PRE_AMPLI";
                                } else if (((OpticsModuleModel)moduleModel).getAmpliRole().equals(eOpticalAmplifierRole.BST_AMPLI)) {
                                    string = "BST_AMPLI";
                                }
                                if (string != null && !moduleModel.getEqTypeEnum().equals(eEqType.OPT_PRE) && moduleModel.getEqTypeName().contains("OPT")) {
                                    object5 = this.xmldoc.createTextNode(string);
                                    this.addParameters(element, (Node)object, (Node)object4, null, null, (Node)object3, (Node)object5);
                                }
                            }
                            catch (NoSuchInterface noSuchInterface) {
                                if (db.on()) {
                                    SDebug.printStackTrace((Throwable)noSuchInterface);
                                }
                            }
                            catch (WrongInterfaceType wrongInterfaceType) {
                                if (!db.on()) break block77;
                                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                            }
                        }
                    }
                    if (moduleModel.getLineModels() != null) {
                        object2 = moduleModel.getLineModels();
                        object = null;
                        for (int i = 0; i < ((InterfaceModel[])object2).length; ++i) {
                            try {
                                Object object6;
                                String string2;
                                block80: {
                                    block79: {
                                        block78: {
                                            if (!(object2[i] instanceof DwdmTrkLineModel) || ((AbstractDwdmLineModel)(object3 = (DwdmTrkLineModel)object2[i])).isProtectLine()) continue;
                                            string = "" + ((DwdmTrkLineModel)object2[i]).getPortModel().getPortNum()[0];
                                            try {
                                                object5 = "WL";
                                                string2 = Wavelength.getWavelengthStringFromWavelength(((DwdmTrkLineModel)object3).getActualWaveLength());
                                                object6 = string2.substring(0, string2.length() - 3);
                                                if (!((String)object6).equals("AUTOP")) {
                                                    this.appendParameter(element, moduleModel, string, (String)object5, (String)object6);
                                                }
                                            }
                                            catch (NoSuchInterface noSuchInterface) {
                                                if (db.on()) {
                                                    SDebug.printStackTrace((Throwable)noSuchInterface);
                                                }
                                            }
                                            catch (WrongInterfaceType wrongInterfaceType) {
                                                if (!db.on()) break block78;
                                                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                                            }
                                        }
                                        object5 = null;
                                        try {
                                            string2 = "OTN";
                                            if (((DwdmTrkLineModel)object3).getOTNStatus()) {
                                                object6 = object5 = "enable";
                                                this.appendParameter(element, moduleModel, string, string2, (String)object6);
                                            }
                                        }
                                        catch (NoSuchInterface noSuchInterface) {
                                            if (db.on()) {
                                                SDebug.printStackTrace((Throwable)noSuchInterface);
                                            }
                                        }
                                        catch (WrongInterfaceType wrongInterfaceType) {
                                            if (!db.on()) break block79;
                                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                                        }
                                    }
                                    try {
                                        string2 = "FEC";
                                        object6 = null;
                                        if (((DwdmTrkLineModel)object3).getFECMode().equals(eDwdmFecMode.DISABLE_FEC)) {
                                            object6 = "disable";
                                        } else if (((DwdmTrkLineModel)object3).getFECMode().equals(eDwdmFecMode.STANDARD_FEC)) {
                                            object6 = "enable";
                                        } else if (((DwdmTrkLineModel)object3).getFECMode().equals(eDwdmFecMode.ENHANCED_FEC)) {
                                            object6 = "enhanced";
                                        }
                                        String string3 = object6;
                                        if (!((String)object6).equals("disable")) {
                                            this.appendParameter(element, moduleModel, string, string2, string3);
                                        }
                                    }
                                    catch (NoSuchInterface noSuchInterface) {
                                        if (db.on()) {
                                            SDebug.printStackTrace((Throwable)noSuchInterface);
                                        }
                                    }
                                    catch (WrongInterfaceType wrongInterfaceType) {
                                        if (!db.on()) break block80;
                                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                                    }
                                }
                                try {
                                    string2 = "MLSE";
                                    if (!((DwdmTrkLineModel)object3).isMlseEnabled()) continue;
                                    object6 = object5 = "enable";
                                    this.appendParameter(element, moduleModel, string, string2, (String)object6);
                                }
                                catch (EMCProvisionError eMCProvisionError) {
                                    if (!db.on()) continue;
                                    SDebug.printStackTrace((Throwable)((Object)eMCProvisionError));
                                }
                                catch (NoSuchInterface noSuchInterface) {
                                    if (!db.on()) continue;
                                    SDebug.printStackTrace((Throwable)noSuchInterface);
                                }
                                catch (WrongInterfaceType wrongInterfaceType) {
                                    if (!db.on()) continue;
                                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                                }
                                continue;
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                if (!db.on()) continue;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                        }
                    }
                    if (moduleModel instanceof OpticsModuleModel) {
                        block81: {
                            object2 = ((OpticsModuleModel)moduleModel).getOpticsChannelModels();
                            if (object2 != null && ((InterfaceModel[])object2).length > 0) {
                                try {
                                    object = "" + ((AbstractOpticsLineModel)object2[0]).getPortNumber();
                                    object4 = "CH_WL";
                                    object3 = Wavelength.getWavelengthStringFromWavelength(((OpticsChannelModel)object2[0]).getExpectedWaveLength());
                                    string = ((String)object3).substring(0, ((String)object3).length() - 3);
                                    if (!string.equals("AUTOP")) {
                                        this.appendParameter(element, moduleModel, (String)object, (String)object4, string);
                                    }
                                }
                                catch (NoSuchInterface noSuchInterface) {
                                    if (db.on()) {
                                        SDebug.printStackTrace((Throwable)noSuchInterface);
                                    }
                                }
                                catch (WrongInterfaceType wrongInterfaceType) {
                                    if (!db.on()) break block81;
                                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                                }
                            }
                        }
                        if ((object = ((OpticsModuleModel)moduleModel).getOpticsOMSModels()) != null && ((OpticsMultiplexSectionModel[])object).length > 0) {
                            try {
                                object4 = "" + ((AbstractOpticsLineModel)object[0]).getPortNumber();
                                object3 = "BAND_WL";
                                string = ((OpticsMultiplexSectionModel)object[0]).getExpectedBand().toString();
                                if (!string.equals("AUTOP")) {
                                    this.appendParameter(element, moduleModel, (String)object4, (String)object3, string);
                                }
                            }
                            catch (NoSuchInterface noSuchInterface) {
                                if (db.on()) {
                                    SDebug.printStackTrace((Throwable)noSuchInterface);
                                }
                            }
                            catch (WrongInterfaceType wrongInterfaceType) {
                                if (!db.on()) break block82;
                                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                            }
                        }
                    }
                }
                if (moduleModel instanceof TdcuModuleModel) {
                    block83: {
                        object2 = "TDCU_COMPENSATION";
                        object = (OpticsMultiplexSectionModel[])moduleModel;
                        object4 = ((OpticsModuleModel)object).getOpticsLineModels();
                        object3 = null;
                        try {
                            if (((OpticsLineModel[])object4).length > 1) {
                                if (((EntityModel)object).getEqType() == 299) {
                                    int n = object4[1].getCTdcuCompensationValue().value();
                                    object3 = ElementDefaults.getAttributeMap((IModel)object).getAttributeForVal("cTdcuComp", n).getKey();
                                } else if (((EntityModel)object).getEqType() == 298) {
                                    int n = object4[1].getFTdcuCompensationValue().value();
                                    object3 = ElementDefaults.getAttributeMap((IModel)object).getAttributeForVal("fTdcuComp", n).getKey();
                                }
                            }
                        }
                        catch (FeatureUnsupported featureUnsupported) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)featureUnsupported);
                            }
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            if (!db.on()) break block83;
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    this.appendParameter(element, moduleModel, null, (String)object2, ((Object)((String)object3).subSequence(0, ((String)object3).length() - 6)).toString());
                }
                if (moduleModel.getEqType() == 293) {
                    try {
                        object2 = null;
                        object = (OTU2XpModuleModel)moduleModel;
                        int n = ((OTU2XpModuleModel)object).getPort1to3Mode();
                        object2 = this.getOtu2xpMode(n);
                        if (object2 != null) {
                            this.appendParameter(element, moduleModel, null, "Cfg1-3", (String)object2);
                            object2 = null;
                        }
                        if ((object2 = this.getOtu2xpMode(n = ((OTU2XpModuleModel)object).getPort2to4Mode())) != null) {
                            this.appendParameter(element, moduleModel, null, "Cfg2-4", (String)object2);
                            object2 = null;
                        }
                        if ((object2 = this.getOtu2xpMode(n = ((OTU2XpModuleModel)object).getPort3to4Mode())) != null) {
                            this.appendParameter(element, moduleModel, null, "Cfg3-4", (String)object2);
                            object2 = null;
                        }
                        if ((n = ((OTU2XpModuleModel)object).getCardMode()) == 5) {
                            this.appendParameter(element, moduleModel, null, "Cfg1-3-4", "Splitter");
                            object2 = null;
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (!db.on()) break block84;
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
            }
            if ((object2 = this.getCardModeFromInt(moduleModel.getCardOperMode())) != null) {
                if (moduleModel.getEqTypeName().contains("WXC")) {
                    this.appendParameter(element, moduleModel, null, "WXC_MODE", (String)object2);
                } else {
                    this.appendParameter(element, moduleModel, null, "OPERMODE", (String)object2);
                }
            }
            if (moduleModel instanceof DwdmModuleModel) {
                try {
                    int n;
                    object = ((DwdmModuleModel)moduleModel).getFirstTrunkLine();
                    if (object != null && (n = ((AbstractDwdmLineModel)object).getDwdmCardConfig().regenPeerCardIndex) != 0) {
                        this.appendParameter(element, moduleModel, null, "RegenPeerSlot", "" + n);
                    }
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block85;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
    }

    public void getInfo(Document document, NodeModelDelegate nodeModelDelegate) {
        Element element;
        Element element2;
        Element element3;
        Element element4;
        Element element5;
        Element element6;
        block36: {
            Node node;
            Text text;
            Node node2;
            Text text2;
            Node node3;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            IModel iModel;
            Element element7;
            this.xmldoc = document;
            element6 = this.xmldoc.createElementNS(null, "nodesetup");
            element6.setAttributeNS(null, "version", nodeModelDelegate.getSwVersion().substring(0, 5));
            element6.setAttributeNS(null, "descr", nodeModelDelegate.getName() + "_1");
            element5 = this.xmldoc.createElementNS(null, "anp");
            element4 = this.xmldoc.createElementNS(null, "ppms");
            int n = nodeModelDelegate.getChassisModelsInstance().getShelfViewModels().length;
            IOptLinkModel[] iOptLinkModelArray = null;
            element3 = this.xmldoc.createElementNS(null, "parameters");
            for (int i = 0; i < n; ++i) {
                element2 = null;
                Text text3 = null;
                element7 = this.xmldoc.createElementNS(null, "shelf");
                if (nodeModelDelegate.getChassisModelsInstance().getShelfViewModels()[i] instanceof IChassisModel) {
                    iModel = (IChassisModel)nodeModelDelegate.getChassisModelsInstance().getShelfViewModels()[i];
                    element7.setAttributeNS(null, "RUpos", "" + iModel.getRackPosition());
                    element7.setAttributeNS(null, "rackPos", "" + iModel.getRackPosition());
                    element7.setAttributeNS(null, "rackNum", "" + iModel.getRackNumber());
                    element7.setAttributeNS(null, "id", "" + iModel.getShelfId());
                    element7.setAttributeNS(null, "type", iModel.getShelfTypeName());
                    int n2 = this.getNumberOfSlots(iModel.getShelfTypeName());
                    for (int j = 1; j <= n2; ++j) {
                        try {
                            IEntityModel iEntityModel = nodeModelDelegate.getEntityTable().getEntityModelBySlot(iModel.getShelfId(), j);
                            if (iEntityModel != null) {
                                Element element8 = this.xmldoc.createElementNS(null, "slot");
                                element8.setAttributeNS(null, "pos", "" + j);
                                object5 = this.xmldoc.createElementNS(null, "eqtype");
                                if (iEntityModel.getChildren() == null || iEntityModel.getChildren().size() == 0) continue;
                                object4 = null;
                                element2 = (IModuleModel)iEntityModel.getChildren().get(0);
                                object3 = element2.getDescendantsOfEqType(eEqType.PPM_1_PORT.value());
                                if (object3 != null) {
                                    for (int k = 0; k < object3.size(); ++k) {
                                        object2 = this.xmldoc.createElementNS(null, "ppm");
                                        object = (PpmModel)object3.get(k);
                                        node3 = this.xmldoc.createElementNS(null, "ppmshelf");
                                        text2 = this.xmldoc.createTextNode("" + ((EntityModel)object).getShelfId());
                                        node3.appendChild(text2);
                                        node2 = this.xmldoc.createElementNS(null, "ppmslot");
                                        text = this.xmldoc.createTextNode("" + ((EntityModel)object).getSlot());
                                        node2.appendChild(text);
                                        node = this.xmldoc.createElementNS(null, "ppmnum");
                                        Text text4 = this.xmldoc.createTextNode("" + ((EntityModel)object).getParent().getPositionInParent());
                                        node.appendChild(text4);
                                        Element element9 = this.xmldoc.createElementNS(null, "ppmtype");
                                        Text text5 = this.xmldoc.createTextNode(((EntityModel)object).getEqTypeName());
                                        element9.appendChild(text5);
                                        Node node4 = null;
                                        Element element10 = null;
                                        Element element11 = null;
                                        for (int i2 = 0; i2 < ((EntityModel)object).getChildren().size(); ++i2) {
                                            if (((EntityModel)object).getChildren().get(i2) instanceof DwdmPortModel) continue;
                                            element10 = this.xmldoc.createElementNS(null, "ppmport");
                                            PortModel portModel = (PortModel)((EntityModel)object).getChildren().get(i2);
                                            String string = portModel.getPortString();
                                            Text text6 = this.xmldoc.createTextNode(string.substring(0, string.indexOf("(") - 1));
                                            element10.appendChild(text6);
                                            node4 = this.xmldoc.createTextNode(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
                                            element11 = this.xmldoc.createElementNS(null, "ppmporttype");
                                            element11.appendChild(node4);
                                        }
                                        object2.appendChild(node3);
                                        object2.appendChild(node2);
                                        object2.appendChild(node);
                                        object2.appendChild(element9);
                                        if (node4 != null && element10 != null && element11 != null && !node4.getTextContent().contains("Client")) {
                                            object2.appendChild(element10);
                                            object2.appendChild(element11);
                                        }
                                        element4.appendChild((Node)object2);
                                    }
                                }
                                object4 = element2.getEqTypeName().equals("40 DMX CO") || element2.getEqTypeName().equals("40 DMX CE") ? "40 DMX C" : (element2.getEqTypeName().equals("40 WSS CO") || element2.getEqTypeName().equals("40 WSS CE") ? "40 WSS C" : element2.getEqTypeName());
                                text3 = this.xmldoc.createTextNode((String)object4);
                                object5.appendChild(text3);
                                if (!element2.getEqTypeName().equalsIgnoreCase("MS-ISC-100T")) {
                                    this.getParameters((ModuleModel)((Object)element2), element3);
                                }
                                element8.appendChild((Node)object5);
                                element7.appendChild(element8);
                                continue;
                            }
                            break;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                            break;
                        }
                    }
                } else if (nodeModelDelegate.getChassisModelsInstance().getShelfViewModels()[i] instanceof PassiveChassisModel) {
                    iModel = nodeModelDelegate.getChassisModelsInstance().getShelfViewModels()[i];
                    PassiveChassisModel passiveChassisModel = (PassiveChassisModel)iModel;
                    String string = passiveChassisModel.getNumberOfSlots() > 1 ? passiveChassisModel.getRUOccupied() + "/" + passiveChassisModel.getNumberOfSlots() : "" + passiveChassisModel.getRUOccupied();
                    element7.setAttributeNS(null, "RUsize", string);
                    element7.setAttributeNS(null, "RUpos", "" + passiveChassisModel.getRackPosition());
                    element7.setAttributeNS(null, "rackPos", "" + passiveChassisModel.getRackPosition());
                    element7.setAttributeNS(null, "rackNum", "" + passiveChassisModel.getRackNumber());
                    element7.setAttributeNS(null, "type", passiveChassisModel.getShelfTypeName());
                    int n3 = passiveChassisModel.getNumberOfSlots();
                    for (int j = 0; j < n3; ++j) {
                        object5 = passiveChassisModel.getChildOfSlotNumber(j + 1);
                        if (object5 == null) continue;
                        object4 = this.createPassiveElement((PassiveModuleModel)object5, passiveChassisModel);
                        element7.appendChild((Node)object4);
                        if (!((PassiveModuleModel)object5).getEqTypeName().contains("DCU")) continue;
                        try {
                            object3 = this.xmldoc.createTextNode("DCU_COMPENSATION");
                            Text text7 = this.xmldoc.createTextNode("" + ((PassiveModuleModel)object5).getID());
                            object2 = ((PassiveModuleModel)object5).getDCUCompensation();
                            if (object2 == null || ((String)object2).length() <= 6) continue;
                            object = this.xmldoc.createTextNode(((Object)((String)object2).subSequence(0, ((String)object2).length() - 6)).toString());
                            this.addParameters(element3, null, null, text7, null, (Node)object3, (Node)object);
                            continue;
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            if (!db.on()) continue;
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    if (passiveChassisModel.hasPassiveContainer() && passiveChassisModel.getInnerChild() != null) {
                        element7.appendChild(this.createPassiveElement(passiveChassisModel.getInnerChild(), passiveChassisModel));
                    }
                }
                if (!element7.hasChildNodes()) continue;
                element5.appendChild(element7);
            }
            ISideModel[] iSideModelArray = nodeModelDelegate.getSideModelsModel().getSides();
            element2 = this.xmldoc.createElementNS(null, "sides");
            if (iSideModelArray != null) {
                for (int i = 0; i < iSideModelArray.length; ++i) {
                    try {
                        element7 = this.xmldoc.createElementNS(null, "side");
                        iModel = (PortModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(iSideModelArray[i].getLineIn());
                        PortModel portModel = (PortModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(iSideModelArray[i].getLineOut());
                        Element element12 = this.xmldoc.createElementNS(null, "side_name");
                        Element element13 = this.xmldoc.createElementNS(null, "shelf_in");
                        Element element14 = this.xmldoc.createElementNS(null, "shelf_out");
                        object5 = this.xmldoc.createElementNS(null, "slot_in");
                        object4 = this.xmldoc.createElementNS(null, "slot_out");
                        object3 = this.xmldoc.createElementNS(null, "port_in");
                        Element element15 = this.xmldoc.createElementNS(null, "port_out");
                        object2 = this.xmldoc.createTextNode(iSideModelArray[i].getNameLabel());
                        object = this.xmldoc.createTextNode("" + iModel.getShelfId());
                        node3 = this.xmldoc.createTextNode("" + portModel.getShelfId());
                        text2 = this.xmldoc.createTextNode("" + iModel.getSlot());
                        node2 = this.xmldoc.createTextNode("" + portModel.getSlot());
                        text = this.xmldoc.createTextNode("" + iModel.getPortNum()[0]);
                        node = this.xmldoc.createTextNode("" + portModel.getPortNum()[0]);
                        element12.appendChild((Node)object2);
                        element13.appendChild((Node)object);
                        element14.appendChild(node3);
                        object5.appendChild(text2);
                        object4.appendChild(node2);
                        object3.appendChild(text);
                        element15.appendChild(node);
                        element7.appendChild(element12);
                        element7.appendChild(element13);
                        element7.appendChild((Node)object5);
                        element7.appendChild((Node)object3);
                        element7.appendChild(element14);
                        element7.appendChild((Node)object4);
                        element7.appendChild(element15);
                        element2.appendChild(element7);
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) continue;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            element = this.xmldoc.createElementNS(null, "patchcords");
            element7 = nodeModelDelegate.getIOpticalPatchCordModel();
            if (element7 != null) {
                try {
                    iOptLinkModelArray = element7.getIOptLinkModels();
                    for (int i = 0; i < iOptLinkModelArray.length; ++i) {
                        Element element16 = this.xmldoc.createElementNS(null, "patchcord");
                        Element[] elementArray = this.patchcordFromArray(iOptLinkModelArray[i].getFromModel());
                        Element[] elementArray2 = this.patchcordToArray(iOptLinkModelArray[i].getToModel());
                        for (int j = 0; j <= 2; ++j) {
                            if (elementArray[j] != null) {
                                element16.appendChild(elementArray[j]);
                            }
                            if (elementArray2[j] == null) continue;
                            element16.appendChild(elementArray2[j]);
                        }
                        element.appendChild(element16);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                catch (FeatureUnsupported featureUnsupported) {
                    if (!db.on()) break block36;
                    SDebug.printStackTrace((Throwable)featureUnsupported);
                }
            }
        }
        Element element17 = this.getANSParameters(nodeModelDelegate);
        element6.appendChild(element5);
        if (element3.hasChildNodes()) {
            element6.appendChild(element3);
        }
        if (element4.hasChildNodes()) {
            element6.appendChild(element4);
        }
        if (element.hasChildNodes()) {
            element6.appendChild(element);
        }
        if (element2.hasChildNodes()) {
            element6.appendChild(element2);
        }
        if (element17.hasChildNodes()) {
            element6.appendChild(element17);
        }
        this.xmldoc.getFirstChild().appendChild(element6);
    }
}

