/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.nodesetup.AbstractNodeSetupPreDialog;
import cerent.cms.ui.nodesetup.AnpManager;
import cerent.cms.ui.nodesetup.AnsManager;
import cerent.cms.ui.nodesetup.LayoutManager;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.ParamsManager;
import cerent.cms.ui.nodesetup.PassiveUnitsManager;
import cerent.cms.ui.nodesetup.PatchcordsManager;
import cerent.cms.ui.nodesetup.PpmManager;
import cerent.cms.ui.nodesetup.SidesManager;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.cms.ui.nodesetup.WzTasksController;
import cerent.util.SDebug;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NodeSetupWizard
extends AbstractNodeSetupPreDialog
implements ItemListener {
    private JCheckBox anpCB;
    private JCheckBox passiveUnitsCB;
    private JCheckBox ppmCB;
    private JCheckBox ansCB;
    private JCheckBox paramsCB;
    private JCheckBox patchcordsCB;
    private JCheckBox sidesCB;
    private JCheckBox selectAllCB;
    private JCheckBox quickProvCB;
    private JCheckBox saveOnNodeCB;

    public NodeSetupWizard(Frame frame, NsdWizardInfo nsdWizardInfo, boolean bl, boolean bl2, SDebug sDebug) {
        super(frame, bl, "Node Setup for ", nsdWizardInfo, sDebug);
        this.saveOnNodeCB.setEnabled(bl2);
        this.saveOnNodeCB.setSelected(bl2);
        this.saveOnNodeCB.setVisible(bl2);
        this.dbg.info("NodeSetupWizard() initialized");
    }

    @Override
    protected JPanel getRightPane() {
        this.dbg.info("Entered NodeSetupWizard.getRightPane()");
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("Choose setup components:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = AbstractPane.createVerticalPanel(null);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(45, 45, 45, 45));
        this.anpCB = new JCheckBox("Node/Shelves Layout");
        this.anpCB.addItemListener(this);
        this.passiveUnitsCB = new JCheckBox("Passive Units Layout");
        this.passiveUnitsCB.addItemListener(this);
        this.ppmCB = new JCheckBox("Pluggable Port Modules");
        this.ppmCB.addItemListener(this);
        this.paramsCB = new JCheckBox("Card Parameters");
        this.paramsCB.addItemListener(this);
        this.patchcordsCB = new JCheckBox("Internal Patchcords");
        this.patchcordsCB.addItemListener(this);
        this.sidesCB = new JCheckBox("Optical Sides");
        this.sidesCB.addItemListener(this);
        this.ansCB = new JCheckBox("ANS Parameters");
        this.ansCB.addItemListener(this);
        this.selectAllCB = new JCheckBox("Select All");
        this.selectAllCB.addItemListener(this);
        jPanel3.add(this.anpCB);
        jPanel3.add(this.passiveUnitsCB);
        jPanel3.add(this.ppmCB);
        jPanel3.add(this.paramsCB);
        jPanel3.add(this.patchcordsCB);
        jPanel3.add(this.sidesCB);
        jPanel3.add(this.ansCB);
        jPanel3.add(this.selectAllCB);
        this.anpCB.setEnabled(this.wizardInfo.isAnpPresent());
        this.passiveUnitsCB.setEnabled(this.wizardInfo.isPassiveUnitsPresent());
        this.ppmCB.setEnabled(this.wizardInfo.isPpmPresent());
        this.paramsCB.setEnabled(this.wizardInfo.isParamPresent());
        this.patchcordsCB.setEnabled(this.wizardInfo.isPatchcordsPresent());
        this.sidesCB.setEnabled(this.wizardInfo.isSidesPresent());
        this.ansCB.setEnabled(this.wizardInfo.isAnsPresent());
        this.selectAllCB.setEnabled(true);
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.quickProvCB = new JCheckBox("Skip Interactive Mode");
        this.quickProvCB.setEnabled(false);
        this.quickProvCB.addItemListener(this);
        this.saveOnNodeCB = new JCheckBox("Save Installation Files (XML and log) On Node");
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.quickProvCB);
        jPanel.add(this.saveOnNodeCB);
        return jPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItemSelectable() == this.quickProvCB) {
                this.wizardInfo.setQuickProv(true);
            } else {
                this.quickProvCB.setEnabled(true);
                this.setNextEnabled(true);
                if (itemEvent.getItemSelectable() == this.selectAllCB) {
                    this.setAllSelected(true);
                }
            }
        } else {
            if (!(this.ansCB.isSelected() || this.ppmCB.isSelected() || this.anpCB.isSelected() || this.paramsCB.isSelected() || this.patchcordsCB.isSelected() || this.sidesCB.isSelected() || this.passiveUnitsCB.isSelected())) {
                this.quickProvCB.setEnabled(false);
                this.setNextEnabled(false);
            }
            if (itemEvent.getItemSelectable() == this.quickProvCB) {
                this.wizardInfo.setQuickProv(false);
            } else if (itemEvent.getItemSelectable() != this.selectAllCB) {
                this.selectAllCB.setSelected(false);
            }
        }
    }

    @Override
    protected void handleNext() {
        this.dbg.info("Entered NodeSetupWizard.handleNext()");
        if (!this.validatePage()) {
            return;
        }
        NodeSetupDialog nodeSetupDialog = new NodeSetupDialog(this, this.wizardInfo, this.parent, this.makeModal);
        this.setVisible(false);
        if (!this.wizardInfo.isQuickProv()) {
            nodeSetupDialog.showModal();
            this.dispose();
        } else {
            this.ctcQuickProvisioning();
        }
    }

    private boolean validatePage() {
        this.dbg.info("Entered NodeSetupWizard.validatePage()");
        this.wizardInfo.setAnsSelected(this.ansCB.isSelected());
        this.wizardInfo.setPpmSelected(this.ppmCB.isSelected());
        this.wizardInfo.setAnpSelected(this.anpCB.isSelected());
        this.wizardInfo.setPassiveUnitsSelected(this.passiveUnitsCB.isSelected());
        this.wizardInfo.setParamSelected(this.paramsCB.isSelected());
        this.wizardInfo.setPatchcordsSelected(this.patchcordsCB.isSelected());
        this.wizardInfo.setSidesSelected(this.sidesCB.isSelected());
        this.wizardInfo.setSaveOnNode(this.saveOnNodeCB.isSelected());
        return true;
    }

    private void setAllSelected(boolean bl) {
        this.ansCB.setSelected(bl && this.ansCB.isEnabled());
        this.ppmCB.setSelected(bl && this.ppmCB.isEnabled());
        this.anpCB.setSelected(bl && this.anpCB.isEnabled());
        this.paramsCB.setSelected(bl && this.paramsCB.isEnabled());
        this.patchcordsCB.setSelected(bl && this.patchcordsCB.isEnabled());
        this.sidesCB.setSelected(bl && this.sidesCB.isEnabled());
        this.passiveUnitsCB.setSelected(bl && this.passiveUnitsCB.isEnabled());
    }

    private void ctcQuickProvisioning() {
        this.dbg.info("Entered NodeSetupWizard.ctcQuickProvisioning()");
        Vector<WzTask> vector = new Vector<WzTask>();
        Thread thread = null;
        if (this.wizardInfo.isAnpSelected()) {
            for (int i = 0; i < this.wizardInfo.getAnp().size(); ++i) {
                vector.addElement(new AnpManager(this.wizardInfo, i, this.wizardInfo.getNmd()));
            }
        }
        if (this.wizardInfo.isPassiveUnitsSelected()) {
            vector.addElement(new PassiveUnitsManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        if (this.wizardInfo.isAnpSelected() || this.wizardInfo.isPassiveUnitsSelected()) {
            vector.addElement(new LayoutManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        if (this.wizardInfo.isPpmSelected()) {
            vector.addElement(new PpmManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        if (this.wizardInfo.isParamSelected()) {
            vector.addElement(new ParamsManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        if (this.wizardInfo.isPatchcordsSelected()) {
            vector.addElement(new PatchcordsManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        if (this.wizardInfo.isSidesSelected()) {
            vector.addElement(new SidesManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        if (this.wizardInfo.isAnsSelected()) {
            vector.addElement(new AnsManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        thread = new Thread(new WzTasksController(vector, this.wizardInfo, false));
        thread.start();
    }
}

